from os import (
    path as os_path,
    mkdir as os_mkdir
)

from requests import get as r_get

from tempfile import (
    NamedTemporaryFile
)

import argparse

def download(
    url: str,
    file: str = ""
) -> str:
    """
    Download a file from 'url' and save it as 'file'.
    Parameters:
    url  -- URL the file is downloaded from
    file -- (Optional) filename the downloaded file is saved into (default: "")
    Returns:
    A filename where the downloaded file has stored into
    """
    r = r_get(url)
    if not file:
        f = NamedTemporaryFile(
            mode='wb',
            delete=False
        )
        file = f.name
    else:
        f = open(file, 'wb')
    f.write(r.content)
    f.close()
    return file

parser = argparse.ArgumentParser(description="Download a cache file")
parser.add_argument('-u','--url', required=True, default=None, type=str, help="URL the file is downloaded from")
parser.add_argument('-o','--outfile', required=True, default=None, type=str, help="A filename where the downloaded file has stored into")

args = parser.parse_args()

url= args.url #"https://gitlab.com/breakthewall/rrCache-data/-/raw/master/"
filename= os_path.basename(args.outfile) #"cid_strc.json.gz"
cache_dir=os_path.dirname(args.outfile) #'${GALAXY_DATA_MANAGER_DATA_PATH}'+'/rpextractsink/cache/'
full_filename=os_path.join(cache_dir,filename) #'${GALAXY_DATA_MANAGER_DATA_PATH}'+'/rpextractsink/cache/cid_strc.json.gz'

if not os_path.isdir(cache_dir):
    os_mkdir(cache_dir)

download(url+filename, full_filename)