#!/usr/bin/perl

#  velvet_optimiser_vlsci.pl
#  
#  Copyright 2012 Simon <simon@Hyperion>
#  
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#  MA 02110-1301, USA.
#  
#  

use strict;
use warnings;
use File::Copy;
use Env qw (PATH);

my @stuff = @ARGV;
my %counts;
my %shortMPs;
my @reads;
my $threadsToUse = 2;   #According to Enis, this is the default number of threads that multithreaded programs use..

#TO DO! get velvet compile parameters!

foreach my $param (@stuff){
    if($param =~ m/galaxy\.datatypes/){
        $param =~m/datatypes\..+\.(.+)\s+object/;
        my $type = lc($1);
        print "$type\n";
    }
    else {
        print $param . "\n";
    }
}

#try and split some of it up..
#my $VOPT_PATH = shift @stuff;

#kmer stuff
my $sk = shift @stuff;
my $ek = shift @stuff;
my $xk = shift @stuff;

#TO DO! do checks etc on this stuff here!

#get the read file stuff
my $i = 0;

while(!($stuff[0] =~ m/other:/)){
    my $index = shift @stuff;
    my $read_type = shift @stuff;
    my $sep = shift @stuff;
    my $file_type = shift @stuff;
    $file_type =~m/datatypes\..+\.(.+)\s+object/;
    $file_type = lc($1);
    $file_type = "fastq" if $file_type =~ m/fastq/i;
    $counts{$read_type} ++;
    my $ffile = shift @stuff;
    my $rfile = shift @stuff if $sep eq "True";
    my $sMP = shift @stuff;
    $reads[$i] = "-$read_type";
    $reads[$i] .= $counts{$read_type} if $counts{$read_type} > 1;
    if ($sMP eq "shortMP_lib"){
        my $temp = "-shortMatePaired";
        $temp .= $counts{$read_type} if $counts{$read_type} > 1;
        $shortMPs{$temp} = 1;
    }
    $reads[$i] .= " -$file_type";
    $reads[$i] .= " -separate" if $sep eq "True";
    $reads[$i] .= " $ffile";
    $reads[$i] .= " $rfile" if $sep eq "True";
    $i ++;
}

#get the other stuff
shift @stuff if $stuff[0] =~ m/other:/;
my $amos = shift @stuff;
my $verbose = shift @stuff;

#get the advanced stuff if it exists!
my ($oFK, $oFC, $vgO, $minC, $maxC);
if ($stuff[0] =~ m/advanced:/) {
    shift @stuff;
    $oFK = shift @stuff;
    $oFC = shift @stuff;
    $vgO = shift @stuff;
    $minC = shift @stuff;
    $maxC = shift @stuff;
}

#get the output file names!
my $contigs_outfile = shift @stuff;
my $stats_outfile = shift @stuff;
my $afg_outfile = shift @stuff if $amos eq "amos";
my $logfile = shift @stuff;
my $stderr = shift @stuff;
my $lgraph = shift @stuff;

#build the command line...

my $cmd = "VelvetOptimiser.pl -d temp_vgo_files -s $sk -e $ek -x $xk";
$cmd .= " -a" if($amos eq "amos");
$cmd .= " -v" if($verbose eq "verbose");

$cmd .= " -f '";
foreach my $line (@reads){
    $cmd .= " $line";
}
$cmd .= "'";

my $vgopt = $vgO;
foreach my $key(keys %shortMPs){
    $vgopt .= " $key" if $key;
}

$cmd .= " -o '$vgopt'" if $vgopt;

$cmd .= " -k $oFK" if $oFK;
$cmd .= " -c $oFC" if $oFC;
$cmd .= " -m $minC" if $minC;
$cmd .= " -z $maxC" if $maxC;
$cmd .= " -t $threadsToUse";

$cmd .= " 2> $stderr";

print "\n$cmd\n";
print "PATH= $PATH\n";

print "about to run the command!\n";

if(system($cmd) == 0) {
    #copy the files to the new places and delete the directory..
    print "Copying output\n";
    copy("temp_vgo_files/contigs.fa", $contigs_outfile);
    copy("temp_vgo_files/stats.txt", $stats_outfile);
    copy(glob("temp_vgo_files/*Logfile.txt"), $logfile);
    copy("temp_vgo_files/velvet_asm.afg", $afg_outfile) if $amos eq "amos";
    copy("temp_vgo_files/LastGraph", $lgraph);
    system("rm -rf temp_vgo_files") == 0 or die "Couldn't delete temporary directory. $!";
}
else {
    print "There was a velvet optimiser error\n";
    exit(1);
}

exit(0);
