/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.fastq;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.zip.GZIPOutputStream;
import org.itadaki.bzip2.BZip2OutputStream;
import org.usadellab.trimmomatic.fastq.FastqRecord;

public class FastqSerializer {
    private PrintStream stream;
    private File inputFile;

    public void open(File file) throws IOException {
        String name = file.getName();
        this.inputFile = file;
        this.stream = name.endsWith(".gz") ? new PrintStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file)), 1000000)) : (name.endsWith(".bz2") ? new PrintStream(new BufferedOutputStream(new BZip2OutputStream(new FileOutputStream(file)), 1000000)) : new PrintStream(new BufferedOutputStream(new FileOutputStream(file), 1000000)));
    }

    public void open(PrintStream stream) throws IOException {
        this.stream = new PrintStream(stream);
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public synchronized void writeRecord(FastqRecord record) {
        this.stream.println("@" + record.getName());
        this.stream.println(record.getSequence());
        this.stream.println("+" + record.getComment());
        this.stream.println(record.getQuality());
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File file) {
        this.inputFile = file;
    }
}

