/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.fastq;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.itadaki.bzip2.BZip2InputStream;
import org.usadellab.trimmomatic.fastq.FastqRecord;

public class FastqParser {
    private int phredOffset;
    private BufferedReader reader;
    private FastqRecord current;
    private AtomicInteger progress;
    private long fileLength;
    private long bytesRead;
    private EOL_TYPE eoltype;

    public FastqParser(int phredOffset) {
        this.phredOffset = phredOffset;
        this.progress = new AtomicInteger(0);
        this.bytesRead = 0L;
    }

    public void parseOne() throws IOException {
        this.current = null;
        String line = this.reader.readLine();
        if (line == null) {
            this.progress.set(100);
            return;
        }
        this.bytesRead += (long)(line.length() + this.eoltype.getByteSize());
        if (!line.startsWith("@")) {
            throw new RuntimeException("Invalid FASTQ name line: " + line);
        }
        String name = line.substring(1);
        String sequence = this.reader.readLine();
        this.bytesRead += (long)(line.length() + this.eoltype.getByteSize());
        line = this.reader.readLine();
        this.bytesRead += (long)(line.length() + this.eoltype.getByteSize());
        if (!line.startsWith("+")) {
            throw new RuntimeException("Invalid FASTQ comment line: " + line);
        }
        String comment = line.substring(1);
        String quality = this.reader.readLine();
        this.bytesRead += (long)(line.length() + this.eoltype.getByteSize());
        this.current = new FastqRecord(name, sequence, comment, quality, this.phredOffset);
        this.progress.set((int)((float)this.bytesRead / (float)this.fileLength * 100.0f));
    }

    public int getProgress() {
        return this.progress.get();
    }

    public void parse(File file) throws IOException {
        String name = file.getName();
        this.fileLength = file.length();
        this.eoltype = FastqParser.guessEOLType(file);
        this.reader = name.toLowerCase().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file), 1000000)))) : (name.toLowerCase().endsWith(".bz2") ? new BufferedReader(new InputStreamReader(new BZip2InputStream(new BufferedInputStream(new FileInputStream(file), 1000000), false))) : (name.toLowerCase().endsWith(".zip") ? new BufferedReader(new InputStreamReader(new ZipInputStream(new BufferedInputStream(new FileInputStream(file), 1000000)))) : new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(file), 1000000)))));
        this.parseOne();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean hasNext() {
        return this.current != null;
    }

    public FastqRecord next() throws IOException {
        FastqRecord current = this.current;
        this.parseOne();
        return current;
    }

    public static EOL_TYPE guessEOLType(File f) throws FileNotFoundException, IOException {
        InputStreamReader isr = new InputStreamReader(new FileInputStream(f));
        while (isr.ready()) {
            char symbol = (char)isr.read();
            if (symbol == '\n') {
                isr.close();
                return EOL_TYPE.UNIX;
            }
            if (symbol != '\r') continue;
            if (isr.read() == 10) {
                isr.close();
                return EOL_TYPE.WINDOWS;
            }
            isr.close();
            return EOL_TYPE.MACINTOSH;
        }
        return EOL_TYPE.UNKNOWN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EOL_TYPE {
        WINDOWS(2),
        UNIX(1),
        MACINTOSH(1),
        UNKNOWN(0);

        private int byteSize;

        private EOL_TYPE(int size) {
            this.byteSize = size;
        }

        public int getByteSize() {
            return this.byteSize;
        }
    }
}

