/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.fastq.trim;

import org.usadellab.trimmomatic.fastq.FastqRecord;
import org.usadellab.trimmomatic.fastq.trim.AbstractSingleRecordTrimmer;

public class LeadingTrimmer
extends AbstractSingleRecordTrimmer {
    private int qual;

    public LeadingTrimmer(String args) {
        this.qual = Integer.parseInt(args);
    }

    public LeadingTrimmer(int qual) {
        this.qual = qual;
    }

    public FastqRecord processRecord(FastqRecord in) {
        String seq = in.getSequence();
        int[] quals = in.getQualityAsInteger(true);
        for (int i = 0; i < seq.length(); ++i) {
            if (quals[i] < this.qual) continue;
            return new FastqRecord(in, i, seq.length() - i);
        }
        return null;
    }
}

