/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.usadellab.trimmomatic.fastq.FastqParser;
import org.usadellab.trimmomatic.fastq.FastqRecord;
import org.usadellab.trimmomatic.fastq.FastqSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pairomatic {
    private Set<String> getFastqNames(File file, Character delimiter) throws IOException {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        FastqParser parser = new FastqParser(0);
        parser.parse(file);
        while (parser.hasNext()) {
            FastqRecord rec = parser.next();
            String name = rec.getName();
            if (delimiter != null) {
                int index = name.lastIndexOf(delimiter.charValue());
                if (index == -1) {
                    throw new RuntimeException("Error: Failed to find expected delimiter '" + delimiter + "' in record named '" + name + "'");
                }
                name = name.substring(0, index);
            }
            if (names.contains(name)) {
                throw new RuntimeException("Error: Found " + name + " more than once in file - check delimiter is correct '" + delimiter + "'");
            }
            names.add(name);
        }
        return names;
    }

    private boolean equalOrdering(Set<String> set1, Set<String> set2) {
        if (set1.size() != set2.size()) {
            return false;
        }
        Iterator<String> iter1 = set1.iterator();
        Iterator<String> iter2 = set2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            String str2;
            String str1 = iter1.next();
            if (str1.equals(str2 = iter2.next())) continue;
            return false;
        }
        if (iter1.hasNext()) {
            return false;
        }
        return !iter2.hasNext();
    }

    private void splitFastq(File input, File match, File unmatch, Set<String> toKeep, Character delimiter) throws IOException {
        FastqParser parser = new FastqParser(0);
        parser.parse(input);
        FastqSerializer matchSerializer = new FastqSerializer();
        matchSerializer.open(match);
        FastqSerializer unmatchSerializer = new FastqSerializer();
        unmatchSerializer.open(unmatch);
        while (parser.hasNext()) {
            FastqRecord rec = parser.next();
            String name = rec.getName();
            if (delimiter != null) {
                int index = name.indexOf(delimiter.charValue());
                if (index == -1) {
                    throw new RuntimeException("Failed to find expected delimiter '" + delimiter + "' in record named '" + name + "'");
                }
                name = name.substring(0, index);
            }
            if (toKeep.contains(name)) {
                matchSerializer.writeRecord(rec);
                continue;
            }
            unmatchSerializer.writeRecord(rec);
        }
        matchSerializer.close();
        unmatchSerializer.close();
    }

    public void process(File input1, File input2, File output1P, File output1U, File output2P, File output2U, Character delimiter) throws IOException {
        Set<String> names1 = this.getFastqNames(input1, delimiter);
        System.out.println("First input file contains " + names1.size() + " records");
        Set<String> names2 = this.getFastqNames(input2, delimiter);
        System.out.println("Second input file contains " + names2.size() + " records");
        names1.retainAll(names2);
        System.out.println("Files shared " + names1.size() + " records");
        names2.retainAll(names1);
        if (!this.equalOrdering(names1, names2)) {
            System.out.println("Error: Common records are not in identical order, cowardly refusing to do anything");
            return;
        }
        System.out.println("Splitting first file");
        this.splitFastq(input1, output1P, output1U, names1, delimiter);
        System.out.println("Splitting second file");
        this.splitFastq(input2, output2P, output2U, names1, delimiter);
        System.out.println("All done");
    }

    public static void main(String[] args) throws IOException {
        int argIndex = 0;
        Character delim = null;
        boolean badOption = false;
        while (argIndex < args.length && args[argIndex].startsWith("-")) {
            String arg;
            if ((arg = args[argIndex++]).equals("-delim")) {
                String delimStr;
                if ((delimStr = args[argIndex++]).length() != 1) {
                    System.out.println("Delimiter must be exactly one character, got '" + delimStr + "'");
                    continue;
                }
                delim = Character.valueOf(delimStr.charAt(0));
                continue;
            }
            System.out.println("Unknown option " + arg);
            badOption = true;
        }
        if (args.length - argIndex < 6 || badOption) {
            System.out.println("Usage: Pairomatic [-delim delimChar] <inputFile1> <inputFile2> <outputFile1P> <outputFile1U> <outputFile2P> <outputFile2U>");
            System.exit(1);
        }
        File input1 = new File(args[argIndex++]);
        File input2 = new File(args[argIndex++]);
        File output1P = new File(args[argIndex++]);
        File output1U = new File(args[argIndex++]);
        File output2P = new File(args[argIndex++]);
        File output2U = new File(args[argIndex++]);
        Pairomatic pm = new Pairomatic();
        pm.process(input1, input2, output1P, output1U, output2P, output2U, delim);
    }
}

