#!/usr/bin/env python
"""
Run panama on expression and snp data
usage: panama_run.py [options]
   --exp_data: Expression data CSV file
   --snp_data: SNP data file
   --output1: Output CSV dataset
"""

import optparse, os, sys, subprocess, tempfile, shutil
from galaxy import eggs
import pkg_resources; pkg_resources.require( "bx-python" )
from bx.cookbook import doc_optparse
from galaxy import util

def stop_err( msg ):
    sys.stderr.write( '%s\n' % msg )
    sys.exit()



def __main__():
    #Parse Command Line
    parser = optparse.OptionParser()
    parser.add_option( '', '--exp_data', dest='exp_data', help='The input Expression dataset')
    parser.add_option( '', '--snp_data', dest='snp_data', help='The input snp dataset' )
    parser.add_option( '', '--output1', dest='output1', help='The output CSV dataset' )
    ( options, args ) = parser.parse_args()

    try:
        tmp_dir = tempfile.mkdtemp()
        panama_output_file_name = os.path.join(tmp_dir, "PANAMA_results.csv")
        command = 'panama %s %s -d %s' %(options.exp_data,options.snp_data,tmp_dir)
        print command
        tmp = tempfile.NamedTemporaryFile( dir=tmp_dir ).name
        tmp_stderr = open( tmp, 'wb' )
        proc = subprocess.Popen( args=command, shell=True, stderr=tmp_stderr.fileno() )
        returncode = proc.wait()
        tmp_stderr.close()
        # get stderr, allowing for case where it's very large
        tmp_stderr = open( tmp, 'rb' )
        stderr = ''
        buffsize = 1048576
        try:
            while True:
                stderr += tmp_stderr.read( buffsize )
                if not stderr or len( stderr ) % buffsize != 0:
                    break
        except OverflowError:
            pass
        tmp_stderr.close()
        if returncode != 0:
            raise Exception, stderr
    except Exception, e:
        #clean up temp files
        print e
        if os.path.exists( tmp_dir ):
            shutil.rmtree( tmp_dir )
        stop_err( 'Error opening panama')
    # Move tmp_aligns_file_name to our output dataset location
    shutil.move( panama_output_file_name, options.output1 )
    #clean up temp files
    if os.path.exists( tmp_dir ):
        shutil.rmtree( tmp_dir )
    # check that there are results in the output file
    if os.path.getsize( options.output1 ) > 0:
        sys.stdout.write( 'PANAM results generated' )
    else:
        stop_err( 'Error generating PANAMA results' )

if __name__=="__main__": __main__()
