from galaxy.datatypes.binary import Binary
from galaxy.datatypes.metadata import ColumnTypesParameter, MetadataElement


class Feather(Binary):
    file_ext = "feather"
    
    
    def sniff(self, filename):
        try:
            with open(filename, 'rb') as f:
                header = f.read(6)
            return header.startswith((b'FEA1', b'ARROW1'))
        except Exception:
            return False
