#!/usr/bin/python
#-*- coding: utf-8 -*-

"""

Scripts ayant pour rôle l'extraction des accession et du journal de la soumission directe d'un fichier genbank.
Réalisé par Pierrick Lucas.
Usage : python extract_direct_sub_gb.py -input_files sequences.gb

"""

# Importation des librairies.
import os, sys, argparse, re
from Bio import SeqIO


##### MAIN
def __main__():
  # Options à saisir pour le script :
  parser = argparse.ArgumentParser(description='''Extract all segment name of sequences in genbank file.''', epilog='''This script need few options, use -h to see it.''')
  parser.add_argument('-i', '--input_file', dest='input_file', help='Genbank file.')
  parser.add_argument('-o', '--output_file', dest='output_file', help='Tabular file with genbank accession and journal.')

  # Erreur de saisie :
  if len(sys.argv)==1 or len(sys.argv)<3 or len(sys.argv)==4 or len(sys.argv)>5 :
    parser.print_help()
    sys.exit(1)

  # Récupération des options :
  options = parser.parse_args()
  inputfile = options.input_file
  outputfile = options.output_file

  # Ouputs :
  of = open(outputfile, "w")
  of.write("Gbk accession\tCountry\n")

  # Parcours du fichier genbank :
  for rec in SeqIO.parse(inputfile, "genbank"):
    name = rec.name
    allref = rec.annotations['references']
    lastjournal = allref[len(allref)-1].journal
    listelement = lastjournal.split(' ')
    country = listelement[len(listelement)-1]
    if re.search("http", country):
      country = listelement[len(listelement)-3]
    of.write("%s\t%s\n" % (name, country))    

  # Fermeture des fichiers.               
  of.close()

#### MAIN END
if __name__ == "__main__": __main__()
