/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext.writer;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.codecs.vcf.VCFCompoundHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.writer.BCF2Encoder;
import org.broadinstitute.sting.utils.variantcontext.writer.BCF2FieldEncoder;
import org.broadinstitute.sting.utils.variantcontext.writer.BCF2FieldWriter;
import org.broadinstitute.sting.utils.variantcontext.writer.IntGenotypeFieldAccessors;

public class BCF2FieldWriterManager {
    protected static final Logger logger = Logger.getLogger(BCF2FieldWriterManager.class);
    final Map<String, BCF2FieldWriter.SiteWriter> siteWriters = new HashMap<String, BCF2FieldWriter.SiteWriter>();
    final Map<String, BCF2FieldWriter.GenotypesWriter> genotypesWriters = new HashMap<String, BCF2FieldWriter.GenotypesWriter>();
    final IntGenotypeFieldAccessors intGenotypeFieldAccessors = new IntGenotypeFieldAccessors();

    public void setup(VCFHeader header, BCF2Encoder encoder, Map<String, Integer> stringDictionary) {
        BCF2FieldWriter writer;
        String field;
        for (VCFInfoHeaderLine vCFInfoHeaderLine : header.getInfoHeaderLines()) {
            field = vCFInfoHeaderLine.getID();
            writer = this.createInfoWriter(header, vCFInfoHeaderLine, encoder, stringDictionary);
            this.add(this.siteWriters, field, writer);
        }
        for (VCFFormatHeaderLine vCFFormatHeaderLine : header.getFormatHeaderLines()) {
            field = vCFFormatHeaderLine.getID();
            writer = this.createGenotypesWriter(header, vCFFormatHeaderLine, encoder, stringDictionary);
            this.add(this.genotypesWriters, field, writer);
        }
    }

    @Requires(value={"field != null", "writer != null"})
    @Ensures(value={"map.containsKey(field)"})
    private final <T> void add(Map<String, T> map, String field, T writer) {
        if (map.containsKey(field)) {
            throw new ReviewedStingException("BUG: field " + field + " already seen in VCFHeader while building BCF2 field encoders");
        }
        map.put(field, writer);
        if (logger.isDebugEnabled()) {
            logger.debug(writer);
        }
    }

    private BCF2FieldWriter.SiteWriter createInfoWriter(VCFHeader header, VCFInfoHeaderLine line, BCF2Encoder encoder, Map<String, Integer> dict) {
        return new BCF2FieldWriter.GenericSiteWriter(header, this.createFieldEncoder(line, encoder, dict, false));
    }

    private BCF2FieldEncoder createFieldEncoder(VCFCompoundHeaderLine line, BCF2Encoder encoder, Map<String, Integer> dict, boolean createGenotypesEncoders) {
        if (createGenotypesEncoders && this.intGenotypeFieldAccessors.getAccessor(line.getID()) != null) {
            if (line.getType() != VCFHeaderLineType.Integer) {
                logger.warn("Warning: field " + line.getID() + " expected to encode an integer but saw " + (Object)((Object)line.getType()) + " for record " + line);
            }
            return new BCF2FieldEncoder.IntArray(line, dict);
        }
        if (createGenotypesEncoders && line.getID().equals("GT")) {
            return new BCF2FieldEncoder.GenericInts(line, dict);
        }
        switch (line.getType()) {
            case Character: 
            case String: {
                return new BCF2FieldEncoder.StringOrCharacter(line, dict);
            }
            case Flag: {
                return new BCF2FieldEncoder.Flag(line, dict);
            }
            case Float: {
                return new BCF2FieldEncoder.Float(line, dict);
            }
            case Integer: {
                if (line.isFixedCount() && line.getCount() == 1) {
                    return new BCF2FieldEncoder.AtomicInt(line, dict);
                }
                return new BCF2FieldEncoder.GenericInts(line, dict);
            }
        }
        throw new ReviewedStingException("Unexpected type for field " + line.getID());
    }

    private BCF2FieldWriter.GenotypesWriter createGenotypesWriter(VCFHeader header, VCFFormatHeaderLine line, BCF2Encoder encoder, Map<String, Integer> dict) {
        String field = line.getID();
        BCF2FieldEncoder fieldEncoder = this.createFieldEncoder(line, encoder, dict, true);
        if (field.equals("GT")) {
            return new BCF2FieldWriter.GTWriter(header, fieldEncoder);
        }
        if (line.getID().equals("FT")) {
            return new BCF2FieldWriter.FTGenotypesWriter(header, fieldEncoder);
        }
        if (this.intGenotypeFieldAccessors.getAccessor(field) != null) {
            return new BCF2FieldWriter.IGFGenotypesWriter(header, fieldEncoder, this.intGenotypeFieldAccessors.getAccessor(field));
        }
        if (line.getType() == VCFHeaderLineType.Integer) {
            return new BCF2FieldWriter.IntegerTypeGenotypesWriter(header, fieldEncoder);
        }
        return new BCF2FieldWriter.StaticallyTypeGenotypesWriter(header, fieldEncoder);
    }

    public BCF2FieldWriter.SiteWriter getSiteFieldWriter(String field) {
        return this.getWriter(field, this.siteWriters);
    }

    public BCF2FieldWriter.GenotypesWriter getGenotypeFieldWriter(String field) {
        return this.getWriter(field, this.genotypesWriters);
    }

    @Requires(value={"map != null", "key != null"})
    public <T> T getWriter(String key, Map<String, T> map) {
        return map.get(key);
    }
}

