/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Gather;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.bqsr.BQSRGatherer;
import org.broadinstitute.sting.utils.recalibration.RecalUtils;

public class RecalibrationArgumentCollection {
    @Input(fullName="knownSites", shortName="knownSites", doc="A database of known polymorphic sites to skip over in the recalibration algorithm", required=false)
    public List<RodBinding<Feature>> knownSites = Collections.emptyList();
    @Gather(value=BQSRGatherer.class)
    @Output
    public File RECAL_FILE;
    @Argument(fullName="list", shortName="ls", doc="List the available covariates and exit", required=false)
    public boolean LIST_ONLY = false;
    @Argument(fullName="covariate", shortName="cov", doc="One or more covariates to be used in the recalibration. Can be specified multiple times", required=false)
    public String[] COVARIATES = null;
    @Argument(fullName="no_standard_covs", shortName="noStandard", doc="Do not use the standard set of covariates, but rather just the ones listed using the -cov argument", required=false)
    public boolean DO_NOT_USE_STANDARD_COVARIATES = false;
    @Hidden
    @Argument(fullName="run_without_dbsnp_potentially_ruining_quality", shortName="run_without_dbsnp_potentially_ruining_quality", required=false, doc="If specified, allows the recalibrator to be used without a dbsnp rod. Very unsafe and for expert users only.")
    public boolean RUN_WITHOUT_DBSNP = false;
    @Argument(fullName="solid_recal_mode", shortName="sMode", required=false, doc="How should we recalibrate solid bases in which the reference was inserted? Options = DO_NOTHING, SET_Q_ZERO, SET_Q_ZERO_BASE_N, or REMOVE_REF_BIAS")
    public RecalUtils.SOLID_RECAL_MODE SOLID_RECAL_MODE = RecalUtils.SOLID_RECAL_MODE.SET_Q_ZERO;
    @Argument(fullName="solid_nocall_strategy", shortName="solid_nocall_strategy", doc="Defines the behavior of the recalibrator when it encounters no calls in the color space. Options = THROW_EXCEPTION, LEAVE_READ_UNRECALIBRATED, or PURGE_READ", required=false)
    public RecalUtils.SOLID_NOCALL_STRATEGY SOLID_NOCALL_STRATEGY = RecalUtils.SOLID_NOCALL_STRATEGY.THROW_EXCEPTION;
    @Argument(fullName="mismatches_context_size", shortName="mcs", doc="size of the k-mer context to be used for base mismatches", required=false)
    public int MISMATCHES_CONTEXT_SIZE = 2;
    @Argument(fullName="indels_context_size", shortName="ics", doc="size of the k-mer context to be used for base insertions and deletions", required=false)
    public int INDELS_CONTEXT_SIZE = 3;
    @Argument(fullName="mismatches_default_quality", shortName="mdq", doc="default quality for the base mismatches covariate", required=false)
    public byte MISMATCHES_DEFAULT_QUALITY = (byte)-1;
    @Argument(fullName="insertions_default_quality", shortName="idq", doc="default quality for the base insertions covariate", required=false)
    public byte INSERTIONS_DEFAULT_QUALITY = (byte)45;
    @Argument(fullName="deletions_default_quality", shortName="ddq", doc="default quality for the base deletions covariate", required=false)
    public byte DELETIONS_DEFAULT_QUALITY = (byte)45;
    @Argument(fullName="low_quality_tail", shortName="lqt", doc="minimum quality for the bases in the tail of the reads to be considered", required=false)
    public byte LOW_QUAL_TAIL = (byte)2;
    @Argument(fullName="quantizing_levels", shortName="ql", required=false, doc="number of distinct quality scores in the quantized output")
    public int QUANTIZING_LEVELS = 16;
    @Argument(fullName="binary_tag_name", shortName="bintag", required=false, doc="the binary tag covariate name if using it")
    public String BINARY_TAG_NAME = null;
    @Hidden
    @Argument(fullName="default_platform", shortName="dP", required=false, doc="If a read has no platform then default to the provided String. Valid options are illumina, 454, and solid.")
    public String DEFAULT_PLATFORM = null;
    @Hidden
    @Argument(fullName="force_platform", shortName="fP", required=false, doc="If provided, the platform of EVERY read will be forced to be the provided String. Valid options are illumina, 454, and solid.")
    public String FORCE_PLATFORM = null;
    @Hidden
    @Argument(fullName="keep_intermediate_files", shortName="k", required=false, doc="does not remove the temporary csv file created to generate the plots")
    public boolean KEEP_INTERMEDIATE_FILES = false;
    @Hidden
    @Argument(fullName="no_plots", shortName="np", required=false, doc="does not generate any plots -- useful for queue scatter/gathering")
    public boolean NO_PLOTS = false;
    public File recalibrationReport = null;

    public GATKReportTable generateReportTable(String covariateNames) {
        GATKReportTable argumentsTable = new GATKReportTable("Arguments", "Recalibration argument collection values used in this run", 2);
        argumentsTable.addColumn("Argument");
        argumentsTable.addColumn("Value");
        argumentsTable.addRowID("covariate", true);
        argumentsTable.set("covariate", "Value", (Object)covariateNames);
        argumentsTable.addRowID("no_standard_covs", true);
        argumentsTable.set("no_standard_covs", "Value", (Object)this.DO_NOT_USE_STANDARD_COVARIATES);
        argumentsTable.addRowID("run_without_dbsnp", true);
        argumentsTable.set("run_without_dbsnp", "Value", (Object)this.RUN_WITHOUT_DBSNP);
        argumentsTable.addRowID("solid_recal_mode", true);
        argumentsTable.set("solid_recal_mode", "Value", (Object)this.SOLID_RECAL_MODE);
        argumentsTable.addRowID("solid_nocall_strategy", true);
        argumentsTable.set("solid_nocall_strategy", "Value", (Object)this.SOLID_NOCALL_STRATEGY);
        argumentsTable.addRowID("mismatches_context_size", true);
        argumentsTable.set("mismatches_context_size", "Value", (Object)this.MISMATCHES_CONTEXT_SIZE);
        argumentsTable.addRowID("indels_context_size", true);
        argumentsTable.set("indels_context_size", "Value", (Object)this.INDELS_CONTEXT_SIZE);
        argumentsTable.addRowID("mismatches_default_quality", true);
        argumentsTable.set("mismatches_default_quality", "Value", (Object)this.MISMATCHES_DEFAULT_QUALITY);
        argumentsTable.addRowID("insertions_default_quality", true);
        argumentsTable.set("insertions_default_quality", "Value", (Object)this.INSERTIONS_DEFAULT_QUALITY);
        argumentsTable.addRowID("low_quality_tail", true);
        argumentsTable.set("low_quality_tail", "Value", (Object)this.LOW_QUAL_TAIL);
        argumentsTable.addRowID("default_platform", true);
        argumentsTable.set("default_platform", "Value", (Object)this.DEFAULT_PLATFORM);
        argumentsTable.addRowID("force_platform", true);
        argumentsTable.set("force_platform", "Value", (Object)this.FORCE_PLATFORM);
        argumentsTable.addRowID("quantizing_levels", true);
        argumentsTable.set("quantizing_levels", "Value", (Object)this.QUANTIZING_LEVELS);
        argumentsTable.addRowID("keep_intermediate_files", true);
        argumentsTable.set("keep_intermediate_files", "Value", (Object)this.KEEP_INTERMEDIATE_FILES);
        argumentsTable.addRowID("no_plots", true);
        argumentsTable.set("no_plots", "Value", (Object)this.NO_PLOTS);
        argumentsTable.addRowID("recalibration_report", true);
        argumentsTable.set("recalibration_report", "Value", (Object)(this.recalibrationReport == null ? "null" : this.recalibrationReport.getAbsolutePath()));
        argumentsTable.addRowID("binary_tag_name", true);
        argumentsTable.set("binary_tag_name", "Value", (Object)(this.BINARY_TAG_NAME == null ? "null" : this.BINARY_TAG_NAME));
        return argumentsTable;
    }
}

