/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.resourcemanagement;

import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ThreadAllocation {
    private final int numDataThreads;
    private final int numCPUThreadsPerDataThread;
    private final int numIOThreads;
    private final boolean monitorEfficiency;

    public int getNumDataThreads() {
        return this.numDataThreads;
    }

    public int getNumCPUThreadsPerDataThread() {
        return this.numCPUThreadsPerDataThread;
    }

    public int getNumIOThreads() {
        return this.numIOThreads;
    }

    public boolean monitorThreadEfficiency() {
        return this.monitorEfficiency;
    }

    public boolean isRunningInParallelMode() {
        return this.getTotalNumThreads() > 1;
    }

    public int getTotalNumThreads() {
        return this.getNumDataThreads() * this.getNumCPUThreadsPerDataThread() + this.getNumIOThreads();
    }

    public ThreadAllocation() {
        this(1, 1, 0, false);
    }

    public ThreadAllocation(int numDataThreads, int numCPUThreadsPerDataThread, int numIOThreads, boolean monitorEfficiency) {
        if (numDataThreads < 1) {
            throw new ReviewedStingException("numDataThreads cannot be less than 1, but saw " + numDataThreads);
        }
        if (numCPUThreadsPerDataThread < 1) {
            throw new ReviewedStingException("numCPUThreadsPerDataThread cannot be less than 1, but saw " + numCPUThreadsPerDataThread);
        }
        if (numIOThreads < 0) {
            throw new ReviewedStingException("numIOThreads cannot be less than 0, but saw " + numIOThreads);
        }
        this.numDataThreads = numDataThreads;
        this.numCPUThreadsPerDataThread = numCPUThreadsPerDataThread;
        this.numIOThreads = numIOThreads;
        this.monitorEfficiency = monitorEfficiency;
    }
}

