/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.report;

import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public enum GATKReportVersion {
    V0_1("v0.1"),
    V0_2("v0.2"),
    V1_0("v1.0"),
    V1_1("v1.1");

    private final String versionString;

    private GATKReportVersion(String versionString) {
        this.versionString = versionString;
    }

    public String toString() {
        return this.versionString;
    }

    public boolean equals(GATKReportVersion that) {
        return this.versionString.equals(that.versionString);
    }

    public static GATKReportVersion fromHeader(String header) {
        if (header.startsWith("##:GATKReport.v0.1 ")) {
            return V0_1;
        }
        if (header.startsWith("##:GATKReport.v0.2 ")) {
            return V0_2;
        }
        if (header.startsWith("#:GATKReport.v1.0")) {
            return V1_0;
        }
        if (header.startsWith("#:GATKReport.v1.1")) {
            return V1_1;
        }
        throw new ReviewedStingException("Unknown GATK report version in header: " + header);
    }
}

