/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.filters;

import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.filters.ReadFilter;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class MalformedReadFilter
extends ReadFilter {
    private SAMFileHeader header;
    @Argument(fullName="filter_mismatching_base_and_quals", shortName="filterMBQ", doc="if a read has mismatching number of bases and base qualities, filter out the read instead of blowing up.", required=false)
    boolean filterMismatchingBaseAndQuals = false;

    @Override
    public void initialize(GenomeAnalysisEngine engine) {
        this.header = engine.getSAMFileHeader();
    }

    @Override
    public boolean filterOut(SAMRecord read) {
        return !MalformedReadFilter.checkInvalidAlignmentStart(read) || !MalformedReadFilter.checkInvalidAlignmentEnd(read) || !MalformedReadFilter.checkAlignmentDisagreesWithHeader(this.header, read) || !MalformedReadFilter.checkHasReadGroup(read) || !MalformedReadFilter.checkMismatchingBasesAndQuals(read, this.filterMismatchingBaseAndQuals) || !MalformedReadFilter.checkCigarDisagreesWithAlignment(read);
    }

    private static boolean checkHasReadGroup(SAMRecord read) {
        if (read.getReadGroup() == null) {
            throw new UserException.ReadMissingReadGroup(read);
        }
        return true;
    }

    private static boolean checkInvalidAlignmentStart(SAMRecord read) {
        if (!read.getReadUnmappedFlag() && read.getAlignmentStart() == 0) {
            return false;
        }
        return read.getReadUnmappedFlag() || read.getAlignmentStart() != -1;
    }

    private static boolean checkInvalidAlignmentEnd(SAMRecord read) {
        return read.getReadUnmappedFlag() || read.getAlignmentEnd() == -1 || read.getAlignmentEnd() - read.getAlignmentStart() + 1 >= 0;
    }

    private static boolean checkAlignmentDisagreesWithHeader(SAMFileHeader header, SAMRecord read) {
        if (read.getReferenceIndex() == -1 && read.getAlignmentStart() != 0) {
            return false;
        }
        SAMSequenceRecord contigHeader = header.getSequence(read.getReferenceIndex());
        return read.getReadUnmappedFlag() || read.getAlignmentStart() <= contigHeader.getSequenceLength();
    }

    private static boolean checkCigarDisagreesWithAlignment(SAMRecord read) {
        return read.getReadUnmappedFlag() || read.getAlignmentStart() == -1 || read.getAlignmentStart() == 0 || read.getAlignmentBlocks().size() >= 0;
    }

    private static boolean checkMismatchingBasesAndQuals(SAMRecord read, boolean filterMismatchingBaseAndQuals) {
        boolean result;
        if (read.getReadLength() == read.getBaseQualities().length) {
            result = true;
        } else if (filterMismatchingBaseAndQuals) {
            result = false;
        } else {
            throw new UserException.MalformedBAM(read, String.format("BAM file has a read with mismatching number of bases and base qualities. Offender: %s [%d bases] [%d quals]", read.getReadName(), read.getReadLength(), read.getBaseQualities().length));
        }
        return result;
    }
}

