/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.providers;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import net.sf.picard.util.PeekableIterator;
import org.broadinstitute.sting.gatk.refdata.RODRecordListImpl;
import org.broadinstitute.sting.gatk.refdata.utils.GATKFeature;
import org.broadinstitute.sting.gatk.refdata.utils.RODRecordList;
import org.broadinstitute.sting.utils.GenomeLoc;

class IntervalOverlappingRODsFromStream {
    GenomeLoc lastQuery = null;
    private final String name;
    private final LinkedList<GATKFeature> currentFeatures = new LinkedList();
    private final PeekableIterator<RODRecordList> futureFeatures;

    IntervalOverlappingRODsFromStream(String name, PeekableIterator<RODRecordList> futureFeatures) {
        if (futureFeatures == null) {
            throw new IllegalArgumentException("futureFeatures cannot be null");
        }
        this.name = name;
        this.futureFeatures = futureFeatures;
    }

    @Ensures(value={"overlaps(loc, result)", "! futureFeatures.hasNext() || futureFeatures.peek().getLocation().isPast(loc)", "result != null"})
    public RODRecordList getOverlapping(GenomeLoc loc) {
        if (this.lastQuery != null && loc.getStart() < this.lastQuery.getStart()) {
            throw new IllegalArgumentException(String.format("BUG: query interval (%s) starts before the previous interval %s", loc, this.lastQuery));
        }
        this.trimCurrentFeaturesToLoc(loc);
        this.readOverlappingFutureFeatures(loc);
        return new RODRecordListImpl(this.name, this.subsetToOverlapping(loc, this.currentFeatures), loc);
    }

    @Requires(value={"loc != null", "bindings != null"})
    private boolean overlaps(GenomeLoc loc, RODRecordList bindings) {
        for (GATKFeature feature : bindings) {
            if (feature.getLocation().overlapsP(loc)) continue;
            return false;
        }
        return true;
    }

    @Requires(value={"loc != null", "all != null"})
    @Ensures(value={"result.size() <= all.size()"})
    private Collection<GATKFeature> subsetToOverlapping(GenomeLoc loc, Collection<GATKFeature> all) {
        LinkedList<GATKFeature> overlapping = new LinkedList<GATKFeature>();
        for (GATKFeature feature : all) {
            if (!feature.getLocation().overlapsP(loc)) continue;
            overlapping.add(feature);
        }
        return overlapping;
    }

    @Requires(value={"loc != null"})
    @Ensures(value={"currentFeatures.size() <= old(currentFeatures.size())"})
    private void trimCurrentFeaturesToLoc(GenomeLoc loc) {
        ListIterator it = this.currentFeatures.listIterator();
        while (it.hasNext()) {
            GATKFeature feature = (GATKFeature)it.next();
            if (!feature.getLocation().isBefore(loc)) continue;
            it.remove();
        }
    }

    @Requires(value={"loc != null"})
    @Ensures(value={"currentFeatures.size() >= old(currentFeatures.size())"})
    private void readOverlappingFutureFeatures(GenomeLoc loc) {
        while (this.futureFeatures.hasNext()) {
            GenomeLoc nextLoc = this.futureFeatures.peek().getLocation();
            if (nextLoc.isBefore(loc)) {
                this.futureFeatures.next();
                continue;
            }
            if (nextLoc.isPast(loc)) break;
            if (!nextLoc.overlapsP(loc)) continue;
            for (GATKFeature feature : this.futureFeatures.next()) {
                this.currentFeatures.add(feature);
            }
        }
    }
}

