/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect;

import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;

public class RecalibratedLocalQualityScores {
    protected int[] positiveStrandBaseCounts;
    protected byte[] positiveStrandQualities;
    protected int[] negativeStrandBaseCounts;
    protected byte[] negativeStrandQualities;
    byte ref;

    public RecalibratedLocalQualityScores(byte ref, ReadBackedPileup pileup) {
        this.ref = ref;
        this.positiveStrandBaseCounts = pileup.getPositiveStrandPileup().getBaseCounts();
        this.negativeStrandBaseCounts = pileup.getNegativeStrandPileup().getBaseCounts();
        this.positiveStrandQualities = RecalibratedLocalQualityScores.calculateEmpiricalQualities(ref, this.positiveStrandBaseCounts);
        this.negativeStrandQualities = RecalibratedLocalQualityScores.calculateEmpiricalQualities(ref, this.negativeStrandBaseCounts);
    }

    protected static byte[] calculateEmpiricalQualities(byte ref, int[] counts) {
        byte[] newQualities = new byte[BaseUtils.BASES.length];
        int total = 0;
        for (int n : counts) {
            total += n;
        }
        for (byte by : BaseUtils.BASES) {
            int baseIndex = BaseUtils.simpleBaseToBaseIndex(by);
            int baseCount = by == ref ? 0 : counts[baseIndex];
            double qscore = -10.0 * Math.log10(((double)baseCount + 1.0) / ((double)total + 4.0));
            newQualities[baseIndex] = (byte)Math.round(qscore);
        }
        return newQualities;
    }

    public byte getQual(PileupElement pe) {
        int baseIndex = BaseUtils.simpleBaseToBaseIndex(pe.getBase());
        return pe.getRead().getReadNegativeStrandFlag() ? this.negativeStrandQualities[baseIndex] : this.positiveStrandQualities[baseIndex];
    }

    public String toString() {
        return "RecalibratedLocalQualityScores{ref= " + (char)this.ref + " +counts=(" + this.arrayToString(this.positiveStrandBaseCounts) + ") " + " -counts=(" + this.arrayToString(this.negativeStrandBaseCounts) + ") " + " +quals=(" + this.arrayToString(this.positiveStrandQualities) + ") " + " -quals=(" + this.arrayToString(this.negativeStrandQualities) + ") " + '}';
    }

    private StringBuilder arrayToString(int[] data) {
        StringBuilder sb = new StringBuilder();
        if (data.length == 0) {
            return sb;
        }
        sb.append(data[0]);
        for (int i = 1; i < data.length; ++i) {
            sb.append(",").append(data[i]);
        }
        return sb;
    }

    private StringBuilder arrayToString(byte[] data) {
        StringBuilder sb = new StringBuilder();
        if (data.length == 0) {
            return sb;
        }
        sb.append(data[0]);
        for (int i = 1; i < data.length; ++i) {
            sb.append(",").append(data[i]);
        }
        return sb;
    }
}

