/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.MuTect;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.RankSumTest;
import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidGenotype;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class CandidateMutation {
    private GenomeLoc location;
    private String sequenceContext;
    private char refAllele;
    private boolean dbsnpSite = false;
    private boolean cosmicSite = false;
    private VariantContext panelOfNormalsVC;
    private boolean covered = false;
    private double power;
    private double tumorPower;
    private double normalPower;
    private double normalPowerWithSNPPrior;
    private double normalPowerNoSNPPrior;
    private char altAllele = (char)78;
    private char priorBasePositiveDirection;
    private char priorBaseNegativeDirection;
    private boolean positiveDirectionPowered;
    private boolean negativeDirectionPowered;
    private String tumorSampleName = "TUMOR";
    private String normalSampleName = "NORMAL";
    private double contaminationFraction;
    private double contaminantLod;
    private int score;
    private int tumorQ20Count;
    private int normalQ20Count;
    private int totalPairs;
    private int improperPairs;
    private int mapQ0Reads;
    private int initialTumorRefCounts;
    private int initialTumorAltCounts;
    private int initialTumorRefQualitySum;
    private int initialTumorAltQualitySum;
    private int initialTumorNonRefQualitySum;
    private int initialTumorReadDepth;
    private int initialNormalRefCounts;
    private int initialNormalAltCounts;
    private int initialNormalRefQualitySum;
    private int initialNormalAltQualitySum;
    private int tumorRefMaxMapQ;
    private int tumorAltMaxMapQ;
    private int initialNormalReadDepth;
    private DiploidGenotype initialNormalBestGenotype;
    private double initialTumorLod;
    private double tumorLodLQS;
    private double initialNormalLod;
    private double tumorF;
    private double tumorFLowerBound;
    private double tumorLodFStar;
    private double tumorLodFStarForward;
    private double tumorLodFStarReverse;
    private double normalF;
    private double normalFQuals;
    private double normalLodFStar;
    private double normalArtifactPowerTF;
    private double normalArtifactLodTF;
    private double normalArtifactPowerLowTF;
    private double normalArtifactLodLowTF;
    private double normalArtifactPowerNF;
    private double normalArtifactLodNF;
    private double normalArtifactLodNFQ;
    private double normalGlobalQualityReferenceLL;
    private double normalLocalQualityReferenceLL;
    private double normalQualityModelLod;
    private RankSumTest.Result tumorQualityRankSumTest;
    private RankSumTest.Result tumorReadPositionRankSumTest;
    private Map<Integer, Double> classicSkewScoresAndOffsets;
    private Map<Integer, Double> fisherSkewScoresAndOffsets;
    private double powerToDetectPositiveStrandArtifact;
    private double powerToDetectNegativeStrandArtifact;
    private MuTect.FisherData strandBias;
    private MuTect.FisherData perfectStrandBias;
    private MuTect.FisherData clippingBias;
    private List<Integer> tumorAltForwardOffsetsInRead;
    private List<Integer> tumorAltReverseOffsetsInRead;
    private Double tumorForwardOffsetsInReadMedian;
    private Double tumorForwardOffsetsInReadMad;
    private Double tumorReverseOffsetsInReadMedian;
    private Double tumorReverseOffsetsInReadMad;
    private int tumorInsertionCount;
    private int tumorDeletionCount;
    private List<String> poweredFilters = new ArrayList<String>();
    private List<String> rejectionReasons = new ArrayList<String>();
    private boolean rejected = false;

    public CandidateMutation(GenomeLoc location, char refAllele) {
        this.location = location;
        this.refAllele = refAllele;
    }

    public int getScore() {
        return this.score;
    }

    public boolean isPositiveDirectionAtRisk() {
        return this.getPriorBasePositiveDirection() == this.getAltAllele();
    }

    public boolean isNegativeDirectionAtRisk() {
        return this.getPriorBaseNegativeDirection() == this.getAltAllele();
    }

    public boolean isGermlineAtRisk() {
        return this.dbsnpSite && !this.cosmicSite;
    }

    public boolean isPositiveDirectionPowered() {
        return this.positiveDirectionPowered;
    }

    public void setPositiveDirectionPowered(boolean positiveDirectionPowered) {
        this.positiveDirectionPowered = positiveDirectionPowered;
    }

    public boolean isNegativeDirectionPowered() {
        return this.negativeDirectionPowered;
    }

    public void setNegativeDirectionPowered(boolean negativeDirectionPowered) {
        this.negativeDirectionPowered = negativeDirectionPowered;
    }

    public GenomeLoc getLocation() {
        return this.location;
    }

    public boolean isDbsnpSite() {
        return this.dbsnpSite;
    }

    public void setDbsnpSite(boolean dbsnpSite) {
        this.dbsnpSite = dbsnpSite;
    }

    public boolean isCovered() {
        return this.covered;
    }

    public void setCovered(boolean covered) {
        this.covered = covered;
    }

    public String getSequenceContext() {
        return this.sequenceContext;
    }

    public void setSequenceContext(String sequenceContext) {
        this.sequenceContext = sequenceContext;
    }

    public char getRefAllele() {
        return this.refAllele;
    }

    public char getAltAllele() {
        return this.altAllele;
    }

    public void setAltAllele(char altAllele) {
        this.altAllele = altAllele;
    }

    public char getPriorBasePositiveDirection() {
        return this.priorBasePositiveDirection;
    }

    public void setPriorBasePositiveDirection(char priorBasePositiveDirection) {
        this.priorBasePositiveDirection = priorBasePositiveDirection;
    }

    public char getPriorBaseNegativeDirection() {
        return this.priorBaseNegativeDirection;
    }

    public void setPriorBaseNegativeDirection(char priorBaseNegativeDirection) {
        this.priorBaseNegativeDirection = priorBaseNegativeDirection;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public void setRejected(boolean rejected) {
        this.rejected = rejected;
    }

    public double getInitialTumorLod() {
        return this.initialTumorLod;
    }

    public void setInitialTumorLod(double initialTumorLod) {
        this.initialTumorLod = initialTumorLod;
    }

    public double getInitialNormalLod() {
        return this.initialNormalLod;
    }

    public void setInitialNormalLod(double initialNormalLod) {
        this.initialNormalLod = initialNormalLod;
    }

    public double getTumorLodFStar() {
        return this.tumorLodFStar;
    }

    public void setTumorLodFStar(double tumorLodFStar) {
        this.tumorLodFStar = tumorLodFStar;
    }

    public double getTumorLodFStarForward() {
        return this.tumorLodFStarForward;
    }

    public void setTumorLodFStarForward(double tumorLodFStarForward) {
        this.tumorLodFStarForward = tumorLodFStarForward;
    }

    public double getTumorLodFStarReverse() {
        return this.tumorLodFStarReverse;
    }

    public void setTumorLodFStarReverse(double tumorLodFStarReverse) {
        this.tumorLodFStarReverse = tumorLodFStarReverse;
    }

    public double getTumorF() {
        return this.tumorF;
    }

    public void setTumorF(double tumorF) {
        this.tumorF = tumorF;
    }

    public double getTumorFLowerBound() {
        return this.tumorFLowerBound;
    }

    public void setTumorFLowerBound(double tumorFLowerBound) {
        this.tumorFLowerBound = tumorFLowerBound;
    }

    public double getNormalF() {
        return this.normalF;
    }

    public void setNormalF(double normalF) {
        this.normalF = normalF;
    }

    public double getNormalLodFStar() {
        return this.normalLodFStar;
    }

    public void setNormalLodFStar(double normalLodFStar) {
        this.normalLodFStar = normalLodFStar;
    }

    public int getInitialTumorRefQualitySum() {
        return this.initialTumorRefQualitySum;
    }

    public void setInitialTumorRefQualitySum(int initialTumorRefQualitySum) {
        this.initialTumorRefQualitySum = initialTumorRefQualitySum;
    }

    public int getInitialTumorAltQualitySum() {
        return this.initialTumorAltQualitySum;
    }

    public void setInitialTumorAltQualitySum(int initialTumorAltQualitySum) {
        this.initialTumorAltQualitySum = initialTumorAltQualitySum;
    }

    public int getInitialTumorNonRefQualitySum() {
        return this.initialTumorNonRefQualitySum;
    }

    public void setInitialTumorNonRefQualitySum(int initialTumorNonRefQualitySum) {
        this.initialTumorNonRefQualitySum = initialTumorNonRefQualitySum;
    }

    public int getInitialNormalRefQualitySum() {
        return this.initialNormalRefQualitySum;
    }

    public void setInitialNormalRefQualitySum(int initialNormalRefQualitySum) {
        this.initialNormalRefQualitySum = initialNormalRefQualitySum;
    }

    public int getInitialNormalAltQualitySum() {
        return this.initialNormalAltQualitySum;
    }

    public void setInitialNormalAltQualitySum(int initialNormalAltQualitySum) {
        this.initialNormalAltQualitySum = initialNormalAltQualitySum;
    }

    public DiploidGenotype getInitialNormalBestGenotype() {
        return this.initialNormalBestGenotype;
    }

    public void setInitialNormalBestGenotype(DiploidGenotype initialNormalBestGenotype) {
        this.initialNormalBestGenotype = initialNormalBestGenotype;
    }

    public int getInitialTumorReadDepth() {
        return this.initialTumorReadDepth;
    }

    public void setInitialTumorReadDepth(int initialTumorReadDepth) {
        this.initialTumorReadDepth = initialTumorReadDepth;
    }

    public int getInitialNormalReadDepth() {
        return this.initialNormalReadDepth;
    }

    public void setInitialNormalReadDepth(int initialNormalReadDepth) {
        this.initialNormalReadDepth = initialNormalReadDepth;
    }

    public String getTumorSampleName() {
        return this.tumorSampleName;
    }

    public void setTumorSampleName(String tumorSampleName) {
        this.tumorSampleName = tumorSampleName;
    }

    public String getNormalSampleName() {
        return this.normalSampleName;
    }

    public void setNormalSampleName(String normalSampleName) {
        this.normalSampleName = normalSampleName;
    }

    public RankSumTest.Result getTumorQualityRankSumTest() {
        return this.tumorQualityRankSumTest;
    }

    public void setTumorQualityRankSumTest(RankSumTest.Result tumorQualityRankSumTest) {
        this.tumorQualityRankSumTest = tumorQualityRankSumTest;
    }

    public RankSumTest.Result getTumorReadPositionRankSumTest() {
        return this.tumorReadPositionRankSumTest;
    }

    public void setTumorReadPositionRankSumTest(RankSumTest.Result tumorReadPositionRankSumTest) {
        this.tumorReadPositionRankSumTest = tumorReadPositionRankSumTest;
    }

    public MuTect.FisherData getStrandBias() {
        return this.strandBias;
    }

    public void setStrandBias(MuTect.FisherData strandBias) {
        this.strandBias = strandBias;
    }

    public MuTect.FisherData getPerfectStrandBias() {
        return this.perfectStrandBias;
    }

    public void setPerfectStrandBias(MuTect.FisherData perfectStrandBias) {
        this.perfectStrandBias = perfectStrandBias;
    }

    public MuTect.FisherData getClippingBias() {
        return this.clippingBias;
    }

    public void setClippingBias(MuTect.FisherData clippingBias) {
        this.clippingBias = clippingBias;
    }

    public List<String> getRejectionReasons() {
        return this.rejectionReasons;
    }

    public void setRejectionReasons(List<String> rejectionReasons) {
        if (rejectionReasons != null && rejectionReasons.size() > 0) {
            this.setRejected(true);
        }
        this.rejectionReasons = rejectionReasons;
    }

    public void addRejectionReason(String reason) {
        this.setRejected(true);
        this.getRejectionReasons().add(reason);
    }

    public List<String> getPoweredFilters() {
        return this.poweredFilters;
    }

    public void setPoweredFilters(List<String> poweredFilters) {
        this.poweredFilters = poweredFilters;
    }

    public void addPoweredFilter(String filter) {
        this.getPoweredFilters().add(filter);
    }

    public int getInitialTumorRefCounts() {
        return this.initialTumorRefCounts;
    }

    public void setInitialTumorRefCounts(int initialTumorRefCounts) {
        this.initialTumorRefCounts = initialTumorRefCounts;
    }

    public int getInitialTumorAltCounts() {
        return this.initialTumorAltCounts;
    }

    public void setInitialTumorAltCounts(int initialTumorAltCounts) {
        this.initialTumorAltCounts = initialTumorAltCounts;
    }

    public int getInitialNormalRefCounts() {
        return this.initialNormalRefCounts;
    }

    public void setInitialNormalRefCounts(int initialNormalRefCounts) {
        this.initialNormalRefCounts = initialNormalRefCounts;
    }

    public int getInitialNormalAltCounts() {
        return this.initialNormalAltCounts;
    }

    public void setInitialNormalAltCounts(int initialNormalAltCounts) {
        this.initialNormalAltCounts = initialNormalAltCounts;
    }

    public int getTumorQ20Count() {
        return this.tumorQ20Count;
    }

    public void setTumorQ20Count(int tumorQ20Count) {
        this.tumorQ20Count = tumorQ20Count;
    }

    public int getNormalQ20Count() {
        return this.normalQ20Count;
    }

    public void setNormalQ20Count(int normalQ20Count) {
        this.normalQ20Count = normalQ20Count;
    }

    public Map<Integer, Double> getClassicSkewScoresAndOffsets() {
        return this.classicSkewScoresAndOffsets;
    }

    public void setClassicSkewScoresAndOffsets(Map<Integer, Double> classicSkewScoresAndOffsets) {
        this.classicSkewScoresAndOffsets = classicSkewScoresAndOffsets;
    }

    public Map<Integer, Double> getFisherSkewScoresAndOffsets() {
        return this.fisherSkewScoresAndOffsets;
    }

    public void setFisherSkewScoresAndOffsets(Map<Integer, Double> fisherSkewScoresAndOffsets) {
        this.fisherSkewScoresAndOffsets = fisherSkewScoresAndOffsets;
    }

    public int getTumorInsertionCount() {
        return this.tumorInsertionCount;
    }

    public void setTumorInsertionCount(int tumorInsertionCount) {
        this.tumorInsertionCount = tumorInsertionCount;
    }

    public int getTumorDeletionCount() {
        return this.tumorDeletionCount;
    }

    public void setTumorDeletionCount(int tumorDeletionCount) {
        this.tumorDeletionCount = tumorDeletionCount;
    }

    public int getTotalPairs() {
        return this.totalPairs;
    }

    public void setTotalPairs(int totalPairs) {
        this.totalPairs = totalPairs;
    }

    public int getImproperPairs() {
        return this.improperPairs;
    }

    public void setImproperPairs(int improperPairs) {
        this.improperPairs = improperPairs;
    }

    public int getMapQ0Reads() {
        return this.mapQ0Reads;
    }

    public void setMapQ0Reads(int mapQ0Reads) {
        this.mapQ0Reads = mapQ0Reads;
    }

    public double getContaminationFraction() {
        return this.contaminationFraction;
    }

    public void setContaminationFraction(double contaminationFraction) {
        this.contaminationFraction = contaminationFraction;
    }

    public double getContaminantLod() {
        return this.contaminantLod;
    }

    public void setContaminantLod(double contaminantLod) {
        this.contaminantLod = contaminantLod;
    }

    public List<Integer> getTumorAltForwardOffsetsInRead() {
        return this.tumorAltForwardOffsetsInRead;
    }

    public void setTumorAltForwardOffsetsInRead(List<Integer> tumorAltForwardOffsetsInRead) {
        this.tumorAltForwardOffsetsInRead = tumorAltForwardOffsetsInRead;
    }

    public List<Integer> getTumorAltReverseOffsetsInRead() {
        return this.tumorAltReverseOffsetsInRead;
    }

    public void setTumorAltReverseOffsetsInRead(List<Integer> tumorAltReverseOffsetsInRead) {
        this.tumorAltReverseOffsetsInRead = tumorAltReverseOffsetsInRead;
    }

    public Double getTumorForwardOffsetsInReadMedian() {
        return this.tumorForwardOffsetsInReadMedian;
    }

    public void setTumorForwardOffsetsInReadMedian(Double tumorForwardOffsetsInReadMedian) {
        this.tumorForwardOffsetsInReadMedian = tumorForwardOffsetsInReadMedian;
    }

    public Double getTumorForwardOffsetsInReadMad() {
        return this.tumorForwardOffsetsInReadMad;
    }

    public void setTumorForwardOffsetsInReadMad(Double tumorForwardOffsetsInReadMad) {
        this.tumorForwardOffsetsInReadMad = tumorForwardOffsetsInReadMad;
    }

    public Double getTumorReverseOffsetsInReadMedian() {
        return this.tumorReverseOffsetsInReadMedian;
    }

    public void setTumorReverseOffsetsInReadMedian(Double tumorReverseOffsetsInReadMedian) {
        this.tumorReverseOffsetsInReadMedian = tumorReverseOffsetsInReadMedian;
    }

    public Double getTumorReverseOffsetsInReadMad() {
        return this.tumorReverseOffsetsInReadMad;
    }

    public void setTumorReverseOffsetsInReadMad(Double tumorReverseOffsetsInReadMad) {
        this.tumorReverseOffsetsInReadMad = tumorReverseOffsetsInReadMad;
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double power) {
        this.power = power;
    }

    public double getTumorPower() {
        return this.tumorPower;
    }

    public void setTumorPower(double tumorPower) {
        this.tumorPower = tumorPower;
    }

    public double getNormalPower() {
        return this.normalPower;
    }

    public void setNormalPower(double normalPower) {
        this.normalPower = normalPower;
    }

    public boolean isCosmicSite() {
        return this.cosmicSite;
    }

    public void setCosmicSite(boolean cosmicSite) {
        this.cosmicSite = cosmicSite;
    }

    public boolean isSeenInPanelOfNormals() {
        return this.panelOfNormalsVC != null;
    }

    public int getCountOfNormalsObservedIn() {
        if (this.panelOfNormalsVC == null) {
            return 0;
        }
        int count = 0;
        Object o = this.panelOfNormalsVC.getAttribute("AC");
        if (o == null) {
            return 0;
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        if (o instanceof Collection) {
            for (String s : (Collection)o) {
                count += Integer.parseInt(s);
            }
            return count;
        }
        throw new RuntimeException("Unexpected value processing panel of normals allele count: " + o);
    }

    public VariantContext getPanelOfNormalsVC() {
        return this.panelOfNormalsVC;
    }

    public void setPanelOfNormalsVC(VariantContext panelOfNormalsVC) {
        this.panelOfNormalsVC = panelOfNormalsVC;
    }

    public double getNormalArtifactPowerTF() {
        return this.normalArtifactPowerTF;
    }

    public void setNormalArtifactPowerTF(double normalArtifactPowerTF) {
        this.normalArtifactPowerTF = normalArtifactPowerTF;
    }

    public double getNormalArtifactLodTF() {
        return this.normalArtifactLodTF;
    }

    public void setNormalArtifactLodTF(double normalArtifactLodTF) {
        this.normalArtifactLodTF = normalArtifactLodTF;
    }

    public double getPowerToDetectPositiveStrandArtifact() {
        return this.powerToDetectPositiveStrandArtifact;
    }

    public double getNormalArtifactPowerLowTF() {
        return this.normalArtifactPowerLowTF;
    }

    public void setNormalArtifactPowerLowTF(double normalArtifactPowerLowTF) {
        this.normalArtifactPowerLowTF = normalArtifactPowerLowTF;
    }

    public double getNormalArtifactLodLowTF() {
        return this.normalArtifactLodLowTF;
    }

    public void setNormalArtifactLodLowTF(double normalArtifactLodLowTF) {
        this.normalArtifactLodLowTF = normalArtifactLodLowTF;
    }

    public double getNormalArtifactPowerNF() {
        return this.normalArtifactPowerNF;
    }

    public void setNormalArtifactPowerNF(double normalArtifactPowerNF) {
        this.normalArtifactPowerNF = normalArtifactPowerNF;
    }

    public double getNormalArtifactLodNF() {
        return this.normalArtifactLodNF;
    }

    public void setNormalArtifactLodNF(double normalArtifactLodNF) {
        this.normalArtifactLodNF = normalArtifactLodNF;
    }

    public void setPowerToDetectPositiveStrandArtifact(double powerToDetectPositiveStrandArtifact) {
        this.powerToDetectPositiveStrandArtifact = powerToDetectPositiveStrandArtifact;
    }

    public double getPowerToDetectNegativeStrandArtifact() {
        return this.powerToDetectNegativeStrandArtifact;
    }

    public void setPowerToDetectNegativeStrandArtifact(double powerToDetectNegativeStrandArtifact) {
        this.powerToDetectNegativeStrandArtifact = powerToDetectNegativeStrandArtifact;
    }

    public double getNormalPowerWithSNPPrior() {
        return this.normalPowerWithSNPPrior;
    }

    public void setNormalPowerWithSNPPrior(double normalPowerWithSNPPrior) {
        this.normalPowerWithSNPPrior = normalPowerWithSNPPrior;
    }

    public double getNormalPowerNoSNPPrior() {
        return this.normalPowerNoSNPPrior;
    }

    public void setNormalPowerNoSNPPrior(double normalPowerNoSNPPrior) {
        this.normalPowerNoSNPPrior = normalPowerNoSNPPrior;
    }

    public double getNormalGlobalQualityReferenceLL() {
        return this.normalGlobalQualityReferenceLL;
    }

    public void setNormalGlobalQualityReferenceLL(double normalGlobalQualityReferenceLL) {
        this.normalGlobalQualityReferenceLL = normalGlobalQualityReferenceLL;
    }

    public double getNormalLocalQualityReferenceLL() {
        return this.normalLocalQualityReferenceLL;
    }

    public void setNormalLocalQualityReferenceLL(double normalLocalQualityReferenceLL) {
        this.normalLocalQualityReferenceLL = normalLocalQualityReferenceLL;
    }

    public double getNormalQualityModelLod() {
        return this.normalQualityModelLod;
    }

    public void setNormalQualityModelLod(double normalQualityModelLod) {
        this.normalQualityModelLod = normalQualityModelLod;
    }

    public double getTumorLodLQS() {
        return this.tumorLodLQS;
    }

    public void setTumorLodLQS(double tumorLodLQS) {
        this.tumorLodLQS = tumorLodLQS;
    }

    public double getNormalFQuals() {
        return this.normalFQuals;
    }

    public void setNormalFQuals(double normalFQuals) {
        this.normalFQuals = normalFQuals;
    }

    public double getNormalArtifactLodNFQ() {
        return this.normalArtifactLodNFQ;
    }

    public void setNormalArtifactLodNFQ(double normalArtifactLodNFQ) {
        this.normalArtifactLodNFQ = normalArtifactLodNFQ;
    }

    public int getTumorAltMaxMapQ() {
        return this.tumorAltMaxMapQ;
    }

    public void setTumorAltMaxMapQ(int tumorAltMaxMapQ) {
        this.tumorAltMaxMapQ = tumorAltMaxMapQ;
    }

    public int getTumorRefMaxMapQ() {
        return this.tumorRefMaxMapQ;
    }

    public void setTumorRefMaxMapQ(int tumorRefMaxMapQ) {
        this.tumorRefMaxMapQ = tumorRefMaxMapQ;
    }
}

