/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.Positional;

public final class PositionalBufferedStream
extends InputStream
implements Positional {
    final InputStream is;
    final byte[] buffer;
    int nextChar;
    int nChars;
    long position;

    public PositionalBufferedStream(InputStream is) {
        this(is, 512000);
    }

    public PositionalBufferedStream(InputStream is, int bufferSize) {
        this.is = is;
        this.buffer = new byte[bufferSize];
        this.nChars = 0;
        this.nextChar = 0;
    }

    @Override
    public final long getPosition() {
        return this.position;
    }

    @Override
    public final int read() throws IOException {
        int c = this.peek();
        if (c >= 0) {
            ++this.position;
            ++this.nextChar;
        }
        return c;
    }

    @Override
    public final int read(byte[] bytes, int start, int len) throws IOException {
        int nCharsToCopy;
        if (len == 0) {
            return 0;
        }
        if (this.nChars < 0) {
            return -1;
        }
        int nRead = 0;
        for (int remaining = len; remaining > 0 && (this.nChars != this.nextChar || this.fill() >= 0); remaining -= nCharsToCopy) {
            nCharsToCopy = Math.min(this.nChars - this.nextChar, remaining);
            System.arraycopy(this.buffer, this.nextChar, bytes, start + nRead, nCharsToCopy);
            this.nextChar += nCharsToCopy;
            nRead += nCharsToCopy;
        }
        this.position += (long)nRead;
        return nRead;
    }

    @Override
    public final int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public final boolean isDone() throws IOException {
        return this.nChars == -1 || this.peek() == -1;
    }

    @Override
    public final int peek() throws IOException {
        if (this.nChars < 0) {
            return -1;
        }
        if (this.nextChar == this.nChars && this.fill() < 0) {
            return -1;
        }
        return PositionalBufferedStream.byteToInt(this.buffer[this.nextChar]);
    }

    private final int fill() throws IOException {
        this.nChars = this.is.read(this.buffer);
        this.nextChar = 0;
        return this.nChars;
    }

    @Override
    public final long skip(long nBytes) throws IOException {
        long remainingToSkip = nBytes;
        while (remainingToSkip > 0L && !this.isDone()) {
            long bytesLeftInBuffer = this.nChars - this.nextChar;
            if (remainingToSkip > bytesLeftInBuffer) {
                remainingToSkip -= bytesLeftInBuffer;
                this.fill();
                continue;
            }
            this.nextChar = (int)((long)this.nextChar + remainingToSkip);
            remainingToSkip = 0L;
        }
        long actuallySkipped = nBytes - remainingToSkip;
        this.position += actuallySkipped;
        return actuallySkipped;
    }

    @Override
    public final void close() {
        try {
            this.is.close();
        }
        catch (IOException ex) {
            new TribbleException("Failed to close PositionalBufferedStream", ex);
        }
    }

    private static final int byteToInt(byte b) {
        return b & 0xFF;
    }

    public static void main(String[] args) throws Exception {
        File testFile = new File(args[0]);
        int iterations = Integer.valueOf(args[1]);
        boolean includeInputStream = Boolean.valueOf(args[2]);
        boolean doReadFileInChunks = Boolean.valueOf(args[3]);
        System.out.printf("Testing %s%n", args[0]);
        for (int i = 0; i < iterations; ++i) {
            if (includeInputStream) {
                FileInputStream is = new FileInputStream(testFile);
                if (doReadFileInChunks) {
                    PositionalBufferedStream.readFileInChunks("InputStream", is);
                } else {
                    PositionalBufferedStream.readFileByLine("InputStream", is);
                }
                ((InputStream)is).close();
            }
            PositionalBufferedStream pbs = new PositionalBufferedStream(new FileInputStream(testFile));
            if (doReadFileInChunks) {
                PositionalBufferedStream.readFileInChunks("PositionalBufferedStream", pbs);
            } else {
                PositionalBufferedStream.readFileByLine("PositionalBufferedStream", pbs);
            }
            pbs.close();
        }
    }

    private static void readFileByLine(String name, InputStream is) throws IOException {
        BufferedReader reader2 = new BufferedReader(new InputStreamReader(is));
        long t0 = System.currentTimeMillis();
        long lineCount = 0L;
        while (reader2.readLine() != null) {
            ++lineCount;
        }
        long dt = System.currentTimeMillis() - t0;
        double rate = (double)lineCount / (double)dt;
        PositionalBufferedStream.printStatus(name, lineCount, rate, dt);
        reader2.close();
    }

    private static void readFileInChunks(String name, InputStream is) throws IOException {
        long t0 = System.currentTimeMillis();
        long chunk = 0L;
        byte[] bytes = new byte[4096];
        while (is.read(bytes) != -1) {
            ++chunk;
        }
        long dt = System.currentTimeMillis() - t0;
        double rate = (double)chunk / (double)dt;
        PositionalBufferedStream.printStatus(name, chunk, rate, dt);
        is.close();
    }

    private static final void printStatus(String name, long lineCount, double rate, long dt) {
        System.out.printf("%30s: %d lines read.  Rate = %.2e lines per second.  DT = %d%n", name, lineCount, rate, dt);
        System.out.flush();
    }
}

