/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import java.io.File;
import net.sf.samtools.SAMFileReader;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class SAMFileReaderBuilder {
    private File samFile = null;
    private SAMFileReader.ValidationStringency validationStringency = null;

    public void setSAMFile(File samFile) {
        this.samFile = samFile;
    }

    public void setValidationStringency(SAMFileReader.ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    public SAMFileReader build() {
        if (this.samFile == null) {
            throw new ReviewedStingException("Filename for output sam file must be supplied.");
        }
        if (this.validationStringency == null) {
            throw new ReviewedStingException("Header for output sam file must be supplied.");
        }
        SAMFileReader reader = new SAMFileReader(this.samFile);
        reader.setValidationStringency(this.validationStringency);
        return reader;
    }
}

