/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.baq;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Iterator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.iterators.ReadTransformer;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ReadTransformingIterator
implements StingSAMIterator {
    private final StingSAMIterator it;
    private final ReadTransformer transformer;

    @Requires(value={"it != null", "transformer != null", "transformer.isInitialized()"})
    public ReadTransformingIterator(StingSAMIterator it, ReadTransformer transformer) {
        if (!transformer.isInitialized()) {
            throw new IllegalStateException("Creating a read transformer stream for an uninitialized read transformer: " + transformer);
        }
        if (transformer.getApplicationTime() == ReadTransformer.ApplicationTime.FORBIDDEN) {
            throw new IllegalStateException("Creating a read transformer stream for a forbidden transformer " + transformer);
        }
        this.it = it;
        this.transformer = transformer;
    }

    @Override
    @Requires(value={"hasNext()"})
    @Ensures(value={"result != null"})
    public SAMRecord next() {
        GATKSAMRecord read = (GATKSAMRecord)this.it.next();
        return this.transformer.apply(read);
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove records from a SAM file via an iterator!");
    }

    @Override
    public void close() {
        this.it.close();
    }

    @Override
    public Iterator<SAMRecord> iterator() {
        return this;
    }
}

