/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.traversals;

import java.util.LinkedList;
import java.util.List;
import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.providers.ReadBasedReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.ReadReferenceView;
import org.broadinstitute.sting.gatk.datasources.providers.ReadShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.ReadView;
import org.broadinstitute.sting.gatk.datasources.reads.ReadShard;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.traversals.TraversalEngine;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.nanoScheduler.NanoScheduler;
import org.broadinstitute.sting.utils.nanoScheduler.NanoSchedulerMapFunction;
import org.broadinstitute.sting.utils.nanoScheduler.NanoSchedulerReduceFunction;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class TraverseReadsNano<M, T>
extends TraversalEngine<M, T, ReadWalker<M, T>, ReadShardDataProvider> {
    protected static final Logger logger = Logger.getLogger(TraverseReadsNano.class);
    private static final boolean DEBUG = false;
    final NanoScheduler<MapData, MapResult, T> nanoScheduler;
    private final MapResult SKIP_REDUCE = new MapResult();

    public TraverseReadsNano(int nThreads) {
        int bufferSize = ReadShard.getReadBufferSize() + 1;
        this.nanoScheduler = new NanoScheduler(bufferSize, nThreads);
    }

    @Override
    protected String getTraversalType() {
        return "reads";
    }

    @Override
    public T traverse(ReadWalker<M, T> walker, ReadShardDataProvider dataProvider, T sum) {
        logger.debug(String.format("TraverseReadsNano.traverse Covered dataset is %s", dataProvider));
        if (!dataProvider.hasReads()) {
            throw new IllegalArgumentException("Unable to traverse reads; no read data is available.");
        }
        this.nanoScheduler.setDebug(false);
        TraverseReadsMap myMap = new TraverseReadsMap(walker);
        TraverseReadsReduce myReduce = new TraverseReadsReduce(walker);
        List<MapData> aggregatedInputs = this.aggregateMapData(dataProvider);
        T result = this.nanoScheduler.execute(aggregatedInputs.iterator(), myMap, sum, myReduce);
        GATKSAMRecord lastRead = aggregatedInputs.get((int)(aggregatedInputs.size() - 1)).read;
        GenomeLoc locus = this.engine.getGenomeLocParser().createGenomeLoc(lastRead);
        this.updateCumulativeMetrics(dataProvider.getShard());
        this.printProgress(locus);
        return result;
    }

    private List<MapData> aggregateMapData(ReadShardDataProvider dataProvider) {
        ReadView reads = new ReadView(dataProvider);
        ReadReferenceView reference = new ReadReferenceView(dataProvider);
        ReadBasedReferenceOrderedView rodView = new ReadBasedReferenceOrderedView(dataProvider);
        LinkedList<MapData> mapData = new LinkedList<MapData>();
        for (SAMRecord read : reads) {
            ReferenceContext refContext = !read.getReadUnmappedFlag() ? reference.getReferenceContext(read) : null;
            RefMetaDataTracker tracker = read.getReferenceIndex() >= 0 ? rodView.getReferenceOrderedDataForRead(read) : null;
            dataProvider.getShard().getReadMetrics().incrementNumIterations();
            mapData.add(new MapData((GATKSAMRecord)read, refContext, tracker));
        }
        return mapData;
    }

    @Override
    public void printOnTraversalDone() {
        this.nanoScheduler.shutdown();
        super.printOnTraversalDone();
    }

    private class TraverseReadsReduce
    implements NanoSchedulerReduceFunction<MapResult, T> {
        final ReadWalker<M, T> walker;

        private TraverseReadsReduce(ReadWalker<M, T> walker) {
            this.walker = walker;
        }

        @Override
        public T apply(MapResult one, T sum) {
            if (one.reduceMe) {
                return this.walker.reduce(one.value, sum);
            }
            return sum;
        }
    }

    private class TraverseReadsMap
    implements NanoSchedulerMapFunction<MapData, MapResult> {
        final ReadWalker<M, T> walker;

        private TraverseReadsMap(ReadWalker<M, T> walker) {
            this.walker = walker;
        }

        @Override
        public MapResult apply(MapData data) {
            boolean keepMeP;
            if (!this.walker.isDone() && (keepMeP = this.walker.filter(data.refContext, data.read))) {
                return new MapResult(this.walker.map(data.refContext, data.read, data.tracker));
            }
            return TraverseReadsNano.this.SKIP_REDUCE;
        }
    }

    private class MapResult {
        final M value;
        final boolean reduceMe;

        private MapResult(M value) {
            this.value = value;
            this.reduceMe = true;
        }

        private MapResult() {
            this.value = null;
            this.reduceMe = false;
        }
    }

    private class MapData {
        final GATKSAMRecord read;
        final ReferenceContext refContext;
        final RefMetaDataTracker tracker;

        private MapData(GATKSAMRecord read, ReferenceContext refContext, RefMetaDataTracker tracker) {
            this.read = read;
            this.refContext = refContext;
            this.tracker = tracker;
        }
    }
}

