/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.traversals;

import java.util.Iterator;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.providers.LocusReferenceView;
import org.broadinstitute.sting.gatk.datasources.providers.LocusView;
import org.broadinstitute.sting.gatk.datasources.providers.ReferenceOrderedView;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.traversals.TraverseLociBase;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.nanoScheduler.NanoScheduler;
import org.broadinstitute.sting.utils.nanoScheduler.NanoSchedulerMapFunction;
import org.broadinstitute.sting.utils.nanoScheduler.NanoSchedulerProgressFunction;
import org.broadinstitute.sting.utils.nanoScheduler.NanoSchedulerReduceFunction;

public class TraverseLociNano<M, T>
extends TraverseLociBase<M, T> {
    private static final boolean DEBUG = false;
    private static final int BUFFER_SIZE = 1000;
    final NanoScheduler<MapData, MapResult, T> nanoScheduler;
    private final MapResult SKIP_REDUCE = new MapResult();

    public TraverseLociNano(int nThreads) {
        this.nanoScheduler = new NanoScheduler(1000, nThreads);
        this.nanoScheduler.setProgressFunction(new TraverseLociProgress());
    }

    @Override
    protected TraverseLociBase.TraverseResults<T> traverse(LocusWalker<M, T> walker, LocusView locusView, LocusReferenceView referenceView, ReferenceOrderedView referenceOrderedDataView, T sum) {
        this.nanoScheduler.setDebug(false);
        TraverseLociMap myMap = new TraverseLociMap(walker);
        TraverseLociReduce myReduce = new TraverseLociReduce(walker);
        MapDataIterator inputIterator = new MapDataIterator(locusView, referenceView, referenceOrderedDataView);
        T result = this.nanoScheduler.execute(inputIterator, myMap, sum, myReduce);
        return new TraverseLociBase.TraverseResults<T>(inputIterator.numIterations, result);
    }

    @Override
    public void printOnTraversalDone() {
        this.nanoScheduler.shutdown();
        super.printOnTraversalDone();
    }

    private class TraverseLociProgress
    implements NanoSchedulerProgressFunction<MapData> {
        private TraverseLociProgress() {
        }

        @Override
        public void progress(MapData lastProcessedMap) {
            if (lastProcessedMap.alignmentContext != null) {
                TraverseLociNano.this.printProgress(lastProcessedMap.alignmentContext.getLocation());
            }
        }
    }

    private class TraverseLociReduce
    implements NanoSchedulerReduceFunction<MapResult, T> {
        final LocusWalker<M, T> walker;

        private TraverseLociReduce(LocusWalker<M, T> walker) {
            this.walker = walker;
        }

        @Override
        public T apply(MapResult one, T sum) {
            if (one.reduceMe) {
                return this.walker.reduce(one.value, sum);
            }
            return sum;
        }
    }

    private class TraverseLociMap
    implements NanoSchedulerMapFunction<MapData, MapResult> {
        final LocusWalker<M, T> walker;

        private TraverseLociMap(LocusWalker<M, T> walker) {
            this.walker = walker;
        }

        @Override
        public MapResult apply(MapData data) {
            boolean keepMeP;
            if (!this.walker.isDone() && (keepMeP = this.walker.filter(data.tracker, data.refContext, data.alignmentContext))) {
                Object x = this.walker.map(data.tracker, data.refContext, data.alignmentContext);
                return new MapResult(x);
            }
            return TraverseLociNano.this.SKIP_REDUCE;
        }
    }

    private class MapResult {
        final M value;
        final boolean reduceMe;

        private MapResult(M value) {
            this.value = value;
            this.reduceMe = true;
        }

        private MapResult() {
            this.value = null;
            this.reduceMe = false;
        }
    }

    private class MapData {
        final AlignmentContext alignmentContext;
        final ReferenceContext refContext;
        final RefMetaDataTracker tracker;

        private MapData(AlignmentContext alignmentContext, ReferenceContext refContext, RefMetaDataTracker tracker) {
            this.alignmentContext = alignmentContext;
            this.refContext = refContext;
            this.tracker = tracker;
        }

        public String toString() {
            return "MapData " + this.alignmentContext.getLocation();
        }
    }

    private class MapDataIterator
    implements Iterator<MapData> {
        final LocusView locusView;
        final LocusReferenceView referenceView;
        final ReferenceOrderedView referenceOrderedDataView;
        int numIterations = 0;

        private MapDataIterator(LocusView locusView, LocusReferenceView referenceView, ReferenceOrderedView referenceOrderedDataView) {
            this.locusView = locusView;
            this.referenceView = referenceView;
            this.referenceOrderedDataView = referenceOrderedDataView;
        }

        @Override
        public boolean hasNext() {
            return this.locusView.hasNext();
        }

        @Override
        public MapData next() {
            AlignmentContext locus = this.locusView.next();
            GenomeLoc location = locus.getLocation();
            ReferenceContext refContext = this.referenceView.getReferenceContext(location);
            RefMetaDataTracker tracker = this.referenceOrderedDataView.getReferenceOrderedDataAtLocus(location, refContext);
            ++this.numIterations;
            return new MapData(locus, refContext, tracker);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove elements from MapDataIterator");
        }
    }
}

