/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.refdata.tracks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import net.sf.samtools.SAMSequenceDictionary;
import org.apache.log4j.Logger;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.Tribble;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.util.LittleEndianOutputStream;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.arguments.ValidationExclusion;
import org.broadinstitute.sting.gatk.refdata.tracks.FeatureManager;
import org.broadinstitute.sting.gatk.refdata.tracks.IndexDictionaryUtils;
import org.broadinstitute.sting.gatk.refdata.tracks.RMDTrack;
import org.broadinstitute.sting.gatk.refdata.utils.RMDTriplet;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.file.FSLockWithShared;
import org.broadinstitute.sting.utils.file.FileSystemInabilityToLockException;
import org.broadinstitute.sting.utils.instrumentation.Sizeof;

public class RMDTrackBuilder {
    private static final Logger logger = Logger.getLogger(RMDTrackBuilder.class);
    private final SAMSequenceDictionary dict;
    private final GenomeLocParser genomeLocParser;
    private ValidationExclusion.TYPE validationExclusionType;
    private final FeatureManager featureManager;

    public RMDTrackBuilder(SAMSequenceDictionary dict, GenomeLocParser genomeLocParser, ValidationExclusion.TYPE validationExclusionType) {
        this.dict = dict;
        this.validationExclusionType = validationExclusionType;
        this.genomeLocParser = genomeLocParser;
        this.featureManager = new FeatureManager(GenomeAnalysisEngine.lenientVCFProcessing(validationExclusionType));
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public RMDTrack createInstanceOfTrack(RMDTriplet fileDescriptor) {
        String name = fileDescriptor.getName();
        File inputFile = new File(fileDescriptor.getFile());
        FeatureManager.FeatureDescriptor descriptor = this.getFeatureManager().getByTriplet(fileDescriptor);
        if (descriptor == null) {
            throw new UserException.BadArgumentValue("-B", fileDescriptor.getType());
        }
        Pair<AbstractFeatureReader, SAMSequenceDictionary> pair = inputFile.getAbsolutePath().endsWith(".gz") ? this.createTabixIndexedFeatureSource(descriptor, name, inputFile) : this.getFeatureSource(descriptor, name, inputFile, fileDescriptor.getStorageType());
        if (pair == null) {
            throw new UserException.CouldNotReadInputFile(inputFile, "Unable to make the feature reader for input file");
        }
        return new RMDTrack(descriptor.getCodecClass(), name, inputFile, (AbstractFeatureReader)pair.first, (SAMSequenceDictionary)pair.second, this.genomeLocParser, this.createCodec(descriptor, name));
    }

    public RMDTrack createInstanceOfTrack(Class codecClass, File inputFile) {
        FeatureManager.FeatureDescriptor descriptor = this.getFeatureManager().getByCodec(codecClass);
        if (descriptor == null) {
            throw new ReviewedStingException("Unable to find type name for codec class " + codecClass.getName());
        }
        return this.createInstanceOfTrack(new RMDTriplet("anonymous", descriptor.getName(), inputFile.getAbsolutePath(), RMDTriplet.RMDStorageType.FILE, new Tags()));
    }

    private Pair<AbstractFeatureReader, SAMSequenceDictionary> createTabixIndexedFeatureSource(FeatureManager.FeatureDescriptor descriptor, String name, File inputFile) {
        logger.info("Attempting to blindly load " + inputFile + " as a tabix indexed file");
        try {
            return new Pair<AbstractFeatureReader, Object>(AbstractFeatureReader.getFeatureReader(inputFile.getAbsolutePath(), this.createCodec(descriptor, name)), null);
        }
        catch (TribbleException e) {
            throw new UserException(e.getMessage(), e);
        }
    }

    private FeatureCodec createCodec(FeatureManager.FeatureDescriptor descriptor, String name) {
        return this.featureManager.createCodec(descriptor, name, this.genomeLocParser);
    }

    private Pair<AbstractFeatureReader, SAMSequenceDictionary> getFeatureSource(FeatureManager.FeatureDescriptor descriptor, String name, File inputFile, RMDTriplet.RMDStorageType storageType) {
        boolean canBeIndexed;
        AbstractFeatureReader featureSource = null;
        SAMSequenceDictionary sequenceDictionary = null;
        boolean bl = canBeIndexed = storageType == RMDTriplet.RMDStorageType.FILE;
        if (canBeIndexed) {
            try {
                Index index = this.loadIndex(inputFile, this.createCodec(descriptor, name));
                try {
                    logger.info(String.format("  Index for %s has size in bytes %d", inputFile, Sizeof.getObjectGraphSize(index)));
                }
                catch (ReviewedStingException e) {
                    // empty catch block
                }
                sequenceDictionary = IndexDictionaryUtils.getSequenceDictionaryFromProperties(index);
                if (sequenceDictionary.size() == 0 && this.dict != null) {
                    File indexFile = Tribble.indexFile(inputFile);
                    this.validateAndUpdateIndexSequenceDictionary(inputFile, index, this.dict);
                    try {
                        RMDTrackBuilder.writeIndexToDisk(index, indexFile, new FSLockWithShared(indexFile));
                    }
                    catch (IOException e) {
                        logger.warn("Unable to update index with the sequence dictionary for file " + indexFile + "; this will not effect your run of the GATK");
                    }
                    sequenceDictionary = IndexDictionaryUtils.getSequenceDictionaryFromProperties(index);
                }
                featureSource = AbstractFeatureReader.getFeatureReader(inputFile.getAbsolutePath(), this.createCodec(descriptor, name), index);
            }
            catch (TribbleException e) {
                throw new UserException(e.getMessage());
            }
            catch (IOException e) {
                throw new UserException.CouldNotCreateOutputFile(inputFile, "unable to write Tribble index", (Exception)e);
            }
        }
        featureSource = AbstractFeatureReader.getFeatureReader(inputFile.getAbsolutePath(), this.createCodec(descriptor, name), false);
        return new Pair<AbstractFeatureReader, Object>(featureSource, sequenceDictionary);
    }

    public synchronized Index loadIndex(File inputFile, FeatureCodec codec) throws IOException {
        File indexFile = Tribble.indexFile(inputFile);
        FSLockWithShared lock = new FSLockWithShared(indexFile);
        Index idx = null;
        if (indexFile.canRead()) {
            idx = this.attemptIndexFromDisk(inputFile, codec, indexFile, lock);
        }
        if (idx != null) {
            return idx;
        }
        return RMDTrackBuilder.writeIndexToDisk(this.createIndexInMemory(inputFile, codec), indexFile, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Index attemptIndexFromDisk(File inputFile, FeatureCodec codec, File indexFile, FSLockWithShared lock) throws IOException {
        Index idx;
        boolean locked;
        try {
            locked = lock.sharedLock();
        }
        catch (FileSystemInabilityToLockException ex) {
            throw new UserException.MissortedFile(inputFile, "Unexpected inability to lock exception", ex);
        }
        try {
            idx = !locked ? this.createIndexInMemory(inputFile, codec) : RMDTrackBuilder.loadFromDisk(inputFile, indexFile);
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
        return idx;
    }

    public static Index loadFromDisk(File inputFile, File indexFile) {
        logger.info("Loading Tribble index from disk for file " + inputFile);
        Index index = IndexFactory.loadIndex(indexFile.getAbsolutePath());
        if (index.isCurrentVersion() && indexFile.lastModified() >= inputFile.lastModified()) {
            return index;
        }
        if (indexFile.lastModified() < inputFile.lastModified()) {
            logger.warn("Index file " + indexFile + " is out of date (index older than input file), deleting and updating the index file");
        } else {
            logger.warn("Index file " + indexFile + " is out of date (old version), deleting and updating the index file");
        }
        boolean deleted = indexFile.delete();
        if (!deleted) {
            logger.warn("Index file " + indexFile + " is out of date, but could not be removed; it will not be trusted (we'll try to rebuild an in-memory copy)");
        }
        return null;
    }

    private static Index writeIndexToDisk(Index index, File indexFile, FSLockWithShared lock) throws IOException {
        boolean locked = false;
        try {
            locked = lock.exclusiveLock();
            if (locked) {
                logger.info("Writing Tribble index to disk for file " + indexFile);
                LittleEndianOutputStream stream = new LittleEndianOutputStream(new FileOutputStream(indexFile));
                index.write(stream);
                stream.close();
            } else {
                logger.warn("Unable to write to " + indexFile + " for the index file, creating index in memory only");
            }
            try {
                logger.info(String.format("  Index for %s has size in bytes %d", indexFile, Sizeof.getObjectGraphSize(index)));
            }
            catch (ReviewedStingException e) {
                // empty catch block
            }
            Index e = index;
            return e;
        }
        catch (FileSystemInabilityToLockException ex) {
            throw new UserException.CouldNotCreateOutputFile(indexFile, "Unexpected inability to lock exception", (Exception)ex);
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    private Index createIndexInMemory(File inputFile, FeatureCodec codec) {
        logger.info("Creating Tribble index in memory for file " + inputFile);
        Index idx = IndexFactory.createDynamicIndex(inputFile, codec, IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME);
        this.validateAndUpdateIndexSequenceDictionary(inputFile, idx, this.dict);
        return idx;
    }

    public void validateAndUpdateIndexSequenceDictionary(File inputFile, Index index, SAMSequenceDictionary dict) {
        if (dict == null) {
            throw new ReviewedStingException("BUG: dict cannot be null");
        }
        SAMSequenceDictionary currentDict = IndexDictionaryUtils.createSequenceDictionaryFromContigList(index, new SAMSequenceDictionary());
        this.validateTrackSequenceDictionary(inputFile.getAbsolutePath(), currentDict, dict);
        IndexDictionaryUtils.setIndexSequenceDictionary(index, dict);
    }

    public void validateTrackSequenceDictionary(String trackName, SAMSequenceDictionary trackDict, SAMSequenceDictionary referenceDict) {
        IndexDictionaryUtils.validateTrackSequenceDictionary(trackName, trackDict, referenceDict, this.validationExclusionType);
    }
}

