/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.iterators;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public abstract class ReadTransformer {
    private ApplicationTime applicationTime;
    private boolean initialized = false;

    protected ReadTransformer() {
    }

    @Requires(value={"initialized == false", "engine != null", "walker != null"})
    @Ensures(value={"initialized == true"})
    public final void initialize(ApplicationTime overrideTime, GenomeAnalysisEngine engine, Walker walker) {
        if (engine == null) {
            throw new IllegalArgumentException("engine cannot be null");
        }
        if (walker == null) {
            throw new IllegalArgumentException("walker cannot be null");
        }
        this.applicationTime = this.initializeSub(engine, walker);
        if (overrideTime != null) {
            this.applicationTime = overrideTime;
        }
        this.initialized = true;
    }

    @Requires(value={"engine != null", "walker != null"})
    @Ensures(value={"result != null"})
    protected abstract ApplicationTime initializeSub(GenomeAnalysisEngine var1, Walker var2);

    public boolean enabled() {
        return false;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final ApplicationTime getApplicationTime() {
        return this.applicationTime;
    }

    @Requires(value={"read != null"})
    @Ensures(value={"result != null"})
    public abstract GATKSAMRecord apply(GATKSAMRecord var1);

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static enum ApplicationTime {
        FORBIDDEN,
        ON_INPUT,
        ON_OUTPUT,
        HANDLED_IN_WALKER;

    }
}

