/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io.stubs;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.io.OutputTracker;
import org.broadinstitute.sting.gatk.io.StingSAMFileWriter;
import org.broadinstitute.sting.gatk.io.stubs.Stub;
import org.broadinstitute.sting.gatk.iterators.ReadTransformer;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class SAMFileWriterStub
implements Stub<SAMFileWriter>,
StingSAMFileWriter {
    private final GenomeAnalysisEngine engine;
    private SAMFileHeader headerOverride = null;
    private final File samFile;
    private final OutputStream samOutputStream;
    private Integer compressionLevel = null;
    private boolean indexOnTheFly = false;
    private boolean generateMD5 = false;
    private boolean presorted = true;
    private Integer maxRecordsInRam = null;
    private OutputTracker outputTracker = null;
    private boolean writeStarted = false;
    BAQ baqHMM = new BAQ();
    private boolean simplifyBAM = false;
    private List<ReadTransformer> onOutputReadTransformers = null;

    public SAMFileWriterStub(GenomeAnalysisEngine engine, File samFile) {
        this(engine, samFile, null);
    }

    public SAMFileWriterStub(GenomeAnalysisEngine engine, OutputStream stream) {
        this(engine, null, stream);
    }

    private SAMFileWriterStub(GenomeAnalysisEngine engine, File samFile, OutputStream stream) {
        this.engine = engine;
        this.samFile = samFile;
        this.samOutputStream = stream;
    }

    public File getSAMFile() {
        return this.samFile;
    }

    public boolean simplifyBAM() {
        return this.simplifyBAM;
    }

    public void setSimplifyBAM(boolean v) {
        this.simplifyBAM = v;
    }

    public OutputStream getSAMOutputStream() {
        return this.samOutputStream;
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.headerOverride != null ? this.headerOverride : this.engine.getSAMFileHeader();
    }

    public Integer getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(Integer compressionLevel) {
        if (this.writeStarted) {
            throw new ReviewedStingException("Attempted to change the compression level of a file with alignments already in it.");
        }
        this.compressionLevel = compressionLevel;
    }

    public Boolean getIndexOnTheFly() {
        return this.indexOnTheFly;
    }

    public void setIndexOnTheFly(boolean indexOnTheFly) {
        if (this.writeStarted) {
            throw new UserException("Attempted to index a BAM on the fly of a file with alignments already in it.");
        }
        this.indexOnTheFly = indexOnTheFly;
    }

    public Boolean getGenerateMD5() {
        return this.generateMD5;
    }

    public void setGenerateMD5(boolean generateMD5) {
        if (this.writeStarted) {
            throw new UserException("Attempted to turn on md5 generation for BAM file with alignments already in it.");
        }
        this.generateMD5 = generateMD5;
    }

    public boolean isPresorted() {
        return this.presorted;
    }

    @Override
    public void setPresorted(boolean presorted) {
        if (this.writeStarted) {
            throw new ReviewedStingException("Attempted to change the presorted state of a file with alignments already in it.");
        }
        this.presorted = presorted;
    }

    public Integer getMaxRecordsInRam() {
        return this.maxRecordsInRam;
    }

    @Override
    public void setMaxRecordsInRam(int maxRecordsInRam) {
        if (this.writeStarted) {
            throw new ReviewedStingException("Attempted to change the max records in RAM of a file with alignments already in it.");
        }
        this.maxRecordsInRam = maxRecordsInRam;
    }

    @Override
    public void register(OutputTracker outputTracker) {
        this.outputTracker = outputTracker;
    }

    @Override
    public void writeHeader(SAMFileHeader header) {
        if (this.writeStarted) {
            throw new ReviewedStingException("Attempted to change the header of a file with alignments already in it.");
        }
        this.headerOverride = header;
    }

    private void initializeReadTransformers() {
        this.onOutputReadTransformers = new ArrayList<ReadTransformer>(this.engine.getReadTransformers().size());
        for (ReadTransformer transformer : this.engine.getReadTransformers()) {
            if (transformer.getApplicationTime() != ReadTransformer.ApplicationTime.ON_OUTPUT) continue;
            this.onOutputReadTransformers.add(transformer);
        }
    }

    @Override
    public void addAlignment(SAMRecord readIn) {
        if (this.onOutputReadTransformers == null) {
            this.initializeReadTransformers();
        }
        GATKSAMRecord workingRead = (GATKSAMRecord)readIn;
        for (ReadTransformer transform : this.onOutputReadTransformers) {
            workingRead = transform.apply(workingRead);
        }
        this.writeStarted = true;
        this.outputTracker.getStorage(this).addAlignment(workingRead);
    }

    @Override
    public void close() {
        this.outputTracker.getStorage(this).close();
    }
}

