/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.filters;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.filters.ReadFilter;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.text.XReadLines;

public class AddAberrantInsertTagFilter
extends ReadFilter {
    @Argument(shortName="aif", fullName="aberrantInsertPercentileFile", required=false, doc="File containing aberrant insert size cutoffs per read group")
    File aif = null;
    HashMap<String, Pair<Integer, Integer>> rgCuts;

    @Override
    public void initialize(GenomeAnalysisEngine engine) {
        XReadLines xrl;
        this.rgCuts = new HashMap();
        try {
            xrl = this.aif != null ? new XReadLines(this.aif) : null;
        }
        catch (FileNotFoundException e) {
            throw new ReviewedStingException("File not found: " + this.aif.getName(), e);
        }
        if (xrl == null) {
            this.rgCuts = null;
        } else {
            for (String line : xrl) {
                String[] args = line.split("\\s+");
                int lower = Integer.parseInt(args[1]);
                int upper = Integer.parseInt(args[2]);
                String rg = args[0];
                this.rgCuts.put(rg, new Pair<Integer, Integer>(lower, upper));
            }
        }
    }

    @Override
    public boolean filterOut(SAMRecord read) {
        if (this.rgCuts != null && read.getReadPairedFlag() && !read.getMateUnmappedFlag()) {
            int iSize = Math.abs(read.getInferredInsertSize());
            Pair<Integer, Integer> threshs = this.rgCuts.get(read.getReadGroup().getId());
            boolean isAb = iSize < (Integer)threshs.first || iSize > (Integer)threshs.second;
            read.setAttribute("AI", (Object)(isAb ? 1 : 0));
        }
        return false;
    }
}

