/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.executive;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.broadinstitute.sting.gatk.executive.HierarchicalMicroScheduler;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class TreeReducer
implements Callable {
    private final HierarchicalMicroScheduler microScheduler;
    private TreeReducible walker;
    private Future lhs;
    private Future rhs;

    public TreeReducer(HierarchicalMicroScheduler microScheduler, Future lhs, Future rhs) {
        this.microScheduler = microScheduler;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public void setWalker(TreeReducible walker) {
        this.walker = walker;
    }

    public boolean isReadyForReduce() {
        if (this.lhs == null) {
            throw new IllegalStateException(String.format("Insufficient data on which to reduce; lhs = %s, rhs = %s", this.lhs, this.rhs));
        }
        return this.lhs.isDone() && (this.rhs == null || this.rhs.isDone());
    }

    public Object call() {
        Object result;
        long startTime = System.currentTimeMillis();
        try {
            result = this.lhs == null ? null : this.walker.treeReduce(this.lhs.get(), this.rhs.get());
        }
        catch (InterruptedException ex) {
            this.microScheduler.notifyOfTraversalError(ex);
            throw new ReviewedStingException("Hierarchical reduce interrupted", ex);
        }
        catch (ExecutionException ex) {
            this.microScheduler.notifyOfTraversalError(ex);
            throw new ReviewedStingException("Hierarchical reduce failed", ex);
        }
        long endTime = System.currentTimeMillis();
        this.lhs = null;
        this.rhs = null;
        this.microScheduler.reportTreeReduceTime(endTime - startTime);
        return result;
    }
}

