/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.BetaDistributionImpl;
import org.apache.commons.math.distribution.BinomialDistributionImpl;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.CallStatsGenerator;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.CandidateMutation;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.CoverageWiggleFileWriter;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.FisherExact;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.LocusReadPile;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.MuTectArgumentCollection;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.NormalPowerCalculator;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.QualitySums;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.RankSumTest;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.RecalibratedLocalQualityScores;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.TumorPowerCalculator;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.VariableAllelicRatioGenotypeLikelihoods;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.BAQMode;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.PartitionBy;
import org.broadinstitute.sting.gatk.walkers.PartitionType;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileupImpl;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@PartitionBy(value=PartitionType.LOCUS)
@BAQMode
@Reference(window=@Window(start=-150, stop=150))
@By(value=DataSource.REFERENCE)
public class MuTect
extends LocusWalker<Integer, Integer>
implements TreeReducible<Integer> {
    public static final int REFERENCE_HALF_WINDOW_LENGTH = 150;
    public static final String BAM_TAG_TUMOR = "tumor";
    public static final String BAM_TAG_NORMAL = "normal";
    public static final String BAM_TAG_CONTROL = "control";
    private static final String VERSION = "$Rev: 44829 $";
    @ArgumentCollection
    private MuTectArgumentCollection MTAC = new MuTectArgumentCollection();
    @Output(doc="Call-stats output")
    PrintStream out;
    @Input(fullName="dbsnp", shortName="dbsnp", doc="VCF file of DBSNP information", required=false)
    public List<RodBinding<VariantContext>> dbsnpRod = Collections.emptyList();
    @Input(fullName="cosmic", shortName="cosmic", doc="VCF file of COSMIC sites", required=false)
    public List<RodBinding<VariantContext>> cosmicRod = Collections.emptyList();
    @Hidden
    @Input(fullName="normal_panel", shortName="normal_panel", doc="VCF file of sites observed in normal", required=false)
    public List<RodBinding<VariantContext>> normalPanelRod = Collections.emptyList();
    @Output(fullName="coverage_file", shortName="cov", doc="write out coverage in WIGGLE format to this file", required=false)
    public PrintStream COVERAGE_FILE = null;
    @Output(fullName="coverage_20_q20_file", shortName="cov_q20", doc="write out 20x of Q20 coverage in WIGGLE format to this file", required=false)
    public PrintStream COVERAGE_20_Q20_FILE = null;
    @Output(fullName="power_file", shortName="pow", doc="write out power in WIGGLE format to this file", required=false)
    public PrintStream POWER_FILE = null;
    @Output(fullName="tumor_depth_file", shortName="tdf", doc="write out tumor read depth in WIGGLE format to this file", required=false)
    public PrintStream TUMOR_DEPTH_FILE = null;
    @Output(fullName="normal_depth_file", shortName="ndf", doc="write out normal read depth in WIGGLE format to this file", required=false)
    public PrintStream NORMAL_DEPTH_FILE = null;
    public boolean NO_BAQ = true;
    public int MIN_QSUM_QSCORE = 13;
    public boolean USE_MAPQ0_IN_NORMAL_QSCORE = true;
    private static final FisherExact fisher = new FisherExact(5000);
    private boolean hasTumorBam = false;
    private boolean hasNormalBam = false;
    private double contaminantAlternateFraction;
    private double powerConstantEps;
    private TumorPowerCalculator tumorPowerCalculator;
    private NormalPowerCalculator normalNovelSitePowerCalculator;
    private NormalPowerCalculator normalDbSNPSitePowerCalculator;
    private TumorPowerCalculator normalArtifactPowerCalculator;
    private TumorPowerCalculator strandArtifactPowerCalculator;
    private static ThreadLocalRankSumTest __rankSumTest = new ThreadLocalRankSumTest();
    private CoverageWiggleFileWriter stdCovWriter;
    private CoverageWiggleFileWriter q20CovWriter;
    private CoverageWiggleFileWriter powerWriter;
    private CoverageWiggleFileWriter tumorDepthWriter;
    private CoverageWiggleFileWriter normalDepthWriter;
    private Set<SAMReaderID> tumorSAMReaderIDs = new HashSet<SAMReaderID>();
    private Set<SAMReaderID> normalSAMReaderIDs = new HashSet<SAMReaderID>();
    private Set<SAMReaderID> controlSAMReaderIDs = new HashSet<SAMReaderID>();
    private CallStatsGenerator callStatsGenerator;
    public static int MAX_INSERT_SIZE = 10000;
    private int totalReadsProcessed = 0;
    private int binReadsProcessed = 0;
    private long lastTime;
    private int candidatesInspected = 0;
    private static final double PERFECT_STRAND_BIAS_THRESHOLD = 0.05;
    private static final double STRAND_BIAS_THRESHOLD = 0.05;
    private static final int QUALITY_RST_MEDIAN_SHIFT_THRESHOLD = 4;
    private static final double QUALITY_RST_PVALUE_THRESHOLD = 0.005;
    int MAX_READ_MISMATCH_QUALITY_SCORE_SUM = 100;
    private static Character MAPPED_BY_MATE = Character.valueOf('M');
    private BAQ baqHMM = new BAQ();
    IndexedFastaSequenceFile refReader;
    public static final int MAX_QUAL = 99;

    public static RankSumTest getRankSumTest() {
        return (RankSumTest)__rankSumTest.get();
    }

    @Override
    public boolean includeReadsWithDeletionAtLoci() {
        return true;
    }

    @Override
    public void initialize() {
        if (this.MTAC.NOOP) {
            return;
        }
        this.refReader = this.getToolkit().getReferenceDataSource().getReference();
        this.callStatsGenerator = new CallStatsGenerator(this.MTAC.ENABLE_EXTENDED_OUTPUT);
        for (SAMReaderID id : this.getToolkit().getReadsDataSource().getReaderIDs()) {
            if (id.getTags().getPositionalTags().size() == 0) {
                throw new RuntimeException("BAMs must be tagged as either 'tumor','normal' or 'control'");
            }
            for (String tag : id.getTags().getPositionalTags()) {
                if (BAM_TAG_TUMOR.equalsIgnoreCase(tag)) {
                    this.hasTumorBam = true;
                    this.tumorSAMReaderIDs.add(id);
                    if (this.MTAC.TUMOR_SAMPLE_NAME != null) continue;
                    try {
                        if (this.getToolkit().getReadsDataSource().getHeader(id).getReadGroups().size() == 0) {
                            throw new RuntimeException("No Read Groups found for Tumor BAM -- Read Groups are Required, or supply tumor_sample_name!");
                        }
                        this.MTAC.TUMOR_SAMPLE_NAME = this.getToolkit().getReadsDataSource().getHeader(id).getReadGroups().get(0).getSample();
                    }
                    catch (NullPointerException npe) {
                        this.MTAC.TUMOR_SAMPLE_NAME = BAM_TAG_TUMOR;
                    }
                    continue;
                }
                if (BAM_TAG_NORMAL.equalsIgnoreCase(tag)) {
                    this.hasNormalBam = true;
                    this.normalSAMReaderIDs.add(id);
                    if (this.MTAC.NORMAL_SAMPLE_NAME != null) continue;
                    try {
                        if (this.getToolkit().getReadsDataSource().getHeader(id).getReadGroups().size() == 0) {
                            throw new RuntimeException("No Read Groups found for Normal BAM -- Read Groups are Required, or supply normal_sample_name!");
                        }
                        this.MTAC.NORMAL_SAMPLE_NAME = this.getToolkit().getReadsDataSource().getHeader(id).getReadGroups().get(0).getSample();
                    }
                    catch (NullPointerException npe) {
                        this.MTAC.NORMAL_SAMPLE_NAME = BAM_TAG_NORMAL;
                    }
                    continue;
                }
                if (BAM_TAG_CONTROL.equalsIgnoreCase(tag)) {
                    this.controlSAMReaderIDs.add(id);
                    continue;
                }
                throw new RuntimeException("Unknown BAM tag '" + tag + "' must be either 'tumor','normal' or 'control'");
            }
        }
        if (!this.hasTumorBam) {
            throw new RuntimeException("At least one BAM tagged as 'tumor' required");
        }
        if (!this.hasNormalBam) {
            this.MTAC.NORMAL_LOD_THRESHOLD = -3.4028235E38f;
            this.MTAC.NORMAL_DBSNP_LOD_THRESHOLD = -3.4028235E38f;
            this.MTAC.NORMAL_ARTIFACT_LOD_THRESHOLD = Float.MAX_VALUE;
        }
        this.contaminantAlternateFraction = Math.max(this.MTAC.MINIMUM_MUTATION_CELL_FRACTION, this.MTAC.FRACTION_CONTAMINATION);
        this.powerConstantEps = Math.pow(10.0, -1 * (this.MTAC.POWER_CONSTANT_QSCORE / 10));
        this.tumorPowerCalculator = new TumorPowerCalculator(this.powerConstantEps, this.MTAC.TUMOR_LOD_THRESHOLD, this.contaminantAlternateFraction);
        this.normalNovelSitePowerCalculator = new NormalPowerCalculator(this.powerConstantEps, this.MTAC.NORMAL_LOD_THRESHOLD);
        this.normalDbSNPSitePowerCalculator = new NormalPowerCalculator(this.powerConstantEps, this.MTAC.NORMAL_DBSNP_LOD_THRESHOLD);
        this.normalArtifactPowerCalculator = new TumorPowerCalculator(this.powerConstantEps, this.MTAC.NORMAL_ARTIFACT_LOD_THRESHOLD, 0.0);
        this.strandArtifactPowerCalculator = new TumorPowerCalculator(this.powerConstantEps, this.MTAC.STRAND_ARTIFACT_LOD_THRESHOLD, 0.0);
        this.stdCovWriter = new CoverageWiggleFileWriter(this.COVERAGE_FILE);
        this.q20CovWriter = new CoverageWiggleFileWriter(this.COVERAGE_20_Q20_FILE);
        this.powerWriter = new CoverageWiggleFileWriter(this.POWER_FILE);
        this.tumorDepthWriter = new CoverageWiggleFileWriter(this.TUMOR_DEPTH_FILE);
        this.normalDepthWriter = new CoverageWiggleFileWriter(this.NORMAL_DEPTH_FILE);
        if (this.MTAC.FORCE_OUTPUT) {
            this.MTAC.INITIAL_TUMOR_LOD_THRESHOLD = -3.4028235E38f;
        }
        this.out.println("## muTector v1.0." + VERSION.split(" ")[1]);
        this.out.println(this.callStatsGenerator.generateHeader());
        this.lastTime = System.currentTimeMillis();
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext rawContext) {
        if (this.MTAC.NOOP) {
            return 0;
        }
        TreeMap<Double, CandidateMutation> messageByTumorLod = new TreeMap<Double, CandidateMutation>();
        ReadBackedPileup pileup = rawContext.getBasePileup();
        int numberOfReads = pileup.depthOfCoverage();
        this.binReadsProcessed += numberOfReads;
        if (this.binReadsProcessed >= 1000000) {
            long time = System.currentTimeMillis();
            long elapsedTime = time - this.lastTime;
            this.lastTime = time;
            this.totalReadsProcessed += this.binReadsProcessed;
            this.binReadsProcessed = 0;
            logger.info(String.format("[MUTECTOR] Processed %d reads in %d ms", this.totalReadsProcessed, elapsedTime));
        }
        if (!this.MTAC.FORCE_OUTPUT && numberOfReads == 0) {
            return -1;
        }
        char upRef = Character.toUpperCase(ref.getBaseAsChar());
        String sequenceContext = this.createSequenceContext(ref, 3);
        try {
            double combinedPower;
            double normalPower;
            double normalPowerWithSNPPrior;
            double normalPowerNoSNPPrior;
            double tumorPower;
            boolean isBaseCovered;
            int normalCoveredDepthThreshold;
            if (upRef != 'A' && upRef != 'C' && upRef != 'G' && upRef != 'T') {
                return -1;
            }
            ArrayList<PileupElement> tumorPileupElements = new ArrayList<PileupElement>();
            ArrayList<PileupElement> normalPileupElements = new ArrayList<PileupElement>();
            ArrayList<PileupElement> controlPileupElements = new ArrayList<PileupElement>();
            int totalPairs = 0;
            int improperPairs = 0;
            for (PileupElement p : pileup) {
                ReadSource source;
                GATKSAMRecord read = p.getRead();
                byte base = p.getBase();
                if (base == 78 || base == 110) continue;
                if (read.getReadPairedFlag() && !read.getMateUnmappedFlag()) {
                    ++totalPairs;
                    if (!read.getProperPairFlag() || read.getInferredInsertSize() >= MAX_INSERT_SIZE) {
                        ++improperPairs;
                    }
                }
                if ((source = this.getReadSource(p.getRead())) == ReadSource.Tumor) {
                    tumorPileupElements.add(p);
                    continue;
                }
                if (source == ReadSource.Normal) {
                    normalPileupElements.add(p);
                    continue;
                }
                if (source != ReadSource.Control) continue;
                controlPileupElements.add(p);
            }
            ReadBackedPileupImpl normalPileup = new ReadBackedPileupImpl(rawContext.getLocation(), (List<PileupElement>)normalPileupElements);
            ReadBackedPileup tumorPileup = new ReadBackedPileupImpl(rawContext.getLocation(), (List<PileupElement>)tumorPileupElements);
            if (this.MTAC.BAM_TUMOR_SAMPLE_NAME != null) {
                tumorPileup = tumorPileup.getPileupForSample(this.MTAC.BAM_TUMOR_SAMPLE_NAME);
            }
            LocusReadPile tumorReadPile = new LocusReadPile(tumorPileup, upRef, this.MTAC.MIN_QSCORE, this.MIN_QSUM_QSCORE, false, this.MTAC.ARTIFACT_DETECTION_MODE);
            LocusReadPile normalReadPile = new LocusReadPile(normalPileup, upRef, this.MTAC.MIN_QSCORE, 0, this.USE_MAPQ0_IN_NORMAL_QSCORE, true);
            List panelOfNormalsVC = tracker.getValues(this.normalPanelRod, rawContext.getLocation());
            List cosmicVC = tracker.getValues(this.cosmicRod, rawContext.getLocation());
            List dbsnpVC = tracker.getValues(this.dbsnpRod, rawContext.getLocation());
            boolean germlineAtRisk = !dbsnpVC.isEmpty() && cosmicVC.isEmpty();
            int tumorCoveredDepthThreshold = 14;
            int n = normalCoveredDepthThreshold = germlineAtRisk ? 19 : 8;
            if (!this.hasNormalBam) {
                normalCoveredDepthThreshold = 0;
            }
            int tumorBaseCount = tumorReadPile.finalPileupReads.size();
            int normalBaseCount = normalReadPile.finalPileupReads.size();
            boolean isTumorCovered = tumorBaseCount >= tumorCoveredDepthThreshold;
            boolean isNormalCovered = normalBaseCount >= normalCoveredDepthThreshold;
            boolean bl = isBaseCovered = isTumorCovered && isNormalCovered;
            if (!this.hasNormalBam) {
                isBaseCovered = isTumorCovered;
            }
            this.stdCovWriter.writeCoverage(rawContext, isBaseCovered);
            int tumorQ20BaseCount = tumorReadPile.getFilteredBaseCount(20);
            int normalQ20BaseCount = normalReadPile.getFilteredBaseCount(20);
            this.q20CovWriter.writeCoverage(rawContext, tumorQ20BaseCount >= 20 && normalQ20BaseCount >= 20);
            this.tumorDepthWriter.writeCoverage(rawContext, tumorBaseCount);
            this.normalDepthWriter.writeCoverage(rawContext, normalBaseCount);
            if (this.MTAC.ABSOLUTE_COPY_NUMBER_DATA == null) {
                tumorPower = this.tumorPowerCalculator.cachingPowerCalculation(tumorBaseCount, this.MTAC.POWER_CONSTANT_AF);
                normalPowerNoSNPPrior = this.normalNovelSitePowerCalculator.cachingPowerCalculation(normalBaseCount);
                normalPowerWithSNPPrior = this.normalDbSNPSitePowerCalculator.cachingPowerCalculation(normalBaseCount);
                normalPower = germlineAtRisk ? normalPowerWithSNPPrior : normalPowerNoSNPPrior;
                combinedPower = tumorPower * normalPower;
                if (!this.hasNormalBam) {
                    combinedPower = tumorPower;
                }
            } else {
                throw new RuntimeException("ASCN Power Calculations Not Yet Implemented!");
            }
            this.powerWriter.writeCoverage(rawContext, combinedPower);
            int mapQ0Reads = tumorReadPile.qualityScoreFilteredPileup.getNumberOfMappingQualityZeroReads() + normalReadPile.qualityScoreFilteredPileup.getNumberOfMappingQualityZeroReads();
            for (char altAllele : new char[]{'A', 'C', 'G', 'T'}) {
                double median;
                double[] offsets;
                if (altAllele == upRef || !this.MTAC.FORCE_OUTPUT && tumorReadPile.qualitySums.getCounts(altAllele) == 0) continue;
                CandidateMutation candidate = new CandidateMutation(rawContext.getLocation(), upRef);
                candidate.setSequenceContext(sequenceContext);
                candidate.setTumorSampleName(this.MTAC.TUMOR_SAMPLE_NAME);
                candidate.setNormalSampleName(this.MTAC.NORMAL_SAMPLE_NAME);
                candidate.setCovered(isBaseCovered);
                candidate.setPower(combinedPower);
                candidate.setTumorPower(tumorPower);
                candidate.setNormalPower(normalPower);
                candidate.setNormalPowerWithSNPPrior(normalPowerWithSNPPrior);
                candidate.setNormalPowerNoSNPPrior(normalPowerNoSNPPrior);
                candidate.setTumorQ20Count(tumorQ20BaseCount);
                candidate.setNormalQ20Count(normalQ20BaseCount);
                candidate.setInitialTumorNonRefQualitySum(tumorReadPile.qualitySums.getOtherQualities(upRef));
                candidate.setAltAllele(altAllele);
                candidate.setTotalPairs(totalPairs);
                candidate.setImproperPairs(improperPairs);
                candidate.setMapQ0Reads(mapQ0Reads);
                candidate.setContaminationFraction(this.MTAC.FRACTION_CONTAMINATION);
                candidate.setPanelOfNormalsVC(panelOfNormalsVC.isEmpty() ? null : (VariantContext)panelOfNormalsVC.iterator().next());
                candidate.setCosmicSite(!cosmicVC.isEmpty());
                candidate.setDbsnpSite(!dbsnpVC.isEmpty());
                candidate.setTumorF(tumorReadPile.estimateAlleleFraction(upRef, altAllele));
                if (!this.MTAC.FORCE_OUTPUT && candidate.getTumorF() < (double)this.MTAC.TUMOR_F_PRETEST) continue;
                if (++this.candidatesInspected % 1000 == 0) {
                    logger.info(String.format("[MUTECTOR] Inspected %d potential candidates", this.candidatesInspected));
                }
                candidate.setInitialTumorAltCounts(tumorReadPile.qualitySums.getCounts(altAllele));
                candidate.setInitialTumorRefCounts(tumorReadPile.qualitySums.getCounts(upRef));
                candidate.setInitialTumorAltQualitySum(tumorReadPile.qualitySums.getQualitySum(altAllele));
                candidate.setInitialTumorRefQualitySum(tumorReadPile.qualitySums.getQualitySum(upRef));
                double tumorFLB = 0.0;
                int refCount = candidate.getInitialTumorRefCounts();
                int altCount = candidate.getInitialTumorAltCounts();
                int depth = refCount + altCount;
                if (altCount > 0) {
                    BetaDistributionImpl dist = new BetaDistributionImpl(depth - altCount + 1, altCount);
                    tumorFLB = 1.0 - dist.inverseCumulativeProbability(0.975);
                }
                candidate.setTumorFLowerBound(tumorFLB);
                double tumorLod = tumorReadPile.calculateAltVsRefLOD((byte)altAllele, candidate.getTumorF(), 0.0);
                candidate.setTumorLodFStar(tumorLod);
                candidate.setInitialTumorReadDepth(tumorReadPile.finalPileupReads.size());
                candidate.setTumorInsertionCount(tumorReadPile.getInsertionsCount());
                candidate.setTumorDeletionCount(tumorReadPile.getDeletionsCount());
                if (candidate.getTumorLodFStar() < (double)this.MTAC.INITIAL_TUMOR_LOD_THRESHOLD) continue;
                double contaminantF = Math.min(this.contaminantAlternateFraction, candidate.getTumorF());
                VariableAllelicRatioGenotypeLikelihoods contaminantLikelihoods = new VariableAllelicRatioGenotypeLikelihoods(upRef, contaminantF);
                ArrayList<PileupElement> peList = new ArrayList<PileupElement>(tumorReadPile.finalPileup.depthOfCoverage());
                for (PileupElement pe : tumorReadPile.finalPileup) {
                    peList.add(pe);
                }
                Collections.sort(peList, new PileupComparatorByAltRefQual((byte)upRef, (byte)altAllele));
                int readsToKeep = (int)((double)peList.size() * this.contaminantAlternateFraction);
                for (PileupElement pe : peList) {
                    byte base = pe.getBase();
                    if (pe.getBase() == altAllele) {
                        if (readsToKeep == 0) {
                            base = (byte)upRef;
                        } else {
                            --readsToKeep;
                        }
                    }
                    contaminantLikelihoods.add(base, MuTect.qualToUse(pe, false, false, 0));
                }
                double[] refHetHom = LocusReadPile.extractRefHetHom(contaminantLikelihoods, upRef, altAllele);
                double contaminantLod = refHetHom[1] - refHetHom[0];
                candidate.setContaminantLod(contaminantLod);
                QualitySums normQs = normalReadPile.qualitySums;
                VariableAllelicRatioGenotypeLikelihoods normalGl = normalReadPile.calculateLikelihoods(normalReadPile.qualityScoreFilteredPileup);
                candidate.setInitialNormalBestGenotype(normalReadPile.getBestGenotype(normalGl));
                candidate.setInitialNormalLod(LocusReadPile.getRefVsAlt(normalGl, upRef, altAllele));
                double normalF = Math.max(LocusReadPile.estimateAlleleFraction(normalReadPile.qualityScoreFilteredPileup, upRef, altAllele), (double)this.MTAC.MINIMUM_NORMAL_ALLELE_FRACTION);
                candidate.setNormalF(normalF);
                candidate.setNormalLodFStar(normalReadPile.calculateRefVsAltLOD(normalReadPile.qualityScoreFilteredPileup, (byte)altAllele, normalF, 0.0));
                candidate.setNormalArtifactPowerTF(this.normalArtifactPowerCalculator.cachingPowerCalculation(normalBaseCount, candidate.getTumorF()));
                candidate.setNormalArtifactPowerLowTF(this.normalArtifactPowerCalculator.cachingPowerCalculation(normalBaseCount, candidate.getTumorFLowerBound()));
                candidate.setNormalArtifactPowerNF(this.normalArtifactPowerCalculator.cachingPowerCalculation(normalBaseCount, candidate.getNormalF()));
                RecalibratedLocalQualityScores lqs = new RecalibratedLocalQualityScores((byte)upRef, normalReadPile.finalPileup);
                double lodOriginalQualities = LocusReadPile.calculateLogLikelihood(normalReadPile.finalPileup, (byte)upRef, (byte)altAllele, 0.0);
                double lodLqs = LocusReadPile.calculateLogLikelihood(normalReadPile.finalPileup, (byte)upRef, (byte)altAllele, 0.0, lqs);
                double qLod = lodLqs - lodOriginalQualities;
                candidate.setNormalGlobalQualityReferenceLL(lodOriginalQualities);
                candidate.setNormalLocalQualityReferenceLL(lodLqs);
                candidate.setNormalQualityModelLod(qLod);
                VariableAllelicRatioGenotypeLikelihoods normalArtifactGlTF = normalReadPile.calculateLikelihoods(candidate.getTumorF(), normalReadPile.qualityScoreFilteredPileup);
                candidate.setNormalArtifactLodTF(normalReadPile.getAltVsRef(normalArtifactGlTF, upRef, altAllele));
                VariableAllelicRatioGenotypeLikelihoods normalArtifactGlLowTF = normalReadPile.calculateLikelihoods(candidate.getTumorFLowerBound(), normalReadPile.qualityScoreFilteredPileup);
                candidate.setNormalArtifactLodLowTF(normalReadPile.getAltVsRef(normalArtifactGlLowTF, upRef, altAllele));
                VariableAllelicRatioGenotypeLikelihoods normalArtifactGlNF = normalReadPile.calculateLikelihoods(candidate.getNormalF(), normalReadPile.qualityScoreFilteredPileup);
                candidate.setNormalArtifactLodNF(normalReadPile.getAltVsRef(normalArtifactGlNF, upRef, altAllele));
                candidate.setNormalFQuals(LocusReadPile.estimateAlleleFractionUsingQuals(normalReadPile.qualityScoreFilteredPileup, (byte)upRef, (byte)altAllele));
                VariableAllelicRatioGenotypeLikelihoods normalArtifactGlNFQ = normalReadPile.calculateLikelihoods(candidate.getNormalFQuals(), normalReadPile.qualityScoreFilteredPileup);
                candidate.setNormalArtifactLodNFQ(normalReadPile.getAltVsRef(normalArtifactGlNFQ, upRef, altAllele));
                candidate.setInitialNormalAltQualitySum(normQs.getQualitySum(altAllele));
                candidate.setInitialNormalRefQualitySum(normQs.getQualitySum(upRef));
                candidate.setInitialNormalAltCounts(normQs.getCounts(altAllele));
                candidate.setInitialNormalRefCounts(normQs.getCounts(upRef));
                candidate.setInitialNormalReadDepth(normalReadPile.finalPileupReads.size());
                long refStart = Math.max(1, rawContext.getLocation().getStart() - 150);
                String refGATKString = new String(ref.getBases());
                char priorBasePositiveDirection = 'N';
                char priorBaseNegativeDirection = 'N';
                if (this.containsPosition(ref.getWindow(), candidate.getLocation().getStart() - 1)) {
                    priorBasePositiveDirection = (char)ref.getBases()[candidate.getLocation().getStart() - this.MTAC.SEQ_ERROR_MODEL.getPriorBaseOffset() - ref.getWindow().getStart()];
                }
                if (this.containsPosition(ref.getWindow(), candidate.getLocation().getStart() + 1)) {
                    priorBaseNegativeDirection = (char)ref.getBases()[candidate.getLocation().getStart() + this.MTAC.SEQ_ERROR_MODEL.getPriorBaseOffset() - ref.getWindow().getStart()];
                }
                candidate.setPriorBasePositiveDirection(priorBasePositiveDirection);
                candidate.setPriorBaseNegativeDirection(priorBaseNegativeDirection);
                LocusReadPile t2 = this.filterReads(ref, tumorReadPile.finalPileup, true, !this.NO_BAQ);
                if (!this.MTAC.FORCE_OUTPUT && t2.finalPileupReads.size() == 0) continue;
                candidate.setInitialTumorAltCounts(t2.qualitySums.getCounts(altAllele));
                candidate.setInitialTumorRefCounts(t2.qualitySums.getCounts(upRef));
                candidate.setInitialTumorAltQualitySum(t2.qualitySums.getQualitySum(altAllele));
                candidate.setInitialTumorRefQualitySum(t2.qualitySums.getQualitySum(upRef));
                VariableAllelicRatioGenotypeLikelihoods t2Gl = t2.calculateLikelihoods(t2.finalPileup);
                candidate.setInitialTumorLod(t2.getAltVsRef(t2Gl, upRef, altAllele));
                candidate.setInitialTumorReadDepth(t2.finalPileupReads.size());
                candidate.setTumorF(t2.estimateAlleleFraction(upRef, altAllele));
                double tumorLod2 = t2.calculateAltVsRefLOD((byte)altAllele, candidate.getTumorF(), 0.0);
                candidate.setTumorLodFStar(tumorLod2);
                candidate.setTumorLodLQS(t2.calculateAltVsRefLOD((byte)altAllele, candidate.getTumorF(), 0.0, lqs));
                tumorFLB = 0.0;
                refCount = candidate.getInitialTumorRefCounts();
                altCount = candidate.getInitialTumorAltCounts();
                depth = refCount + altCount;
                if (altCount > 0) {
                    BetaDistributionImpl dist = new BetaDistributionImpl(depth - altCount + 1, altCount);
                    tumorFLB = 1.0 - dist.inverseCumulativeProbability(0.975);
                }
                candidate.setTumorFLowerBound(tumorFLB);
                ReadBackedPileup forwardPileup = this.filterReads((ReferenceContext)ref, (ReadBackedPileup)tumorReadPile.finalPileupPositiveStrand, (boolean)true, (boolean)(!this.NO_BAQ ? true : false)).finalPileupPositiveStrand;
                double f2forward = LocusReadPile.estimateAlleleFraction(forwardPileup, upRef, altAllele);
                candidate.setTumorLodFStarForward(t2.calculateAltVsRefLOD(forwardPileup, (byte)altAllele, f2forward, 0.0, null));
                ReadBackedPileup reversePileup = this.filterReads((ReferenceContext)ref, (ReadBackedPileup)tumorReadPile.finalPileupNegativeStrand, (boolean)true, (boolean)(!this.NO_BAQ ? true : false)).finalPileupNegativeStrand;
                double f2reverse = LocusReadPile.estimateAlleleFraction(reversePileup, upRef, altAllele);
                candidate.setTumorLodFStarReverse(t2.calculateAltVsRefLOD(reversePileup, (byte)altAllele, f2reverse, 0.0, null));
                candidate.setPowerToDetectPositiveStrandArtifact(this.strandArtifactPowerCalculator.cachingPowerCalculation(reversePileup.depthOfCoverage(), candidate.getTumorF()));
                candidate.setPowerToDetectNegativeStrandArtifact(this.strandArtifactPowerCalculator.cachingPowerCalculation(forwardPileup.depthOfCoverage(), candidate.getTumorF()));
                ArrayList<PileupElement> mutantPileupElements = new ArrayList<PileupElement>();
                ArrayList<PileupElement> referencePileupElements = new ArrayList<PileupElement>();
                for (PileupElement p : t2.finalPileup) {
                    GATKSAMRecord read = p.getRead();
                    int offset = p.getOffset();
                    if (((SAMRecord)read).getReadString().charAt(offset) == altAllele) {
                        mutantPileupElements.add(p);
                        continue;
                    }
                    if (((SAMRecord)read).getReadString().charAt(offset) != upRef) continue;
                    referencePileupElements.add(p);
                }
                ReadBackedPileupImpl mutantPileup = new ReadBackedPileupImpl(rawContext.getLocation(), (List<PileupElement>)mutantPileupElements);
                ReadBackedPileupImpl referencePileup = new ReadBackedPileupImpl(rawContext.getLocation(), (List<PileupElement>)referencePileupElements);
                LocusReadPile mutantPile = new LocusReadPile(mutantPileup, altAllele, 0, 0);
                LocusReadPile refPile = new LocusReadPile(referencePileup, altAllele, 0, 0);
                byte[] rmq = referencePileup.getMappingQuals();
                candidate.setTumorRefMaxMapQ(rmq.length == 0 ? (byte)0 : NumberUtils.max(rmq));
                byte[] amq = mutantPileup.getMappingQuals();
                candidate.setTumorAltMaxMapQ(amq.length == 0 ? (byte)0 : NumberUtils.max(amq));
                candidate.setPerfectStrandBias(this.calculatePerfectStrandBias(mutantPile));
                candidate.setStrandBias(this.calculateStrandBias(refPile, mutantPile));
                candidate.setTumorAltForwardOffsetsInRead(this.getForwardOffsetsInRead(mutantPileup));
                candidate.setTumorAltReverseOffsetsInRead(this.getReverseOffsetsInRead(mutantPileup));
                if (candidate.getTumorAltForwardOffsetsInRead().size() > 0) {
                    offsets = MuTect.convertIntegersToDoubles(candidate.getTumorAltForwardOffsetsInRead());
                    median = this.getMedian(offsets);
                    candidate.setTumorForwardOffsetsInReadMedian(median);
                    candidate.setTumorForwardOffsetsInReadMad(this.calculateMAD(offsets, median));
                }
                if (candidate.getTumorAltReverseOffsetsInRead().size() > 0) {
                    offsets = MuTect.convertIntegersToDoubles(candidate.getTumorAltReverseOffsetsInRead());
                    median = this.getMedian(offsets);
                    candidate.setTumorReverseOffsetsInReadMedian(median);
                    candidate.setTumorReverseOffsetsInReadMad(this.calculateMAD(offsets, median));
                }
                this.performRejection(candidate);
                if (this.MTAC.FORCE_ALLELES) {
                    this.out.println(this.callStatsGenerator.generateCallStats(candidate));
                    continue;
                }
                messageByTumorLod.put(candidate.getInitialTumorLod(), candidate);
            }
            int passingCandidates = 0;
            for (CandidateMutation c : messageByTumorLod.values()) {
                if (!(c.getTumorLodFStar() >= (double)this.MTAC.TUMOR_LOD_THRESHOLD)) continue;
                ++passingCandidates;
            }
            if (passingCandidates > 1) {
                for (CandidateMutation c : messageByTumorLod.values()) {
                    c.addRejectionReason("triallelic_site");
                }
            }
            if (!messageByTumorLod.isEmpty()) {
                this.out.println(this.callStatsGenerator.generateCallStats((CandidateMutation)messageByTumorLod.lastEntry().getValue()));
            }
            return -1;
        }
        catch (Throwable t) {
            System.err.println("Error processing " + rawContext.getContig() + ":" + rawContext.getPosition());
            t.printStackTrace(System.err);
            throw new RuntimeException(t);
        }
    }

    private String createSequenceContext(ReferenceContext ref, int size) {
        int offset = ref.getLocus().getStart() - ref.getWindow().getStart();
        StringBuilder sb = new StringBuilder(7);
        for (byte b : Arrays.copyOfRange(ref.getBases(), Math.max(0, offset - size), offset)) {
            sb.append(Character.toUpperCase((char)b));
        }
        sb.append('x');
        for (byte b : Arrays.copyOfRange(ref.getBases(), offset + 1, Math.min(ref.getBases().length, offset + 1 + size))) {
            sb.append(Character.toUpperCase((char)b));
        }
        return sb.toString();
    }

    private static byte qualToUse(PileupElement p, boolean ignoreBadBases, boolean capBaseQualsAtMappingQual, int minBaseQual) {
        if (ignoreBadBases && !BaseUtils.isRegularBase(p.getBase())) {
            return 0;
        }
        byte qual = p.getQual();
        if (qual > 93) {
            throw new UserException.MalformedBAM(p.getRead(), String.format("the maximum allowed quality score is %d, but a quality of %d was observed in read %s.  Perhaps your BAM incorrectly encodes the quality scores in Sanger format; see http://en.wikipedia.org/wiki/FASTQ_format for more details", 93, qual, p.getRead().getReadName()));
        }
        if (capBaseQualsAtMappingQual) {
            qual = (byte)Math.min(p.getQual(), p.getMappingQual());
        }
        if (qual < minBaseQual) {
            qual = 0;
        }
        return qual;
    }

    private boolean containsPosition(GenomeLoc window, int position) {
        return window.getStart() <= position && position <= window.getStop();
    }

    private FisherData calculateClippingBias(LocusReadPile refPile, LocusReadPile mutantPile) {
        int a = 0;
        int b = 0;
        int c = 0;
        int d = 0;
        for (GATKSAMRecord rec : refPile.finalPileupReads) {
            if (this.isReadHeavilySoftClipped(rec)) {
                ++b;
                continue;
            }
            ++a;
        }
        for (GATKSAMRecord rec : mutantPile.finalPileupReads) {
            if (this.isReadHeavilySoftClipped(rec)) {
                ++d;
                continue;
            }
            ++c;
        }
        double p = fisher.getTwoTailedP(a, b, c, d);
        int n = c + d;
        double pmaxpos = fisher.getTwoTailedP(a, b, n, 0);
        double pmaxneg = fisher.getTwoTailedP(a, b, 0, n);
        return new FisherData(a, b, c, d, p, pmaxpos, pmaxneg);
    }

    private boolean isReadHeavilySoftClipped(SAMRecord rec) {
        int total = 0;
        int clipped = 0;
        for (CigarElement ce : rec.getCigar().getCigarElements()) {
            total += ce.getLength();
            if (ce.getOperator() != CigarOperator.SOFT_CLIP) continue;
            clipped += ce.getLength();
        }
        return (float)clipped / (float)total >= this.MTAC.HEAVILY_CLIPPED_READ_FRACTION;
    }

    private FisherData calculateStrandBias(LocusReadPile refPile, LocusReadPile mutantPile) {
        int a = 0;
        int b = 0;
        int c = 0;
        int d = 0;
        for (GATKSAMRecord rec : refPile.finalPileupReads) {
            if (rec.getReadNegativeStrandFlag()) {
                ++b;
                continue;
            }
            ++a;
        }
        for (GATKSAMRecord rec : mutantPile.finalPileupReads) {
            if (rec.getReadNegativeStrandFlag()) {
                ++d;
                continue;
            }
            ++c;
        }
        double p = fisher.getTwoTailedP(a, b, c, d);
        int n = c + d;
        double pmaxpos = fisher.getTwoTailedP(a, b, n, 0);
        double pmaxneg = fisher.getTwoTailedP(a, b, 0, n);
        return new FisherData(a, b, c, d, p, pmaxpos, pmaxneg);
    }

    private FisherData calculatePerfectStrandBias(LocusReadPile mutantPile) {
        try {
            int c = 0;
            int d = 0;
            for (GATKSAMRecord rec : mutantPile.finalPileupReads) {
                if (rec.getReadNegativeStrandFlag()) {
                    ++d;
                    continue;
                }
                ++c;
            }
            int trials = c + d;
            BinomialDistributionImpl bd = new BinomialDistributionImpl(trials, 0.5);
            double pmax = bd.cumulativeProbability(0);
            double p = bd.cumulativeProbability(Math.min(c, d));
            return new FisherData(0, 0, c, d, p, pmax, pmax);
        }
        catch (MathException me) {
            throw new RuntimeException("Error in ApacheMath" + me.getMessage(), me);
        }
    }

    private List<Integer> getForwardOffsetsInRead(ReadBackedPileup p) {
        return this.getOffsetsInRead(p, true);
    }

    private List<Integer> getReverseOffsetsInRead(ReadBackedPileup p) {
        return this.getOffsetsInRead(p, false);
    }

    private List<Integer> getOffsetsInRead(ReadBackedPileup p, boolean useForwardOffsets) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (PileupElement pe : p) {
            GATKSAMRecord r = pe.getRead();
            positions.add(Math.abs(p.getLocation().getStart() - (useForwardOffsets ? pe.getRead().getAlignmentStart() : pe.getRead().getAlignmentEnd())));
        }
        return positions;
    }

    private void performRejection(CandidateMutation candidate) {
        if (candidate.getTumorLodFStar() < (double)this.MTAC.TUMOR_LOD_THRESHOLD) {
            candidate.addRejectionReason("fstar_tumor_lod");
        }
        if (this.MTAC.ARTIFACT_DETECTION_MODE) {
            return;
        }
        if (candidate.getTumorInsertionCount() >= this.MTAC.GAP_EVENTS_THRESHOLD || candidate.getTumorDeletionCount() >= this.MTAC.GAP_EVENTS_THRESHOLD) {
            candidate.addRejectionReason("nearby_gap_events");
        }
        if (this.MTAC.FRACTION_CONTAMINATION + this.MTAC.MINIMUM_MUTATION_CELL_FRACTION > 0.0f && candidate.getTumorLodFStar() <= (double)this.MTAC.TUMOR_LOD_THRESHOLD + Math.max(0.0, candidate.getContaminantLod())) {
            candidate.addRejectionReason("possible_contamination");
        }
        if (candidate.isGermlineAtRisk() && candidate.getInitialNormalLod() < (double)this.MTAC.NORMAL_DBSNP_LOD_THRESHOLD) {
            candidate.addRejectionReason("DBSNP Site");
        }
        if (candidate.getInitialNormalLod() < (double)this.MTAC.NORMAL_LOD_THRESHOLD) {
            candidate.addRejectionReason("normal_lod");
        }
        if ((candidate.getInitialNormalAltCounts() >= this.MTAC.MAX_ALT_ALLELES_IN_NORMAL_COUNT || candidate.getNormalF() >= this.MTAC.MAX_ALT_ALLELE_IN_NORMAL_FRACTION) && candidate.getInitialNormalAltQualitySum() > this.MTAC.MAX_ALT_ALLELES_IN_NORMAL_QSCORE_SUM) {
            candidate.addRejectionReason("alt_allele_in_normal");
        }
        if (candidate.getTumorForwardOffsetsInReadMedian() != null && candidate.getTumorForwardOffsetsInReadMedian() <= this.MTAC.PIR_MEDIAN_THRESHOLD && candidate.getTumorForwardOffsetsInReadMad() != null && candidate.getTumorForwardOffsetsInReadMad() <= this.MTAC.PIR_MAD_THRESHOLD || candidate.getTumorReverseOffsetsInReadMedian() != null && candidate.getTumorReverseOffsetsInReadMedian() <= this.MTAC.PIR_MEDIAN_THRESHOLD && candidate.getTumorReverseOffsetsInReadMad() != null && candidate.getTumorReverseOffsetsInReadMad() <= this.MTAC.PIR_MAD_THRESHOLD) {
            candidate.addRejectionReason("clustered_read_position");
        }
        candidate.setPositiveDirectionPowered(candidate.getPerfectStrandBias().getMaxPosP() < 0.05 && candidate.getStrandBias().getMaxPosP() < 0.05);
        candidate.setNegativeDirectionPowered(candidate.getPerfectStrandBias().getMaxNegP() < 0.05 && candidate.getStrandBias().getMaxNegP() < 0.05);
        if (candidate.getPerfectStrandBias().getP() == Double.NaN || candidate.getStrandBias().getP() == Double.NaN) {
            candidate.addRejectionReason("ERROR: Unable to calculate Strand Bias Score");
        }
        if (candidate.getPowerToDetectNegativeStrandArtifact() >= (double)this.MTAC.STRAND_ARTIFACT_POWER_THRESHOLD && candidate.getTumorLodFStarForward() < (double)this.MTAC.STRAND_ARTIFACT_LOD_THRESHOLD || candidate.getPowerToDetectPositiveStrandArtifact() >= (double)this.MTAC.STRAND_ARTIFACT_POWER_THRESHOLD && candidate.getTumorLodFStarReverse() < (double)this.MTAC.STRAND_ARTIFACT_LOD_THRESHOLD) {
            candidate.addRejectionReason("strand_artifact");
        }
        if (candidate.getTotalPairs() > 0 && (float)candidate.getMapQ0Reads() / (float)candidate.getTotalPairs() >= this.MTAC.FRACTION_MAPQ0_THRESHOLD) {
            candidate.addRejectionReason("poor_mapping_region_mapq0");
        }
        if (candidate.getTumorAltMaxMapQ() < this.MTAC.REQUIRED_MAXIMUM_ALT_ALLELE_MAPPING_QUALITY_SCORE) {
            candidate.addRejectionReason("poor_mapping_region_alternate_allele_mapq");
        }
        if (candidate.isSeenInPanelOfNormals() && !candidate.isCosmicSite()) {
            candidate.addRejectionReason("seen_in_panel_of_normals");
        }
    }

    private double calculateMAD(double[] dd, double median) {
        double[] dev = new double[dd.length];
        for (int i = 0; i < dd.length; ++i) {
            dev[i] = Math.abs(dd[i] - median);
        }
        return this.getMedian(dev);
    }

    private double getMedian(double[] data) {
        Double result;
        Arrays.sort(data);
        if (data.length % 2 == 1) {
            result = data[(int)Math.floor(data.length / 2)];
        } else {
            Double lowerMiddle = data[data.length / 2];
            Double upperMiddle = data[data.length / 2 - 1];
            result = (lowerMiddle + upperMiddle) / 2.0;
        }
        return result;
    }

    public static double[] convertIntegersToDoubles(List<Integer> integers) {
        double[] ret = new double[integers.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = integers.get(i).intValue();
        }
        return ret;
    }

    @Override
    public Integer treeReduce(Integer lhs, Integer rhs) {
        return 0;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return 0;
    }

    private LocusReadPile filterReads(ReferenceContext ref, ReadBackedPileup pile, boolean filterMateRescueReads, boolean applyBAQ) {
        ArrayList<PileupElement> newPileupElements = new ArrayList<PileupElement>();
        for (PileupElement p : pile) {
            GATKSAMRecord read = p.getRead();
            int mismatchQualitySum = AlignmentUtils.mismatchesInRefWindow(p, ref, false, true);
            if (mismatchQualitySum > this.MAX_READ_MISMATCH_QUALITY_SCORE_SUM || this.isReadHeavilySoftClipped(read) || filterMateRescueReads && MAPPED_BY_MATE.equals(read.getAttribute("XT"))) continue;
            if (applyBAQ) {
                this.baqHMM.baqRead(read, this.refReader, BAQ.CalculationMode.RECALCULATE, BAQ.QualityMode.OVERWRITE_QUALS);
            }
            newPileupElements.add(new PileupElement(read, p.getOffset(), p.isDeletion(), p.isBeforeDeletionStart(), p.isAfterDeletionEnd(), p.isBeforeInsertion(), p.isAfterInsertion(), p.isNextToSoftClip()));
        }
        ReadBackedPileupImpl newPileup = new ReadBackedPileupImpl(ref.getLocus(), (List<PileupElement>)newPileupElements);
        LocusReadPile newPile = new LocusReadPile(newPileup, (char)ref.getBase(), 0, 0);
        return newPile;
    }

    private float getAltAlleleMismatchRate(SAMRecord read, List<Mismatch> mismatches, int offset, char altAllele) {
        int mmToAlt = 0;
        int mmToOther = 0;
        for (Mismatch mm : mismatches) {
            if ((!read.getReadNegativeStrandFlag() || mm.offset >= offset) && (read.getReadNegativeStrandFlag() || mm.offset <= offset)) continue;
            if (mm.mismatchBase == altAllele) {
                ++mmToAlt;
                continue;
            }
            ++mmToOther;
        }
        return (float)(mmToAlt + 1) / (float)(mmToAlt + mmToOther + 4);
    }

    private int mismatchQualitySum(SAMRecord read, String refSeq, int refIndex, int minMismatchQualityScore) {
        List<Mismatch> mismatches = MuTect.getMismatches(read, refSeq, refIndex);
        return this.mismatchQualitySum(mismatches, minMismatchQualityScore);
    }

    private int mismatchQualitySum(List<Mismatch> mismatches, int minMismatchQualityScore) {
        int sum = 0;
        for (Mismatch mm : mismatches) {
            if (mm.qualityScore < minMismatchQualityScore) continue;
            sum += mm.qualityScore;
        }
        return sum;
    }

    private static List<Mismatch> getMismatches(SAMRecord read, String refSeq, int refIndex) {
        ArrayList<Mismatch> mismatches = new ArrayList<Mismatch>();
        String readSeq = read.getReadString();
        String quals = read.getBaseQualityString();
        int readIndex = 0;
        int sum = 0;
        Cigar c = read.getCigar();
        block5: for (int i = 0; i < c.numCigarElements(); ++i) {
            CigarElement ce = c.getCigarElement(i);
            switch (ce.getOperator()) {
                case M: {
                    int j = 0;
                    while (j < ce.getLength()) {
                        if (refIndex >= refSeq.length()) {
                            sum += 99;
                        } else {
                            char refBase;
                            char readBase = Character.toUpperCase(readSeq.charAt(readIndex));
                            if (readBase != (refBase = Character.toUpperCase(refSeq.charAt(refIndex)))) {
                                int qual = quals.charAt(readIndex) - 33;
                                mismatches.add(new Mismatch(read, readIndex, refIndex, readBase, qual));
                            }
                        }
                        ++j;
                        ++refIndex;
                        ++readIndex;
                    }
                    continue block5;
                }
                case I: {
                    readIndex += ce.getLength();
                    continue block5;
                }
                case D: {
                    refIndex += ce.getLength();
                }
            }
        }
        return mismatches;
    }

    static LinkedHashMap sortByDescendingValue(Map map) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return -1 * ((Comparable)((Map.Entry)o1).getValue()).compareTo(((Map.Entry)o2).getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private ReadSource getReadSource(SAMRecord read) {
        SAMReaderID id = this.getToolkit().getReaderIDForRead(read);
        if (this.tumorSAMReaderIDs.contains(id)) {
            return ReadSource.Tumor;
        }
        if (this.normalSAMReaderIDs.contains(id)) {
            return ReadSource.Normal;
        }
        if (this.controlSAMReaderIDs.contains(id)) {
            return ReadSource.Control;
        }
        throw new RuntimeException("Unable to determine read source (tumor,normal,control) for read " + read.getReadName());
    }

    public static enum ReadSource {
        Tumor,
        Normal,
        Control;

    }

    private static class Mismatch {
        SAMRecord read;
        int offset;
        long position;
        char mismatchBase;
        int qualityScore;

        private Mismatch(SAMRecord read, int offset, long position, char mismatchBase, int qualityScore) {
            this.read = read;
            this.offset = offset;
            this.position = position;
            this.mismatchBase = mismatchBase;
            this.qualityScore = qualityScore;
        }
    }

    public static class FisherData {
        public int a;
        public int b;
        public int c;
        public int d;
        public double p;
        public double maxPosP;
        public double maxNegP;

        public FisherData(int a, int b, int c, int d, double p, double maxPosP, double maxNegP) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.p = p;
            this.maxPosP = maxPosP;
            this.maxNegP = maxNegP;
        }

        public String dataToString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(this.a).append(",");
            sb.append(this.b).append(",");
            sb.append(this.c).append(",");
            sb.append(this.d).append(")");
            return sb.toString();
        }

        public int getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }

        public int getC() {
            return this.c;
        }

        public int getD() {
            return this.d;
        }

        public double getP() {
            return this.p;
        }

        public double getMaxPosP() {
            return this.maxPosP;
        }

        public void setMaxPosP(double maxPosP) {
            this.maxPosP = maxPosP;
        }

        public double getMaxNegP() {
            return this.maxNegP;
        }

        public void setMaxNegP(double maxNegP) {
            this.maxNegP = maxNegP;
        }
    }

    private static class PileupComparatorByAltRefQual
    implements Comparator<PileupElement> {
        private byte ref;
        private byte alt;

        private PileupComparatorByAltRefQual(byte ref, byte alt) {
            this.ref = ref;
            this.alt = alt;
        }

        @Override
        public int compare(PileupElement o1, PileupElement o2) {
            if (o1.getBase() == o2.getBase()) {
                if (o1.getQual() == o2.getQual()) {
                    return 0;
                }
                return o1.getQual() > o2.getQual() ? -1 : 1;
            }
            return o1.getBase() == this.alt ? -1 : 1;
        }
    }

    private static class ThreadLocalRankSumTest
    extends ThreadLocal<RankSumTest> {
        private ThreadLocalRankSumTest() {
        }

        @Override
        public RankSumTest initialValue() {
            return new RankSumTest();
        }
    }
}

