/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.QualitySums;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.RecalibratedLocalQualityScores;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.VariableAllelicRatioGenotypeLikelihoods;
import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidGenotype;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileupImpl;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class LocusReadPile {
    protected ReadBackedPileup pileup;
    List<GATKSAMRecord> finalPileupReads;
    List<Integer> finalPileupOffsets;
    protected char refBase;
    protected int minQualityScore;
    protected int minQSumQualityScore;
    protected QualitySums qualitySums = new QualitySums();
    public ReadBackedPileup initialPileup;
    protected ReadBackedPileup qualityScoreFilteredPileup;
    public ReadBackedPileup finalPileup;
    public ReadBackedPileup finalPileupPositiveStrand;
    public ReadBackedPileup finalPileupNegativeStrand;
    public static final int GAP_EVENT_PROXIMITY = 5;
    protected int deletionsCount = 0;
    protected int insertionsCount = 0;

    public LocusReadPile(ReadBackedPileup pileup, char refBase, int minQualityScore, int minQSumQualityScore) {
        this(pileup, refBase, minQualityScore, minQSumQualityScore, false, false);
    }

    public LocusReadPile(ReadBackedPileup pileup, char refBase, int minQualityScore, int minQSumQualityScore, boolean allowMapq0ForQualSum, boolean retainOverlapMismatches) {
        this.pileup = pileup;
        this.refBase = refBase;
        this.minQSumQualityScore = minQSumQualityScore;
        this.minQualityScore = minQualityScore;
        ReadBackedPileup noOverlapPileup = !retainOverlapMismatches ? LocusReadPile.getOverlappingFragmentFilteredPileup(pileup, (byte)refBase) : LocusReadPile.getOverlappingFragmentFilteredPileupButPreferMismatches(pileup, (byte)refBase);
        this.initialPileup = noOverlapPileup.getPileupWithoutDeletions();
        this.qualityScoreFilteredPileup = this.initialPileup.getBaseFilteredPileup(minQualityScore);
        this.finalPileup = this.qualityScoreFilteredPileup.getPileupWithoutMappingQualityZeroReads();
        this.finalPileupPositiveStrand = pileup.getPileupWithoutDeletions().getBaseFilteredPileup(minQualityScore).getPileupWithoutMappingQualityZeroReads().getPositiveStrandPileup();
        this.finalPileupNegativeStrand = pileup.getPileupWithoutDeletions().getBaseFilteredPileup(minQualityScore).getPileupWithoutMappingQualityZeroReads().getNegativeStrandPileup();
        for (PileupElement p : this.qualityScoreFilteredPileup) {
            if (p.getMappingQual() == 0 && !allowMapq0ForQualSum || p.getQual() <= minQSumQualityScore || p.getQual() <= this.minQSumQualityScore) continue;
            this.qualitySums.incrementSum((char)p.getBase(), p.getRepresentativeCount(), p.getRepresentativeCount() * p.getQual());
        }
        this.finalPileupReads = this.finalPileup.getReads();
        this.finalPileupOffsets = this.finalPileup.getOffsets();
        block1: for (PileupElement p : noOverlapPileup) {
            if (p.getBase() == 68) {
                ++this.deletionsCount;
                continue;
            }
            if (!p.getRead().getCigarString().contains("I") && !p.getRead().getCigarString().contains("D")) continue;
            int eventStart = 0;
            for (CigarElement ce : p.getRead().getCigar().getCigarElements()) {
                if (ce.getOperator() == CigarOperator.INSERTION && Math.abs(eventStart - p.getOffset()) <= 5) {
                    ++this.insertionsCount;
                    continue block1;
                }
                if (ce.getOperator() == CigarOperator.DELETION && Math.abs(eventStart - p.getOffset()) <= 5) {
                    ++this.deletionsCount;
                    continue block1;
                }
                eventStart += ce.getLength();
            }
        }
    }

    public static ReadBackedPileup getOverlappingFragmentFilteredPileupButPreferMismatches(ReadBackedPileup rbp, byte ref) {
        return LocusReadPile.getOverlappingFragmentFilteredPileup(rbp, ref, true);
    }

    public static ReadBackedPileup getOverlappingFragmentFilteredPileup(ReadBackedPileup rbp, byte ref) {
        return LocusReadPile.getOverlappingFragmentFilteredPileup(rbp, ref, false);
    }

    public static ReadBackedPileup getOverlappingFragmentFilteredPileup(ReadBackedPileup rbp, byte ref, boolean retainMismatches) {
        HashMap<String, Integer> filteredPileup = new HashMap<String, Integer>();
        PileupElement[] listOfElements = new PileupElement[rbp.getNumberOfElements()];
        boolean[] elementsToKeep = new boolean[rbp.getNumberOfElements()];
        int i = 0;
        Iterator i$ = rbp.iterator();
        while (i$.hasNext()) {
            PileupElement p;
            listOfElements[i] = p = (PileupElement)i$.next();
            String readName = p.getRead().getReadName();
            if (!filteredPileup.containsKey(readName)) {
                filteredPileup.put(readName, i);
                elementsToKeep[i] = true;
            } else {
                int existingIndex = (Integer)filteredPileup.get(readName);
                PileupElement existing = listOfElements[existingIndex];
                if (existing.getBase() != p.getBase()) {
                    if (!retainMismatches) {
                        filteredPileup.remove(readName);
                        elementsToKeep[existingIndex] = false;
                    } else if (p.getBase() != ref) {
                        elementsToKeep[existingIndex] = false;
                        filteredPileup.put(readName, i);
                        elementsToKeep[i] = true;
                    }
                } else if (existing.getQual() < p.getQual()) {
                    elementsToKeep[existingIndex] = false;
                    filteredPileup.put(readName, i);
                    elementsToKeep[i] = true;
                }
            }
            ++i;
        }
        ArrayList<PileupElement> sortedList = new ArrayList<PileupElement>(rbp.getNumberOfElements());
        for (int j = 0; j < elementsToKeep.length; ++j) {
            Boolean b = elementsToKeep[j];
            if (b == null || !b.booleanValue()) continue;
            sortedList.add(listOfElements[j]);
        }
        return new ReadBackedPileupImpl(rbp.getLocation(), (List<PileupElement>)sortedList);
    }

    public double estimateAlleleFraction(char ref, char alt) {
        return LocusReadPile.estimateAlleleFraction(this.finalPileup, ref, alt);
    }

    public static double estimateAlleleFraction(ReadBackedPileup pileup, char ref, char alt) {
        double altCount;
        int[] counts = pileup.getBaseCounts();
        double refCount = counts[BaseUtils.simpleBaseToBaseIndex((byte)ref)];
        double depth = refCount + (altCount = (double)counts[BaseUtils.simpleBaseToBaseIndex((byte)alt)]);
        return depth == 0.0 ? 0.0 : altCount / depth;
    }

    public static double estimateAlleleFractionUsingQuals(ReadBackedPileup pileup, byte ref, byte alt) {
        double refOrAltCount = 0.0;
        double altCount = 0.0;
        for (PileupElement pe : pileup) {
            double e = Math.pow(10.0, -1 * pe.getQual() / 10);
            if (pe.getBase() == ref) {
                altCount += e / 3.0;
                refOrAltCount += 1.0;
                continue;
            }
            if (pe.getBase() != alt) continue;
            altCount += 1.0 - e;
            refOrAltCount += 1.0;
        }
        return refOrAltCount == 0.0 ? 0.0 : altCount / refOrAltCount;
    }

    public double calculateLogLikelihood(byte alt, double f) {
        return LocusReadPile.calculateLogLikelihood(this.finalPileup, (byte)this.refBase, alt, f);
    }

    public double calculateAltVsRefLOD(byte alt, double fAlternate, double fReference) {
        return this.calculateAltVsRefLOD(alt, fAlternate, fReference, null);
    }

    public double calculateAltVsRefLOD(ReadBackedPileup pileup, byte alt, double fAlternate, double fReference, RecalibratedLocalQualityScores lqs) {
        double lodAlt = LocusReadPile.calculateLogLikelihood(pileup, (byte)this.refBase, alt, fAlternate, lqs);
        double lodRef = LocusReadPile.calculateLogLikelihood(pileup, (byte)this.refBase, alt, fReference, lqs);
        return lodAlt - lodRef;
    }

    public double calculateAltVsRefLOD(byte alt, double fAlternate, double fReference, RecalibratedLocalQualityScores lqs) {
        return this.calculateAltVsRefLOD(this.finalPileup, alt, fAlternate, fReference, lqs);
    }

    public double calculateRefVsAltLOD(ReadBackedPileup pileup, byte alt, double fAlternate, double fReference) {
        return this.calculateRefVsAltLOD(pileup, alt, fAlternate, fReference, null);
    }

    public double calculateRefVsAltLOD(ReadBackedPileup pileup, byte alt, double fAlternate, double fReference, RecalibratedLocalQualityScores lqs) {
        return -1.0 * this.calculateAltVsRefLOD(pileup, alt, fAlternate, fReference, lqs);
    }

    public static double calculateLogLikelihood(ReadBackedPileup pileup, byte ref, byte alt, double f, RecalibratedLocalQualityScores lqs) {
        double ll = 0.0;
        for (PileupElement pe : pileup) {
            byte base = pe.getBase();
            byte qual = pe.getQual();
            if (lqs != null) {
                qual = lqs.getQual(pe);
            }
            double e = Math.pow(10.0, (double)qual / -10.0);
            if (base == ref) {
                ll += Math.log10(f * e / 3.0 + (1.0 - f) * (1.0 - e));
                continue;
            }
            if (base == alt) {
                ll += Math.log10(f * (1.0 - e) + (1.0 - f) * e / 3.0);
                continue;
            }
            ll += Math.log10(2.0 * e / 3.0);
        }
        return ll;
    }

    public static double calculateLogLikelihood(ReadBackedPileup pileup, byte ref, byte alt, double f) {
        return LocusReadPile.calculateLogLikelihood(pileup, ref, alt, f, null);
    }

    public VariableAllelicRatioGenotypeLikelihoods calculateLikelihoods(ReadBackedPileup pileup) {
        return this.calculateLikelihoods(0.5, pileup);
    }

    public VariableAllelicRatioGenotypeLikelihoods calculateLikelihoods(double alpha, ReadBackedPileup pileup) {
        VariableAllelicRatioGenotypeLikelihoods likelihoods = new VariableAllelicRatioGenotypeLikelihoods(this.refBase, alpha);
        for (PileupElement pe : pileup) {
            likelihoods.add(pe, false, false, this.minQualityScore);
        }
        return likelihoods;
    }

    public int getFilteredBaseCount(int minBaseQualityScore) {
        return this.finalPileup.getBaseFilteredPileup(minBaseQualityScore).depthOfCoverage();
    }

    public List<Byte> getLocusBases(int locusOffset) {
        ArrayList<Byte> bases = new ArrayList<Byte>(this.finalPileupReads.size());
        for (int i = 0; i < this.finalPileupReads.size(); ++i) {
            byte base;
            SAMRecord read = this.finalPileupReads.get(i);
            int readOffset = this.finalPileupOffsets.get(i);
            int offset = readOffset + locusOffset;
            if (offset < 0 || offset >= read.getReadString().length() || (base = read.getReadBases()[offset]) == 78) continue;
            bases.add(read.getReadBases()[offset]);
        }
        return bases;
    }

    public List<Byte> getQualityScores(int locusOffset, char allele) {
        ArrayList<Byte> scores = new ArrayList<Byte>();
        for (int i = 0; i < this.finalPileupReads.size(); ++i) {
            SAMRecord read = this.finalPileupReads.get(i);
            int readOffset = this.finalPileupOffsets.get(i);
            int offset = readOffset + locusOffset;
            if (offset < 0 || offset >= read.getReadString().length()) continue;
            char base = read.getReadString().charAt(offset);
            byte qual = read.getBaseQualities()[offset];
            if (base != allele) continue;
            scores.add(qual);
        }
        return scores;
    }

    public List<Integer> getPositionsInRead(char allele) {
        return this.getPositionsInRead(0, allele);
    }

    public List<Integer> getPositionsInRead(int locusOffset, char allele) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (int i = 0; i < this.finalPileupReads.size(); ++i) {
            char base;
            SAMRecord read = this.finalPileupReads.get(i);
            int readOffset = this.finalPileupOffsets.get(i);
            int offset = readOffset + locusOffset;
            if (offset < 0 || offset >= read.getReadString().length() || (base = read.getReadString().charAt(offset)) != allele) continue;
            positions.add(offset);
        }
        return positions;
    }

    public DiploidGenotype getBestGenotype(VariableAllelicRatioGenotypeLikelihoods likelihoods) {
        DiploidGenotype best = null;
        Double bestLikelihood = null;
        for (DiploidGenotype gt : DiploidGenotype.values()) {
            double likelihood = likelihoods.getLikelihood(gt);
            if (bestLikelihood != null && !(likelihood >= bestLikelihood)) continue;
            best = gt;
            bestLikelihood = likelihood;
        }
        return best;
    }

    public static double getRefVsNextBest(VariableAllelicRatioGenotypeLikelihoods likelihoods, char ref) {
        Double refLikelihood = null;
        Double nextBest = null;
        for (DiploidGenotype gt : DiploidGenotype.values()) {
            double likelihood = likelihoods.getLikelihood(gt);
            if (gt.base1 == ref && gt.base2 == ref) {
                refLikelihood = likelihood;
                continue;
            }
            if (nextBest != null && !(likelihood >= nextBest)) continue;
            nextBest = likelihood;
        }
        return refLikelihood - nextBest;
    }

    public double getHetVsRef(VariableAllelicRatioGenotypeLikelihoods likelihoods, char ref, char altAllele) {
        double[] refHetHom = LocusReadPile.extractRefHetHom(likelihoods, ref, altAllele);
        return refHetHom[1] - refHetHom[0];
    }

    public double getRefVsHet(VariableAllelicRatioGenotypeLikelihoods likelihoods, char ref, char altAllele) {
        double[] refHetHom = LocusReadPile.extractRefHetHom(likelihoods, ref, altAllele);
        return refHetHom[0] - refHetHom[1];
    }

    public double getAltVsRef(VariableAllelicRatioGenotypeLikelihoods likelihoods, char ref, char altAllele) {
        double[] refHetHom = LocusReadPile.extractRefHetHom(likelihoods, ref, altAllele);
        double tumorLod = LocusReadPile.logAddSafe(refHetHom[1], refHetHom[2]) - refHetHom[0];
        return tumorLod;
    }

    public static double getRefVsAlt(VariableAllelicRatioGenotypeLikelihoods likelihoods, char ref, char altAllele) {
        double[] refHetHom = LocusReadPile.extractRefHetHom(likelihoods, ref, altAllele);
        double normalLod = refHetHom[0] - LocusReadPile.logAddSafe(refHetHom[1], refHetHom[2]);
        return normalLod;
    }

    private double[] extractRefAlt(VariableAllelicRatioGenotypeLikelihoods gl, char ref, char altAllele) {
        double refRef = 0.0;
        double altRef = 0.0;
        double altAlt = 0.0;
        for (DiploidGenotype gt : DiploidGenotype.values()) {
            double likelihood = gl.getLikelihood(gt);
            if (gt.base1 == ref && gt.base2 == altAllele || gt.base1 == altAllele && gt.base2 == ref) {
                altRef += Math.pow(10.0, likelihood);
            }
            if (gt.base1 == altAllele && gt.base2 == altAllele) {
                altAlt += Math.pow(10.0, likelihood);
            }
            if (gt.base1 != ref || gt.base2 != ref) continue;
            refRef = likelihood;
        }
        return new double[]{refRef, altRef, altAlt};
    }

    protected static double[] extractRefHetHom(VariableAllelicRatioGenotypeLikelihoods gl, char refAllele, char altAllele) {
        double ref = 0.0;
        double het = 0.0;
        double hom = 0.0;
        for (DiploidGenotype gt : DiploidGenotype.values()) {
            double likelihood = gl.getLikelihood(gt);
            if (gt.base1 == refAllele && gt.base2 == refAllele) {
                ref = likelihood;
            }
            if (gt.base1 == refAllele && gt.base2 == altAllele || gt.base1 == altAllele && gt.base2 == refAllele) {
                het = likelihood;
            }
            if (gt.base1 != altAllele || gt.base2 != altAllele) continue;
            hom = likelihood;
        }
        return new double[]{ref, het, hom};
    }

    private static double logAddSafe(double inOne, double inTwo) {
        double a = inOne > inTwo ? inOne : inTwo;
        double b = inOne > inTwo ? inTwo : inOne;
        return a + Math.log(1.0 + Math.pow(10.0, b - a));
    }

    public int getDeletionsCount() {
        return this.deletionsCount;
    }

    public int getInsertionsCount() {
        return this.insertionsCount;
    }

    private static class PileupElementAlignmentStartPositionComparator
    implements Comparator<PileupElement> {
        private PileupElementAlignmentStartPositionComparator() {
        }

        @Override
        public int compare(PileupElement pe1, PileupElement pe2) {
            if (pe1.getRead().getAlignmentStart() < pe2.getRead().getAlignmentStart()) {
                return -1;
            }
            return 1;
        }
    }

    private static class ElementInfo {
        public PileupElement p;
        public Integer index;

        private ElementInfo(PileupElement p, Integer index) {
            this.p = p;
            this.index = index;
        }
    }
}

