/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.cga.tools.gatk.filters;

import java.util.Arrays;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.gatk.filters.ReadFilter;

public class ReassignBaseQualityFilter
extends ReadFilter {
    @Argument(fullName="forced_base_quality", shortName="FBQ", doc="Forced base mapping quality to assign to all bases", required=false)
    public byte forceBaseQuality = (byte)30;

    @Override
    public boolean filterOut(SAMRecord rec) {
        byte[] quals = rec.getBaseQualities();
        Arrays.fill(quals, this.forceBaseQuality);
        rec.setBaseQualities(quals);
        return false;
    }
}

