/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.recalibration.EventType;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class AlignmentUtils {
    public static long mismatchingQualities(SAMRecord r, byte[] refSeq, int refIndex) {
        return AlignmentUtils.getMismatchCount((SAMRecord)r, (byte[])refSeq, (int)refIndex).mismatchQualities;
    }

    public static MismatchCount getMismatchCount(SAMRecord r, byte[] refSeq, int refIndex) {
        return AlignmentUtils.getMismatchCount(r, refSeq, refIndex, 0, r.getReadLength());
    }

    public static MismatchCount getMismatchCount(SAMRecord r, byte[] refSeq, int refIndex, int startOnRead, int nReadBases) {
        MismatchCount mc = new MismatchCount();
        int readIdx = 0;
        int endOnRead = startOnRead + nReadBases - 1;
        byte[] readSeq = r.getReadBases();
        Cigar c = r.getCigar();
        block8: for (int i = 0; i < c.numCigarElements() && readIdx <= endOnRead; ++i) {
            CigarElement ce = c.getCigarElement(i);
            int elementLength = ce.getLength();
            switch (ce.getOperator()) {
                case X: {
                    int j;
                    mc.numMismatches += elementLength;
                    for (j = 0; j < elementLength; ++j) {
                        mc.mismatchQualities += (long)r.getBaseQualities()[readIdx + j];
                    }
                }
                case EQ: {
                    refIndex += elementLength;
                    readIdx += elementLength;
                    continue block8;
                }
                case M: {
                    int j = 0;
                    while (j < elementLength) {
                        if (refIndex < refSeq.length && readIdx >= startOnRead) {
                            if (readIdx > endOnRead) continue block8;
                            byte readChr = readSeq[readIdx];
                            byte refChr = refSeq[refIndex];
                            if (readChr != refChr) {
                                ++mc.numMismatches;
                                mc.mismatchQualities += (long)r.getBaseQualities()[readIdx];
                            }
                        }
                        ++j;
                        ++refIndex;
                        ++readIdx;
                    }
                    continue block8;
                }
                case I: 
                case S: {
                    readIdx += elementLength;
                    continue block8;
                }
                case D: 
                case N: {
                    refIndex += elementLength;
                    continue block8;
                }
                case H: 
                case P: {
                    continue block8;
                }
                default: {
                    throw new ReviewedStingException("The " + (Object)((Object)ce.getOperator()) + " cigar element is not currently supported");
                }
            }
        }
        return mc;
    }

    public static int mismatchesInRefWindow(ReadBackedPileup pileup, ReferenceContext ref, boolean ignoreTargetSite) {
        int mismatches = 0;
        for (PileupElement p : pileup) {
            mismatches += AlignmentUtils.mismatchesInRefWindow(p, ref, ignoreTargetSite);
        }
        return mismatches;
    }

    public static int mismatchesInRefWindow(PileupElement p, ReferenceContext ref, boolean ignoreTargetSite) {
        return AlignmentUtils.mismatchesInRefWindow(p, ref, ignoreTargetSite, false);
    }

    public static int mismatchesInRefWindow(PileupElement p, ReferenceContext ref, boolean ignoreTargetSite, boolean qualitySumInsteadOfMismatchCount) {
        int sum = 0;
        int windowStart = ref.getWindow().getStart();
        int windowStop = ref.getWindow().getStop();
        byte[] refBases = ref.getBases();
        byte[] readBases = p.getRead().getReadBases();
        byte[] readQualities = p.getRead().getBaseQualities();
        Cigar c = p.getRead().getCigar();
        int readIndex = 0;
        int currentPos = p.getRead().getAlignmentStart();
        int refIndex = Math.max(0, currentPos - windowStart);
        block5: for (int i = 0; i < c.numCigarElements(); ++i) {
            CigarElement ce = c.getCigarElement(i);
            int cigarElementLength = ce.getLength();
            switch (ce.getOperator()) {
                case X: 
                case EQ: 
                case M: {
                    int j = 0;
                    while (j < cigarElementLength && currentPos <= windowStop) {
                        if (currentPos >= windowStart) {
                            byte readChr;
                            byte refChr = refBases[refIndex++];
                            if (!(ignoreTargetSite && ref.getLocus().getStart() == currentPos || (readChr = readBases[readIndex]) == refChr)) {
                                sum += qualitySumInsteadOfMismatchCount ? readQualities[readIndex] : 1;
                            }
                        }
                        ++j;
                        ++readIndex;
                        ++currentPos;
                    }
                    continue block5;
                }
                case I: 
                case S: {
                    readIndex += cigarElementLength;
                    continue block5;
                }
                case D: 
                case N: {
                    if ((currentPos += cigarElementLength) <= windowStart) continue block5;
                    refIndex += Math.min(cigarElementLength, currentPos - windowStart);
                    continue block5;
                }
            }
        }
        return sum;
    }

    public static int getNumAlignmentBlocks(SAMRecord r) {
        int n = 0;
        Cigar cigar = r.getCigar();
        if (cigar == null) {
            return 0;
        }
        for (CigarElement e : cigar.getCigarElements()) {
            if (e.getOperator() != CigarOperator.M) continue;
            ++n;
        }
        return n;
    }

    public static int getNumAlignedBases(SAMRecord r) {
        int n = 0;
        Cigar cigar = r.getCigar();
        if (cigar == null) {
            return 0;
        }
        for (CigarElement e : cigar.getCigarElements()) {
            if (e.getOperator() != CigarOperator.M) continue;
            n += e.getLength();
        }
        return n;
    }

    public static int getNumAlignedBasesCountingSoftClips(SAMRecord r) {
        int n = 0;
        Cigar cigar = r.getCigar();
        if (cigar == null) {
            return 0;
        }
        for (CigarElement e : cigar.getCigarElements()) {
            if (e.getOperator() != CigarOperator.M && e.getOperator() != CigarOperator.S) continue;
            n += e.getLength();
        }
        return n;
    }

    public static int getNumHardClippedBases(SAMRecord r) {
        int n = 0;
        Cigar cigar = r.getCigar();
        if (cigar == null) {
            return 0;
        }
        for (CigarElement e : cigar.getCigarElements()) {
            if (e.getOperator() != CigarOperator.H) continue;
            n += e.getLength();
        }
        return n;
    }

    public static int calcNumHighQualitySoftClips(GATKSAMRecord read, byte qualThreshold) {
        int numHQSoftClips = 0;
        int alignPos = 0;
        Cigar cigar = read.getCigar();
        byte[] qual = read.getBaseQualities(EventType.BASE_SUBSTITUTION);
        block5: for (int iii = 0; iii < cigar.numCigarElements(); ++iii) {
            CigarElement ce = cigar.getCigarElement(iii);
            int elementLength = ce.getLength();
            switch (ce.getOperator()) {
                case S: {
                    for (int jjj = 0; jjj < elementLength; ++jjj) {
                        if (qual[alignPos++] <= qualThreshold) continue;
                        ++numHQSoftClips;
                    }
                    continue block5;
                }
                case X: 
                case EQ: 
                case M: 
                case I: {
                    alignPos += elementLength;
                    continue block5;
                }
                case D: 
                case N: 
                case H: 
                case P: {
                    continue block5;
                }
                default: {
                    throw new ReviewedStingException("Unsupported cigar operator: " + (Object)((Object)ce.getOperator()));
                }
            }
        }
        return numHQSoftClips;
    }

    public static int calcAlignmentByteArrayOffset(Cigar cigar, PileupElement pileupElement, int alignmentStart, int refLocus) {
        return AlignmentUtils.calcAlignmentByteArrayOffset(cigar, pileupElement.getOffset(), pileupElement.isInsertionAtBeginningOfRead(), pileupElement.isDeletion(), alignmentStart, refLocus);
    }

    public static int calcAlignmentByteArrayOffset(Cigar cigar, int offset, boolean isInsertionAtBeginningOfRead, boolean isDeletion, int alignmentStart, int refLocus) {
        int pileupOffset = offset;
        if (isInsertionAtBeginningOfRead) {
            return 0;
        }
        if (isDeletion) {
            pileupOffset = refLocus - alignmentStart;
            CigarElement ce = cigar.getCigarElement(0);
            if (ce.getOperator() == CigarOperator.S) {
                pileupOffset += ce.getLength();
            }
        }
        int pos = 0;
        int alignmentPos = 0;
        block6: for (int iii = 0; iii < cigar.numCigarElements(); ++iii) {
            CigarElement ce = cigar.getCigarElement(iii);
            int elementLength = ce.getLength();
            switch (ce.getOperator()) {
                case I: 
                case S: {
                    if ((pos += elementLength) < pileupOffset) continue block6;
                    return alignmentPos;
                }
                case D: {
                    if (!isDeletion) {
                        alignmentPos += elementLength;
                        continue block6;
                    }
                    if (pos + elementLength - 1 >= pileupOffset) {
                        return alignmentPos + (pileupOffset - pos);
                    }
                    pos += elementLength;
                    alignmentPos += elementLength;
                    continue block6;
                }
                case X: 
                case EQ: 
                case M: {
                    if (pos + elementLength - 1 >= pileupOffset) {
                        return alignmentPos + (pileupOffset - pos);
                    }
                    pos += elementLength;
                    alignmentPos += elementLength;
                    continue block6;
                }
                case N: 
                case H: 
                case P: {
                    continue block6;
                }
                default: {
                    throw new ReviewedStingException("Unsupported cigar operator: " + (Object)((Object)ce.getOperator()));
                }
            }
        }
        return alignmentPos;
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] readToAlignmentByteArray(Cigar cigar, byte[] read) {
        alignmentLength = 0;
        block11: for (iii = 0; iii < cigar.numCigarElements(); ++iii) {
            ce = cigar.getCigarElement(iii);
            elementLength = ce.getLength();
            switch (1.$SwitchMap$net$sf$samtools$CigarOperator[ce.getOperator().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    alignmentLength += elementLength;
                    continue block11;
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: {
                    continue block11;
                }
                default: {
                    throw new ReviewedStingException("Unsupported cigar operator: " + (Object)ce.getOperator());
                }
            }
        }
        alignment = new byte[alignmentLength];
        alignPos = 0;
        readPos = 0;
        block12: for (iii = 0; iii < cigar.numCigarElements(); ++iii) {
            ce = cigar.getCigarElement(iii);
            elementLength = ce.getLength();
            switch (1.$SwitchMap$net$sf$samtools$CigarOperator[ce.getOperator().ordinal()]) {
                case 4: {
                    if (alignPos <= 0) ** GOTO lbl33
                    if (alignment[alignPos - 1] != 65) ** GOTO lbl25
                    alignment[alignPos - 1] = 87;
                    ** GOTO lbl33
lbl25:
                    // 1 sources

                    if (alignment[alignPos - 1] != 67) ** GOTO lbl28
                    alignment[alignPos - 1] = 88;
                    ** GOTO lbl33
lbl28:
                    // 1 sources

                    if (alignment[alignPos - 1] != 84) ** GOTO lbl31
                    alignment[alignPos - 1] = 89;
                    ** GOTO lbl33
lbl31:
                    // 1 sources

                    if (alignment[alignPos - 1] == 71) {
                        alignment[alignPos - 1] = 90;
                    }
                }
lbl33:
                // 8 sources

                case 5: {
                    for (jjj = 0; jjj < elementLength; ++jjj) {
                        ++readPos;
                    }
                    continue block12;
                }
                case 6: 
                case 7: {
                    for (jjj = 0; jjj < elementLength; ++jjj) {
                        alignment[alignPos] = 68;
                        ++alignPos;
                    }
                    continue block12;
                }
                case 1: 
                case 2: 
                case 3: {
                    for (jjj = 0; jjj < elementLength; ++jjj) {
                        alignment[alignPos] = read[readPos];
                        ++alignPos;
                        ++readPos;
                    }
                    continue block12;
                }
                case 8: 
                case 9: {
                    continue block12;
                }
                default: {
                    throw new ReviewedStingException("Unsupported cigar operator: " + (Object)ce.getOperator());
                }
            }
        }
        return alignment;
    }

    public static boolean isReadGenomeLocUnmapped(SAMRecord r) {
        return "*".equals(r.getReferenceName());
    }

    public static boolean isReadUnmapped(SAMRecord r) {
        if (r.getReadUnmappedFlag()) {
            return true;
        }
        return (r.getReferenceIndex() == null || r.getReferenceIndex() == -1) && (r.getReferenceName() == null || r.getReferenceName().equals("*")) || r.getAlignmentStart() == 0;
    }

    public static boolean isMateUnmapped(SAMRecord r) {
        if (r.getMateUnmappedFlag()) {
            return true;
        }
        return (r.getMateReferenceIndex() == null || r.getMateReferenceIndex() == -1) && (r.getMateReferenceName() == null || r.getMateReferenceName().equals("*")) || r.getMateAlignmentStart() == 0;
    }

    public static boolean isReadUniquelyMapped(SAMRecord read) {
        return !AlignmentUtils.isReadUnmapped(read) && read.getMappingQuality() > 0;
    }

    public static byte[] getQualsInCycleOrder(SAMRecord read) {
        if (AlignmentUtils.isReadUnmapped(read) || !read.getReadNegativeStrandFlag()) {
            return read.getBaseQualities();
        }
        return Utils.reverse(read.getBaseQualities());
    }

    public static byte[] getOriginalQualsInCycleOrder(SAMRecord read) {
        if (AlignmentUtils.isReadUnmapped(read) || !read.getReadNegativeStrandFlag()) {
            return read.getOriginalBaseQualities();
        }
        return Utils.reverse(read.getOriginalBaseQualities());
    }

    public static Cigar leftAlignIndel(Cigar cigar, byte[] refSeq, byte[] readSeq, int refIndex, int readIndex) {
        int indexOfIndel = -1;
        for (int i = 0; i < cigar.numCigarElements(); ++i) {
            CigarElement ce = cigar.getCigarElement(i);
            if (ce.getOperator() != CigarOperator.D && ce.getOperator() != CigarOperator.I) continue;
            if (indexOfIndel != -1) {
                return cigar;
            }
            indexOfIndel = i;
        }
        if (indexOfIndel < 1) {
            return cigar;
        }
        int indelLength = cigar.getCigarElement(indexOfIndel).getLength();
        byte[] altString = AlignmentUtils.createIndelString(cigar, indexOfIndel, refSeq, readSeq, refIndex, readIndex);
        if (altString == null) {
            return cigar;
        }
        Cigar newCigar = cigar;
        for (int i = 0; i < indelLength; ++i) {
            newCigar = AlignmentUtils.moveCigarLeft(newCigar, indexOfIndel);
            byte[] newAltString = AlignmentUtils.createIndelString(newCigar, indexOfIndel, refSeq, readSeq, refIndex, readIndex);
            boolean reachedEndOfRead = AlignmentUtils.cigarHasZeroSizeElement(newCigar);
            if (Arrays.equals(altString, newAltString)) {
                cigar = newCigar;
                i = -1;
                if (reachedEndOfRead) {
                    cigar = AlignmentUtils.cleanUpCigar(cigar);
                }
            }
            if (reachedEndOfRead) break;
        }
        return cigar;
    }

    private static boolean cigarHasZeroSizeElement(Cigar c) {
        for (CigarElement ce : c.getCigarElements()) {
            if (ce.getLength() != 0) continue;
            return true;
        }
        return false;
    }

    private static Cigar cleanUpCigar(Cigar c) {
        ArrayList<CigarElement> elements = new ArrayList<CigarElement>(c.numCigarElements() - 1);
        for (CigarElement ce : c.getCigarElements()) {
            if (ce.getLength() == 0 || elements.size() == 0 && ce.getOperator() == CigarOperator.D) continue;
            elements.add(ce);
        }
        return new Cigar(elements);
    }

    private static Cigar moveCigarLeft(Cigar cigar, int indexOfIndel) {
        ArrayList<CigarElement> elements = new ArrayList<CigarElement>(cigar.numCigarElements());
        for (int i = 0; i < indexOfIndel - 1; ++i) {
            elements.add(cigar.getCigarElement(i));
        }
        CigarElement ce = cigar.getCigarElement(indexOfIndel - 1);
        elements.add(new CigarElement(ce.getLength() - 1, ce.getOperator()));
        elements.add(cigar.getCigarElement(indexOfIndel));
        if (indexOfIndel + 1 < cigar.numCigarElements()) {
            ce = cigar.getCigarElement(indexOfIndel + 1);
            elements.add(new CigarElement(ce.getLength() + 1, ce.getOperator()));
        } else {
            elements.add(new CigarElement(1, CigarOperator.M));
        }
        for (int i = indexOfIndel + 2; i < cigar.numCigarElements(); ++i) {
            elements.add(cigar.getCigarElement(i));
        }
        return new Cigar(elements);
    }

    private static byte[] createIndelString(Cigar cigar, int indexOfIndel, byte[] refSeq, byte[] readSeq, int refIndex, int readIndex) {
        byte[] alt;
        CigarElement indel = cigar.getCigarElement(indexOfIndel);
        int indelLength = indel.getLength();
        int totalRefBases = 0;
        block5: for (int i = 0; i < indexOfIndel; ++i) {
            CigarElement ce = cigar.getCigarElement(i);
            int length = ce.getLength();
            switch (ce.getOperator()) {
                case X: 
                case EQ: 
                case M: {
                    readIndex += length;
                    refIndex += length;
                    totalRefBases += length;
                    continue block5;
                }
                case S: {
                    readIndex += length;
                    continue block5;
                }
                case N: {
                    refIndex += length;
                    totalRefBases += length;
                    continue block5;
                }
            }
        }
        if (totalRefBases + indelLength > refSeq.length) {
            indelLength -= totalRefBases + indelLength - refSeq.length;
        }
        if (refIndex > (alt = new byte[refSeq.length + indelLength * (indel.getOperator() == CigarOperator.D ? -1 : 1)]).length || refIndex > refSeq.length) {
            return null;
        }
        System.arraycopy(refSeq, 0, alt, 0, refIndex);
        int currentPos = refIndex;
        if (indel.getOperator() == CigarOperator.D) {
            refIndex += indelLength;
        } else {
            System.arraycopy(readSeq, readIndex, alt, currentPos, indelLength);
            currentPos += indelLength;
        }
        if (refSeq.length - refIndex > alt.length - currentPos) {
            return null;
        }
        System.arraycopy(refSeq, refIndex, alt, currentPos, refSeq.length - refIndex);
        return alt;
    }

    public static class MismatchCount {
        public int numMismatches = 0;
        public long mismatchQualities = 0L;
    }
}

