/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration.covariates;

import java.util.HashMap;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.utils.recalibration.ReadCovariates;
import org.broadinstitute.sting.utils.recalibration.covariates.RequiredCovariate;
import org.broadinstitute.sting.utils.sam.GATKSAMReadGroupRecord;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ReadGroupCovariate
implements RequiredCovariate {
    private final HashMap<String, Integer> readGroupLookupTable = new HashMap();
    private final HashMap<Integer, String> readGroupReverseLookupTable = new HashMap();
    private int nextId = 0;

    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
    }

    @Override
    public void recordValues(GATKSAMRecord read, ReadCovariates values) {
        String readGroupId = this.readGroupValueFromRG(read.getReadGroup());
        int key = this.keyForReadGroup(readGroupId);
        int l = read.getReadLength();
        for (int i = 0; i < l; ++i) {
            values.addCovariate(key, key, key, i);
        }
    }

    @Override
    public final Object getValue(String str) {
        return str;
    }

    @Override
    public String formatKey(int key) {
        return this.readGroupReverseLookupTable.get(key);
    }

    @Override
    public int keyFromValue(Object value) {
        return this.keyForReadGroup((String)value);
    }

    private int keyForReadGroup(String readGroupId) {
        if (!this.readGroupLookupTable.containsKey(readGroupId)) {
            this.readGroupLookupTable.put(readGroupId, this.nextId);
            this.readGroupReverseLookupTable.put(this.nextId, readGroupId);
            ++this.nextId;
        }
        return this.readGroupLookupTable.get(readGroupId);
    }

    @Override
    public int maximumKeyValue() {
        return this.readGroupLookupTable.size() - 1;
    }

    private String readGroupValueFromRG(GATKSAMReadGroupRecord rg) {
        String platformUnit = rg.getPlatformUnit();
        return platformUnit == null ? rg.getId() : platformUnit;
    }
}

