/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.traversals;

import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.WalkerManager;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.datasources.providers.AllLocusView;
import org.broadinstitute.sting.gatk.datasources.providers.CoveredLocusView;
import org.broadinstitute.sting.gatk.datasources.providers.LocusReferenceView;
import org.broadinstitute.sting.gatk.datasources.providers.LocusShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.LocusView;
import org.broadinstitute.sting.gatk.datasources.providers.ManagingReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.ReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.RodLocusView;
import org.broadinstitute.sting.gatk.traversals.TraversalEngine;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileupImpl;

public abstract class TraverseLociBase<M, T>
extends TraversalEngine<M, T, LocusWalker<M, T>, LocusShardDataProvider> {
    protected static final Logger logger = Logger.getLogger(TraversalEngine.class);

    @Override
    protected final String getTraversalType() {
        return "sites";
    }

    protected abstract TraverseResults<T> traverse(LocusWalker<M, T> var1, LocusView var2, LocusReferenceView var3, ReferenceOrderedView var4, T var5);

    @Override
    public T traverse(LocusWalker<M, T> walker, LocusShardDataProvider dataProvider, T sum) {
        RodLocusView rodLocusView;
        long nSkipped;
        logger.debug(String.format("TraverseLociBase.traverse: Shard is %s", dataProvider));
        LocusView locusView = this.getLocusView(walker, dataProvider);
        if (locusView.hasNext()) {
            ReferenceOrderedView referenceOrderedDataView = null;
            referenceOrderedDataView = WalkerManager.getWalkerDataSource(walker) != DataSource.REFERENCE_ORDERED_DATA ? new ManagingReferenceOrderedView(dataProvider) : (RodLocusView)locusView;
            LocusReferenceView referenceView = new LocusReferenceView(walker, dataProvider);
            TraverseResults<T> result = this.traverse(walker, locusView, referenceView, referenceOrderedDataView, sum);
            sum = result.reduceResult;
            dataProvider.getShard().getReadMetrics().incrementNumIterations(result.numIterations);
            this.updateCumulativeMetrics(dataProvider.getShard());
        }
        if (WalkerManager.getWalkerDataSource(walker) == DataSource.REFERENCE_ORDERED_DATA && !walker.isDone() && (nSkipped = (rodLocusView = (RodLocusView)locusView).getLastSkippedBases()) > 0L) {
            GenomeLoc site = rodLocusView.getLocOneBeyondShard();
            AlignmentContext ac = new AlignmentContext(site, (ReadBackedPileup)new ReadBackedPileupImpl(site), nSkipped);
            M x = walker.map(null, null, ac);
            sum = walker.reduce(x, sum);
        }
        return sum;
    }

    private LocusView getLocusView(Walker<M, T> walker, LocusShardDataProvider dataProvider) {
        DataSource dataSource = WalkerManager.getWalkerDataSource(walker);
        if (dataSource == DataSource.READS) {
            return new CoveredLocusView(dataProvider);
        }
        if (dataSource == DataSource.REFERENCE) {
            return new AllLocusView(dataProvider);
        }
        if (dataSource == DataSource.REFERENCE_ORDERED_DATA) {
            return new RodLocusView(dataProvider);
        }
        throw new UnsupportedOperationException("Unsupported traversal type: " + (Object)((Object)dataSource));
    }

    protected static class TraverseResults<T> {
        final int numIterations;
        final T reduceResult;

        public TraverseResults(int numIterations, T reduceResult) {
            this.numIterations = numIterations;
            this.reduceResult = reduceResult;
        }
    }
}

