/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.traversals;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.WalkerManager;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.providers.AllLocusView;
import org.broadinstitute.sting.gatk.datasources.providers.CoveredLocusView;
import org.broadinstitute.sting.gatk.datasources.providers.LocusReferenceView;
import org.broadinstitute.sting.gatk.datasources.providers.LocusShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.LocusView;
import org.broadinstitute.sting.gatk.datasources.providers.ManagingReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.ReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.RodLocusView;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.traversals.TraversalEngine;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionExtension;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionWalker;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.activeregion.ActiveRegion;
import org.broadinstitute.sting.utils.activeregion.ActivityProfile;
import org.broadinstitute.sting.utils.activeregion.ActivityProfileResult;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class TraverseActiveRegions<M, T>
extends TraversalEngine<M, T, ActiveRegionWalker<M, T>, LocusShardDataProvider> {
    protected static final Logger logger = Logger.getLogger(TraversalEngine.class);
    private final LinkedList<ActiveRegion> workQueue = new LinkedList();
    private final LinkedHashSet<GATKSAMRecord> myReads = new LinkedHashSet();

    @Override
    protected String getTraversalType() {
        return "active regions";
    }

    @Override
    public T traverse(ActiveRegionWalker<M, T> walker, LocusShardDataProvider dataProvider, T sum) {
        logger.debug(String.format("TraverseActiveRegion.traverse: Shard is %s", dataProvider));
        LocusView locusView = this.getLocusView(walker, dataProvider);
        GenomeLocSortedSet initialIntervals = this.engine.getIntervals();
        LocusReferenceView referenceView = new LocusReferenceView(walker, dataProvider);
        int activeRegionExtension = walker.getClass().getAnnotation(ActiveRegionExtension.class).extension();
        int maxRegionSize = walker.getClass().getAnnotation(ActiveRegionExtension.class).maxRegion();
        if (locusView.hasNext()) {
            int minStart = Integer.MAX_VALUE;
            ActivityProfile profile = new ActivityProfile(this.engine.getGenomeLocParser(), walker.hasPresetActiveRegions());
            ReferenceOrderedView referenceOrderedDataView = this.getReferenceOrderedView(walker, dataProvider, locusView);
            GenomeLoc prevLoc = null;
            while (locusView.hasNext()) {
                AlignmentContext locus = locusView.next();
                GenomeLoc location = locus.getLocation();
                if (prevLoc != null) {
                    for (int iii = prevLoc.getStop() + 1; iii < location.getStart(); ++iii) {
                        GenomeLoc fakeLoc = this.engine.getGenomeLocParser().createGenomeLoc(prevLoc.getContig(), iii, iii);
                        if (initialIntervals != null && !initialIntervals.overlaps(fakeLoc)) continue;
                        profile.add(fakeLoc, new ActivityProfileResult(walker.hasPresetActiveRegions() && walker.presetActiveRegions.overlaps(fakeLoc) ? 1.0 : 0.0));
                    }
                }
                dataProvider.getShard().getReadMetrics().incrementNumIterations();
                ReferenceContext refContext = referenceView.getReferenceContext(location);
                RefMetaDataTracker tracker = referenceOrderedDataView.getReferenceOrderedDataAtLocus(locus.getLocation(), refContext);
                if (initialIntervals == null || initialIntervals.overlaps(location)) {
                    profile.add(location, this.walkerActiveProb(walker, tracker, refContext, locus, location));
                }
                for (PileupElement p : locus.getBasePileup()) {
                    GATKSAMRecord read = p.getRead();
                    if (!this.myReads.contains(read)) {
                        this.myReads.add(read);
                    }
                    minStart = Math.min(minStart, read.getAlignmentStart());
                }
                prevLoc = location;
                this.updateCumulativeMetrics(dataProvider.getShard());
                this.printProgress(locus.getLocation());
            }
            ActivityProfile bandPassFiltered = profile.bandPassFilter();
            List<ActiveRegion> activeRegions = bandPassFiltered.createActiveRegions(activeRegionExtension, maxRegionSize);
            if (!activeRegions.isEmpty()) {
                if (!this.workQueue.isEmpty()) {
                    ActiveRegion last = this.workQueue.getLast();
                    ActiveRegion first = activeRegions.get(0);
                    if (last.isActive == first.isActive && last.getLocation().contiguousP(first.getLocation()) && last.getLocation().size() + first.getLocation().size() <= maxRegionSize) {
                        this.workQueue.removeLast();
                        activeRegions.remove(first);
                        this.workQueue.add(new ActiveRegion(last.getLocation().union(first.getLocation()), first.isActive, this.engine.getGenomeLocParser(), activeRegionExtension));
                    }
                }
                this.workQueue.addAll(activeRegions);
            }
            logger.debug("Integrated " + profile.size() + " isActive calls into " + activeRegions.size() + " regions.");
            sum = this.processActiveRegions(walker, sum, minStart, dataProvider.getLocus().getContig());
        }
        return sum;
    }

    private final ActivityProfileResult walkerActiveProb(ActiveRegionWalker<M, T> walker, RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext locus, GenomeLoc location) {
        if (walker.hasPresetActiveRegions()) {
            return new ActivityProfileResult(walker.presetActiveRegions.overlaps(location) ? 1.0 : 0.0);
        }
        return walker.isActive(tracker, refContext, locus);
    }

    private ReferenceOrderedView getReferenceOrderedView(ActiveRegionWalker<M, T> walker, LocusShardDataProvider dataProvider, LocusView locusView) {
        if (WalkerManager.getWalkerDataSource(walker) != DataSource.REFERENCE_ORDERED_DATA) {
            return new ManagingReferenceOrderedView(dataProvider);
        }
        return (RodLocusView)locusView;
    }

    private T processActiveRegions(ActiveRegionWalker<M, T> walker, T sum, int minStart, String currentContig) {
        if (walker.activeRegionOutStream != null) {
            this.writeActiveRegionsToStream(walker);
            return sum;
        }
        return this.callWalkerMapOnActiveRegions(walker, sum, minStart, currentContig);
    }

    private void writeActiveRegionsToStream(ActiveRegionWalker<M, T> walker) {
        for (ActiveRegion activeRegion : this.workQueue) {
            if (!activeRegion.isActive) continue;
            walker.activeRegionOutStream.println(activeRegion.getLocation());
        }
    }

    private T callWalkerMapOnActiveRegions(ActiveRegionWalker<M, T> walker, T sum, int minStart, String currentContig) {
        GenomeLoc extendedLoc;
        while (this.workQueue.peek() != null && ((extendedLoc = this.workQueue.peek().getExtendedLoc()).getStop() < minStart || currentContig != null && !this.workQueue.peek().getExtendedLoc().getContig().equals(currentContig))) {
            ActiveRegion activeRegion = this.workQueue.remove();
            sum = this.processActiveRegion(activeRegion, this.myReads, this.workQueue, sum, walker);
        }
        return sum;
    }

    private T processActiveRegion(ActiveRegion activeRegion, LinkedHashSet<GATKSAMRecord> reads, Queue<ActiveRegion> workQueue, T sum, ActiveRegionWalker<M, T> walker) {
        ArrayList<GATKSAMRecord> placedReads = new ArrayList<GATKSAMRecord>();
        for (GATKSAMRecord read : reads) {
            GenomeLoc readLoc = this.engine.getGenomeLocParser().createGenomeLoc(read);
            if (activeRegion.getLocation().overlapsP(readLoc)) {
                long maxOverlap = activeRegion.getLocation().sizeOfOverlap(readLoc);
                ActiveRegion bestRegion = activeRegion;
                for (ActiveRegion otherRegionToTest : workQueue) {
                    if (otherRegionToTest.getLocation().sizeOfOverlap(readLoc) < maxOverlap) continue;
                    maxOverlap = otherRegionToTest.getLocation().sizeOfOverlap(readLoc);
                    bestRegion = otherRegionToTest;
                }
                bestRegion.add(read);
                if (walker.wantsNonPrimaryReads()) {
                    if (!bestRegion.equals(activeRegion)) {
                        activeRegion.add(read);
                    }
                    for (ActiveRegion otherRegionToTest : workQueue) {
                        if (bestRegion.equals(otherRegionToTest) || !otherRegionToTest.getExtendedLoc().overlapsP(readLoc)) continue;
                        otherRegionToTest.add(read);
                    }
                }
                placedReads.add(read);
                continue;
            }
            if (!activeRegion.getExtendedLoc().overlapsP(readLoc) || !walker.wantsNonPrimaryReads()) continue;
            activeRegion.add(read);
        }
        reads.removeAll(placedReads);
        logger.debug(">> Map call with " + activeRegion.getReads().size() + " " + (activeRegion.isActive ? "active" : "inactive") + " reads @ " + activeRegion.getLocation() + " with full extent: " + activeRegion.getReferenceLoc());
        M x = walker.map(activeRegion, null);
        return walker.reduce(x, sum);
    }

    private LocusView getLocusView(Walker<M, T> walker, LocusShardDataProvider dataProvider) {
        DataSource dataSource = WalkerManager.getWalkerDataSource(walker);
        if (dataSource == DataSource.READS) {
            return new CoveredLocusView(dataProvider);
        }
        if (dataSource == DataSource.REFERENCE) {
            return new AllLocusView(dataProvider);
        }
        if (dataSource == DataSource.REFERENCE_ORDERED_DATA) {
            return new RodLocusView(dataProvider);
        }
        throw new UnsupportedOperationException("Unsupported traversal type: " + (Object)((Object)dataSource));
    }

    public T endTraversal(Walker<M, T> walker, T sum) {
        return this.processActiveRegions((ActiveRegionWalker)walker, sum, Integer.MAX_VALUE, null);
    }
}

