/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.phonehome;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.threading.ThreadEfficiencyMonitor;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.Mimetypes;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.HyphenStyle;

public class GATKRunReport {
    private static File REPORT_DIR = new File("/humgen/gsa-hpprojects/GATK/reports");
    private static final String REPORT_BUCKET_NAME = "GATK_Run_Reports";
    private static File REPORT_SUBMIT_DIR = new File(REPORT_DIR.getAbsolutePath() + "/submitted");
    private static File REPORT_SENTINEL = new File(REPORT_DIR.getAbsolutePath() + "/ENABLE");
    private static final long S3PutTimeOut = 10000L;
    public static final String PHONE_HOME_DOCS_URL = "http://gatkforums.broadinstitute.org/discussion/1250/what-is-phone-home-and-how-does-it-affect-me#latest";
    protected static final Logger logger = Logger.getLogger(GATKRunReport.class);
    @Element(required=false, name="id")
    private final String id;
    @Element(required=false, name="exception")
    private final ExceptionToXML mException;
    @Element(required=true, name="start_time")
    private String startTime = "ND";
    @Element(required=true, name="end_time")
    private String endTime;
    @Element(required=true, name="run_time")
    private long runTime = 0L;
    @Element(required=true, name="walker_name")
    private String walkerName;
    @Element(required=true, name="svn_version")
    private String svnVersion;
    @Element(required=true, name="total_memory")
    private long totalMemory;
    @Element(required=true, name="max_memory")
    private long maxMemory;
    @Element(required=true, name="user_name")
    private String userName;
    @Element(required=true, name="host_name")
    private String hostName;
    @Element(required=true, name="java")
    private String java;
    @Element(required=true, name="machine")
    private String machine;
    @Element(required=true, name="iterations")
    private long nIterations;
    @Element(required=true, name="tag")
    private String tag;
    @Element(required=true, name="numThreads")
    private int numThreads;
    @Element(required=true, name="percent_time_running")
    private String percentTimeRunning;
    @Element(required=true, name="percent_time_waiting")
    private String percentTimeWaiting;
    @Element(required=true, name="percent_time_blocking")
    private String percentTimeBlocking;
    @Element(required=true, name="percent_time_waiting_for_io")
    private String percentTimeWaitingForIO;
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH.mm.ss");

    public GATKRunReport(Walker<?, ?> walker, Exception e, GenomeAnalysisEngine engine, PhoneHomeOption type) {
        if (type == PhoneHomeOption.NO_ET) {
            throw new ReviewedStingException("Trying to create a run report when type is NO_ET!");
        }
        logger.debug("Aggregating data for run report");
        this.id = RandomStringUtils.randomAlphanumeric(32);
        this.walkerName = engine.getWalkerName(walker.getClass());
        this.svnVersion = CommandLineGATK.getVersionNumber();
        Date end = new Date();
        this.endTime = dateFormat.format(end);
        if (engine.getStartTime() != null) {
            this.startTime = dateFormat.format(engine.getStartTime());
            this.runTime = (end.getTime() - engine.getStartTime().getTime()) / 1000L;
        }
        Runtime.getRuntime().gc();
        this.maxMemory = Runtime.getRuntime().maxMemory();
        this.totalMemory = Runtime.getRuntime().totalMemory();
        if (engine.getCumulativeMetrics() != null) {
            this.nIterations = engine.getCumulativeMetrics().getNumIterations();
        }
        this.tag = engine.getArguments().tag;
        this.userName = System.getProperty("user.name");
        this.hostName = Utils.resolveHostname();
        this.java = Utils.join("-", Arrays.asList(System.getProperty("java.vendor"), System.getProperty("java.version")));
        this.machine = Utils.join("-", Arrays.asList(System.getProperty("os.name"), System.getProperty("os.arch")));
        this.mException = e == null ? null : new ExceptionToXML(e);
        this.numThreads = engine.getTotalNumberOfThreads();
        this.percentTimeRunning = this.getThreadEfficiencyPercent(engine, ThreadEfficiencyMonitor.State.USER_CPU);
        this.percentTimeBlocking = this.getThreadEfficiencyPercent(engine, ThreadEfficiencyMonitor.State.BLOCKING);
        this.percentTimeWaiting = this.getThreadEfficiencyPercent(engine, ThreadEfficiencyMonitor.State.WAITING);
        this.percentTimeWaitingForIO = this.getThreadEfficiencyPercent(engine, ThreadEfficiencyMonitor.State.WAITING_FOR_IO);
    }

    public String getID() {
        return this.id;
    }

    private String getThreadEfficiencyPercent(GenomeAnalysisEngine engine, ThreadEfficiencyMonitor.State state) {
        ThreadEfficiencyMonitor tem = engine.getThreadEfficiencyMonitor();
        return tem == null ? "NA" : String.format("%.2f", tem.getStatePercent(state));
    }

    public void postReport(PhoneHomeOption type) {
        logger.debug("Posting report of type " + (Object)((Object)type));
        switch (type) {
            case NO_ET: {
                break;
            }
            case STANDARD: {
                if (this.repositoryIsOnline()) {
                    this.postReportToLocalDisk(REPORT_SUBMIT_DIR);
                    break;
                }
                this.postReportToAWSS3();
                break;
            }
            case STDOUT: {
                this.postReportToStream(System.out);
                break;
            }
            default: {
                this.exceptDuringRunReport("BUG: unexpected PhoneHomeOption ");
            }
        }
    }

    private void postReportToStream(OutputStream stream) {
        Persister serializer = new Persister(new Format(new HyphenStyle()));
        try {
            serializer.write((Object)this, stream);
        }
        catch (Exception e) {
            throw new ReviewedStingException("Failed to marshal the data to the file " + stream, e);
        }
    }

    private final String getKey() {
        return this.getID() + ".report.xml.gz";
    }

    private File postReportToLocalDisk(File rootDir) {
        String filename = this.getKey();
        File destination = new File(rootDir, filename);
        try {
            BufferedOutputStream out = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(destination)));
            this.postReportToStream(out);
            out.close();
            logger.debug("Wrote report to " + destination);
            return destination;
        }
        catch (Exception e) {
            this.exceptDuringRunReport("Couldn't read report file", e);
            destination.delete();
            return null;
        }
    }

    private void postReportToAWSS3() {
        this.hostName = Utils.resolveHostname();
        String key = this.getKey();
        logger.debug("Generating GATK report to AWS S3 with key " + key);
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(8096);
            GZIPOutputStream outputStream = new GZIPOutputStream(byteStream);
            this.postReportToStream(outputStream);
            ((OutputStream)outputStream).close();
            byte[] report = byteStream.toByteArray();
            Logger mimeTypeLogger = Logger.getLogger(Mimetypes.class);
            mimeTypeLogger.setLevel(Level.FATAL);
            S3PutRunnable s3run = new S3PutRunnable(key, report);
            Thread s3thread = new Thread(s3run);
            s3thread.setDaemon(true);
            s3thread.setName("S3Put-Thread");
            s3thread.start();
            s3thread.join(10000L);
            if (s3thread.isAlive()) {
                s3thread.interrupt();
                this.exceptDuringRunReport("Run statistics report upload to AWS S3 timed-out");
            } else if (s3run.isSuccess.get()) {
                logger.info("Uploaded run statistics report to AWS S3");
                logger.debug("Uploaded to AWS: " + s3run.s3Object);
            } else if (s3run.errorMsg != null && s3run.errorThrow != null) {
                this.exceptDuringRunReport(s3run.errorMsg, s3run.errorThrow);
            } else {
                this.exceptDuringRunReport("Run statistics report upload to AWS S3 failed");
            }
        }
        catch (IOException e) {
            this.exceptDuringRunReport("Couldn't read report file", e);
        }
        catch (InterruptedException e) {
            this.exceptDuringRunReport("Run statistics report upload interrupted", e);
        }
    }

    private void exceptDuringRunReport(String msg, Throwable e) {
        logger.debug("A problem occurred during GATK run reporting [*** everything is fine, but no report could be generated; please do not post this to the support forum ***].  Message is: " + msg + ".  Error message is: " + e.getMessage());
    }

    private void exceptDuringRunReport(String msg) {
        logger.debug("A problem occurred during GATK run reporting [*** everything is fine, but no report could be generated; please do not post this to the support forum ***].  Message is " + msg);
    }

    private boolean repositoryIsOnline() {
        return REPORT_SENTINEL.exists();
    }

    private class ExceptionToXML {
        @Element(required=false, name="message")
        String message = null;
        @ElementList(required=false, name="stacktrace")
        final List<String> stackTrace = new ArrayList<String>();
        @Element(required=false, name="cause")
        ExceptionToXML cause = null;
        @Element(required=false, name="is-user-exception")
        Boolean isUserException;
        @Element(required=false, name="exception-class")
        Class exceptionClass;

        public ExceptionToXML(Throwable e) {
            this.message = e.getMessage();
            this.exceptionClass = e.getClass();
            this.isUserException = e instanceof UserException;
            for (StackTraceElement element : e.getStackTrace()) {
                this.stackTrace.add(element.toString());
            }
            if (e.getCause() != null) {
                this.cause = new ExceptionToXML(e.getCause());
            }
        }
    }

    private class S3PutRunnable
    implements Runnable {
        public AtomicBoolean isSuccess = new AtomicBoolean();
        private final String key;
        private final byte[] report;
        public S3Object s3Object;
        public String errorMsg;
        public Throwable errorThrow;

        public S3PutRunnable(String key, byte[] report) {
            this.key = key;
            this.report = report;
        }

        @Override
        public void run() {
            try {
                String awsAccessKey = "AKIAJXU7VIHBPDW4TDSQ";
                String awsSecretKey = "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";
                AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
                RestS3Service s3Service = new RestS3Service(awsCredentials);
                S3Object fileObject = new S3Object(this.key, this.report);
                this.s3Object = s3Service.putObject(GATKRunReport.REPORT_BUCKET_NAME, fileObject);
                this.isSuccess.set(true);
            }
            catch (S3ServiceException e) {
                this.setException("S3 exception occurred", e);
            }
            catch (NoSuchAlgorithmException e) {
                this.setException("Couldn't calculate MD5", e);
            }
            catch (IOException e) {
                this.setException("Couldn't read report file", e);
            }
        }

        private void setException(String msg, Throwable e) {
            this.errorMsg = msg;
            this.errorThrow = e;
        }
    }

    public static enum PhoneHomeOption {
        NO_ET,
        STANDARD,
        STDOUT;

    }
}

