/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io.storage;

import java.io.File;
import java.io.OutputStream;
import org.broadinstitute.sting.gatk.io.storage.OutputStreamStorage;
import org.broadinstitute.sting.gatk.io.storage.SAMFileWriterStorage;
import org.broadinstitute.sting.gatk.io.storage.Storage;
import org.broadinstitute.sting.gatk.io.storage.VariantContextWriterStorage;
import org.broadinstitute.sting.gatk.io.stubs.OutputStreamStub;
import org.broadinstitute.sting.gatk.io.stubs.SAMFileWriterStub;
import org.broadinstitute.sting.gatk.io.stubs.Stub;
import org.broadinstitute.sting.gatk.io.stubs.VariantContextWriterStub;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class StorageFactory {
    private StorageFactory() {
    }

    public static <T> Storage<T> createStorage(Stub<T> stub) {
        return StorageFactory.createStorage(stub, null);
    }

    public static <T> Storage<T> createStorage(Stub<T> stub, File file) {
        Storage<OutputStream> storage;
        if (stub instanceof OutputStreamStub) {
            storage = file != null ? new OutputStreamStorage((OutputStreamStub)stub, file) : new OutputStreamStorage((OutputStreamStub)stub);
        } else if (stub instanceof SAMFileWriterStub) {
            storage = file != null ? new SAMFileWriterStorage((SAMFileWriterStub)stub, file) : new SAMFileWriterStorage((SAMFileWriterStub)stub);
        } else if (stub instanceof VariantContextWriterStub) {
            VariantContextWriterStub vcfWriterStub = (VariantContextWriterStub)stub;
            storage = file != null ? new VariantContextWriterStorage(vcfWriterStub, file) : new VariantContextWriterStorage(vcfWriterStub);
        } else {
            throw new ReviewedStingException("Unsupported stub type: " + stub.getClass().getName());
        }
        return storage;
    }
}

