/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.filters;

import java.util.Arrays;
import java.util.HashSet;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.samtools.SAMRecord;

public class ContaminatedSampleFilter
implements SamRecordFilter {
    private final String[] filteredNames = new String[]{"NA19562", "NA19006", "NA19554", "NA18985", "NA18988", "NA19062", "NA19559"};
    private HashSet<String> contaminatedSamples = new HashSet<String>(Arrays.asList(this.filteredNames));

    @Override
    public boolean filterOut(SAMRecord read) {
        return this.contaminatedSamples.contains(read.getReadGroup().getSample());
    }

    @Override
    public boolean filterOut(SAMRecord first, SAMRecord second) {
        throw new UnsupportedOperationException("Paired filter not implemented: " + this.getClass());
    }
}

