/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.executive;

import java.util.Collection;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.datasources.providers.LocusShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.ReadShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.ShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.gatk.executive.Accumulator;
import org.broadinstitute.sting.gatk.executive.MicroScheduler;
import org.broadinstitute.sting.gatk.executive.WindowMaker;
import org.broadinstitute.sting.gatk.io.DirectOutputTracker;
import org.broadinstitute.sting.gatk.io.OutputTracker;
import org.broadinstitute.sting.gatk.resourcemanagement.ThreadAllocation;
import org.broadinstitute.sting.gatk.traversals.TraverseActiveRegions;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.threading.ThreadEfficiencyMonitor;

public class LinearMicroScheduler
extends MicroScheduler {
    private DirectOutputTracker outputTracker = new DirectOutputTracker();

    protected LinearMicroScheduler(GenomeAnalysisEngine engine, Walker walker, SAMDataSource reads, IndexedFastaSequenceFile reference, Collection<ReferenceOrderedDataSource> rods, ThreadAllocation threadAllocation) {
        super(engine, walker, reads, reference, rods, threadAllocation);
        if (threadAllocation.monitorThreadEfficiency()) {
            this.setThreadEfficiencyMonitor(new ThreadEfficiencyMonitor());
        }
    }

    @Override
    public Object execute(Walker walker, Iterable<Shard> shardStrategy) {
        Object result;
        walker.initialize();
        Accumulator accumulator = Accumulator.create(this.engine, walker);
        boolean done = walker.isDone();
        boolean counter = false;
        this.traversalEngine.startTimersIfNecessary();
        for (Shard shard : shardStrategy) {
            if (done || shard == null) break;
            if (shard.getShardType() == Shard.ShardType.LOCUS) {
                WindowMaker windowMaker = new WindowMaker(shard, this.engine.getGenomeLocParser(), this.getReadIterator(shard), shard.getGenomeLocs(), SampleUtils.getSAMFileSamples(this.engine));
                for (WindowMaker.WindowMakerIterator iterator : windowMaker) {
                    LocusShardDataProvider dataProvider = new LocusShardDataProvider(shard, iterator.getSourceInfo(), this.engine.getGenomeLocParser(), iterator.getLocus(), iterator, this.reference, this.rods);
                    Object result2 = this.traversalEngine.traverse(walker, dataProvider, accumulator.getReduceInit());
                    accumulator.accumulate(dataProvider, result2);
                    ((ShardDataProvider)dataProvider).close();
                    if (!walker.isDone()) continue;
                    break;
                }
                windowMaker.close();
            } else {
                ReadShardDataProvider dataProvider = new ReadShardDataProvider(shard, this.engine.getGenomeLocParser(), this.getReadIterator(shard), this.reference, this.rods);
                Object result3 = this.traversalEngine.traverse(walker, dataProvider, accumulator.getReduceInit());
                accumulator.accumulate(dataProvider, result3);
                ((ShardDataProvider)dataProvider).close();
            }
            done = walker.isDone();
        }
        if (this.traversalEngine instanceof TraverseActiveRegions) {
            result = ((TraverseActiveRegions)this.traversalEngine).endTraversal(walker, accumulator.getReduceInit());
            accumulator.accumulate(null, result);
        }
        result = accumulator.finishTraversal();
        this.printOnTraversalDone(result);
        this.outputTracker.close();
        this.cleanup();
        this.executionIsDone();
        return accumulator;
    }

    @Override
    public OutputTracker getOutputTracker() {
        return this.outputTracker;
    }
}

