/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.arguments;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.samtools.SAMFileReader;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.IntervalBinding;
import org.broadinstitute.sting.gatk.DownsampleType;
import org.broadinstitute.sting.gatk.DownsamplingMethod;
import org.broadinstitute.sting.gatk.arguments.ValidationExclusion;
import org.broadinstitute.sting.gatk.phonehome.GATKRunReport;
import org.broadinstitute.sting.gatk.samples.PedigreeValidationType;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.interval.IntervalMergingRule;
import org.broadinstitute.sting.utils.interval.IntervalSetRule;

public class GATKArgumentCollection {
    private float versionNumber = 1.0f;
    private String description = "GATK Arguments";
    @Input(fullName="input_file", shortName="I", doc="SAM or BAM file(s)", required=false)
    public List<String> samFiles = new ArrayList<String>();
    @Argument(fullName="read_buffer_size", shortName="rbs", doc="Number of reads per SAM file to buffer in memory", required=false)
    public Integer readBufferSize = null;
    @Argument(fullName="phone_home", shortName="et", doc="What kind of GATK run report should we generate? STANDARD is the default, can be NO_ET so nothing is posted to the run repository. Please see http://gatkforums.broadinstitute.org/discussion/1250/what-is-phone-home-and-how-does-it-affect-me#latest for details.", required=false)
    public GATKRunReport.PhoneHomeOption phoneHomeType = GATKRunReport.PhoneHomeOption.STANDARD;
    @Argument(fullName="gatk_key", shortName="K", doc="GATK Key file. Required if running with -et NO_ET. Please see http://gatkforums.broadinstitute.org/discussion/1250/what-is-phone-home-and-how-does-it-affect-me#latest for details.", required=false)
    public File gatkKeyFile = null;
    @Argument(fullName="tag", shortName="tag", doc="Arbitrary tag string to identify this GATK run as part of a group of runs, for later analysis", required=false)
    public String tag = "NA";
    @Argument(fullName="read_filter", shortName="rf", doc="Specify filtration criteria to apply to each read individually", required=false)
    public List<String> readFilters = new ArrayList<String>();
    @Input(fullName="intervals", shortName="L", doc="One or more genomic intervals over which to operate. Can be explicitly specified on the command line or in a file (including a rod file)", required=false)
    public List<IntervalBinding<Feature>> intervals = null;
    @Input(fullName="excludeIntervals", shortName="XL", doc="One or more genomic intervals to exclude from processing. Can be explicitly specified on the command line or in a file (including a rod file)", required=false)
    public List<IntervalBinding<Feature>> excludeIntervals = null;
    @Argument(fullName="interval_set_rule", shortName="isr", doc="Indicates the set merging approach the interval parser should use to combine the various -L or -XL inputs", required=false)
    public IntervalSetRule intervalSetRule = IntervalSetRule.UNION;
    @Argument(fullName="interval_merging", shortName="im", doc="Indicates the interval merging rule we should use for abutting intervals", required=false)
    public IntervalMergingRule intervalMerging = IntervalMergingRule.ALL;
    @Argument(fullName="interval_padding", shortName="ip", doc="Indicates how many basepairs of padding to include around each of the intervals specified with the -L/--intervals argument", required=false)
    public int intervalPadding = 0;
    @Input(fullName="reference_sequence", shortName="R", doc="Reference sequence file", required=false)
    public File referenceFile = null;
    @Argument(fullName="nonDeterministicRandomSeed", shortName="ndrs", doc="Makes the GATK behave non deterministically, that is, the random numbers generated will be different in every run", required=false)
    public boolean nonDeterministicRandomSeed = false;
    private static DownsampleType DEFAULT_DOWNSAMPLING_TYPE = DownsampleType.BY_SAMPLE;
    private static int DEFAULT_DOWNSAMPLING_COVERAGE = 1000;
    @Argument(fullName="downsampling_type", shortName="dt", doc="Type of reads downsampling to employ at a given locus.  Reads will be selected randomly to be removed from the pile based on the method described here", required=false)
    public DownsampleType downsamplingType = null;
    @Argument(fullName="downsample_to_fraction", shortName="dfrac", doc="Fraction [0.0-1.0] of reads to downsample to", required=false)
    public Double downsampleFraction = null;
    @Argument(fullName="downsample_to_coverage", shortName="dcov", doc="Coverage [integer] to downsample to at any given locus; note that downsampled reads are randomly selected from all possible reads at a locus", required=false)
    public Integer downsampleCoverage = null;
    @Argument(fullName="baq", shortName="baq", doc="Type of BAQ calculation to apply in the engine", required=false)
    public BAQ.CalculationMode BAQMode = BAQ.CalculationMode.OFF;
    @Argument(fullName="baqGapOpenPenalty", shortName="baqGOP", doc="BAQ gap open penalty (Phred Scaled).  Default value is 40.  30 is perhaps better for whole genome call sets", required=false)
    public double BAQGOP = 40.0;
    @Argument(fullName="performanceLog", shortName="PF", doc="If provided, a GATK runtime performance log will be written to this file", required=false)
    public File performanceLog = null;
    @Argument(fullName="useOriginalQualities", shortName="OQ", doc="If set, use the original base quality scores from the OQ tag when present instead of the standard scores", required=false)
    public Boolean useOriginalBaseQualities = false;
    @Input(fullName="BQSR", shortName="BQSR", required=false, doc="The input covariates table file which enables on-the-fly base quality score recalibration")
    public File BQSR_RECAL_FILE = null;
    @Hidden
    @Argument(fullName="quantize_quals", shortName="qq", doc="Quantize quality scores to a given number of levels (with -BQSR)", required=false)
    public int quantizationLevels = 0;
    @Argument(fullName="disable_indel_quals", shortName="DIQ", doc="If true, disables printing of base insertion and base deletion tags (with -BQSR)", required=false)
    public boolean disableIndelQuals = false;
    @Argument(fullName="emit_original_quals", shortName="EOQ", doc="If true, enables printing of the OQ tag with the original base qualities (with -BQSR)", required=false)
    public boolean emitOriginalQuals = false;
    @Argument(fullName="preserve_qscores_less_than", shortName="preserveQ", doc="Bases with quality scores less than this threshold won't be recalibrated (with -BQSR)", required=false)
    public int PRESERVE_QSCORES_LESS_THAN = 6;
    @Argument(fullName="defaultBaseQualities", shortName="DBQ", doc="If reads are missing some or all base quality scores, this value will be used for all base quality scores", required=false)
    public byte defaultBaseQualities = (byte)-1;
    @Argument(fullName="validation_strictness", shortName="S", doc="How strict should we be with validation", required=false)
    public SAMFileReader.ValidationStringency strictnessLevel = SAMFileReader.ValidationStringency.SILENT;
    @Argument(fullName="remove_program_records", shortName="rpr", doc="Should we override the Walker's default and remove program records from the SAM header", required=false)
    public boolean removeProgramRecords = false;
    @Argument(fullName="keep_program_records", shortName="kpr", doc="Should we override the Walker's default and keep program records from the SAM header", required=false)
    public boolean keepProgramRecords = false;
    @Argument(fullName="unsafe", shortName="U", doc="If set, enables unsafe operations: nothing will be checked at runtime.  For expert users only who know what they are doing.  We do not support usage of this argument.", required=false)
    public ValidationExclusion.TYPE unsafe;
    @Argument(fullName="num_threads", shortName="nt", doc="How many data threads should be allocated to running this analysis.", required=false)
    public Integer numberOfDataThreads = 1;
    @Argument(fullName="num_cpu_threads_per_data_thread", shortName="nct", doc="How many CPU threads should be allocated per data thread to running this analysis?", required=false)
    public int numberOfCPUThreadsPerDataThread = 1;
    @Argument(fullName="num_io_threads", shortName="nit", doc="How many of the given threads should be allocated to IO", required=false)
    @Hidden
    public int numberOfIOThreads = 0;
    @Argument(fullName="disableThreadEfficiencyMonitor", shortName="dtem", doc="Disable GATK efficiency monitoring", required=false)
    public Boolean disableEfficiencyMonitor = false;
    @Argument(fullName="num_bam_file_handles", shortName="bfh", doc="The total number of BAM file handles to keep open simultaneously", required=false)
    public Integer numberOfBAMFileHandles = null;
    @Input(fullName="read_group_black_list", shortName="rgbl", doc="Filters out read groups matching <TAG>:<STRING> or a .txt file containing the filter strings one per line.", required=false)
    public List<String> readGroupBlackList = null;
    @Argument(fullName="pedigree", shortName="ped", doc="Pedigree files for samples", required=false)
    public List<File> pedigreeFiles = Collections.emptyList();
    @Argument(fullName="pedigreeString", shortName="pedString", doc="Pedigree string for samples", required=false)
    public List<String> pedigreeStrings = Collections.emptyList();
    @Argument(fullName="pedigreeValidationType", shortName="pedValidationType", doc="How strict should we be in validating the pedigree information?", required=false)
    public PedigreeValidationType pedigreeValidationType = PedigreeValidationType.STRICT;
    @Argument(fullName="allow_intervals_with_unindexed_bam", doc="Allow interval processing with an unsupported BAM.  NO INTEGRATION TESTS are available.  Use at your own risk.", required=false)
    @Hidden
    public boolean allowIntervalsWithUnindexedBAM = false;
    @Argument(fullName="generateShadowBCF", shortName="generateShadowBCF", doc="If provided, whenever we create a VCFWriter we will also write out a BCF file alongside it, for testing purposes", required=false)
    @Hidden
    public boolean generateShadowBCF = false;

    public DownsamplingMethod getDownsamplingMethod() {
        if (this.downsamplingType == null && this.downsampleFraction == null && this.downsampleCoverage == null) {
            return null;
        }
        if (this.downsamplingType == null && this.downsampleCoverage != null) {
            return new DownsamplingMethod(DEFAULT_DOWNSAMPLING_TYPE, this.downsampleCoverage, null);
        }
        return new DownsamplingMethod(this.downsamplingType, this.downsampleCoverage, this.downsampleFraction);
    }

    public void setDownsamplingMethod(DownsamplingMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        this.downsamplingType = method.type;
        this.downsampleCoverage = method.toCoverage;
        this.downsampleFraction = method.toFraction;
    }

    public static DownsamplingMethod getDefaultDownsamplingMethod() {
        return new DownsamplingMethod(DEFAULT_DOWNSAMPLING_TYPE, DEFAULT_DOWNSAMPLING_COVERAGE, null);
    }
}

