/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk;

import java.util.Collection;
import java.util.List;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import org.broadinstitute.sting.gatk.DownsamplingMethod;
import org.broadinstitute.sting.gatk.arguments.ValidationExclusion;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.gatk.filters.ReadFilter;
import org.broadinstitute.sting.gatk.iterators.ReadTransformer;

public class ReadProperties {
    private final Collection<SAMReaderID> readers;
    private final SAMFileHeader header;
    private final SAMFileReader.ValidationStringency validationStringency;
    private final DownsamplingMethod downsamplingMethod;
    private final ValidationExclusion exclusionList;
    private final Collection<ReadFilter> supplementalFilters;
    private final List<ReadTransformer> readTransformers;
    private final boolean includeReadsWithDeletionAtLoci;
    private final boolean useOriginalBaseQualities;
    private final byte defaultBaseQualities;

    public boolean includeReadsWithDeletionAtLoci() {
        return this.includeReadsWithDeletionAtLoci;
    }

    public Collection<SAMReaderID> getSAMReaderIDs() {
        return this.readers;
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }

    public SAMFileReader.ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    public DownsamplingMethod getDownsamplingMethod() {
        return this.downsamplingMethod;
    }

    public ValidationExclusion getValidationExclusionList() {
        return this.exclusionList;
    }

    public Collection<ReadFilter> getSupplementalFilters() {
        return this.supplementalFilters;
    }

    public List<ReadTransformer> getReadTransformers() {
        return this.readTransformers;
    }

    public boolean useOriginalBaseQualities() {
        return this.useOriginalBaseQualities;
    }

    public byte defaultBaseQualities() {
        return this.defaultBaseQualities;
    }

    public ReadProperties(Collection<SAMReaderID> samFiles, SAMFileHeader header, boolean useOriginalBaseQualities, SAMFileReader.ValidationStringency strictness, DownsamplingMethod downsamplingMethod, ValidationExclusion exclusionList, Collection<ReadFilter> supplementalFilters, List<ReadTransformer> readTransformers, boolean includeReadsWithDeletionAtLoci, byte defaultBaseQualities) {
        this.readers = samFiles;
        this.header = header;
        this.validationStringency = strictness;
        this.downsamplingMethod = downsamplingMethod == null ? DownsamplingMethod.NONE : downsamplingMethod;
        this.exclusionList = exclusionList == null ? new ValidationExclusion() : exclusionList;
        this.supplementalFilters = supplementalFilters;
        this.readTransformers = readTransformers;
        this.includeReadsWithDeletionAtLoci = includeReadsWithDeletionAtLoci;
        this.useOriginalBaseQualities = useOriginalBaseQualities;
        this.defaultBaseQualities = defaultBaseQualities;
    }
}

