/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect;

import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.BinomialDistributionImpl;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.AbstractPowerCalculator;

public class TumorPowerCalculator
extends AbstractPowerCalculator {
    private static double Q30_EPS = Math.pow(10.0, -3.0) / 3.0;
    private static double LOD = 6.3;
    private double constantContamination;

    public static void main(String[] argv) throws MathException {
        double wiggle = 1.0E-5;
        TumorPowerCalculator.test(TumorPowerCalculator.calculateLogLikelihood(50, 5, 0.001, 0.1), -7.059164, wiggle, "Failed!");
        TumorPowerCalculator.test(TumorPowerCalculator.calculateLogLikelihood(40, 5, 0.001, 0.1), -6.597727, wiggle, "Failed!");
        TumorPowerCalculator.test(TumorPowerCalculator.calculateLogLikelihood(40, 10, 0.001, 0.1), -11.34971, wiggle, "Failed!");
        TumorPowerCalculator.test(TumorPowerCalculator.calculateLogLikelihood(40, 10, 0.01, 0.1), -11.15482, wiggle, "Failed!");
        TumorPowerCalculator.test(TumorPowerCalculator.calculateLogLikelihood(40, 10, 0.01, 0.2), -9.866713, wiggle, "Failed!");
        TumorPowerCalculator.test(TumorPowerCalculator.testCalculatePower(50, Q30_EPS, LOD, 0.15, 0.0), 0.975342, wiggle, "Failed!");
        TumorPowerCalculator.test(TumorPowerCalculator.testCalculatePower(20, Q30_EPS, LOD, 0.15, 0.0), 0.6364833, wiggle, "Failed!");
        TumorPowerCalculator.test(TumorPowerCalculator.testCalculatePower(10, Q30_EPS, LOD, 0.15, 0.0), 0.3167154, wiggle, "Failed!");
        TumorPowerCalculator.test(TumorPowerCalculator.testCalculatePower(50, Q30_EPS, LOD, 0.35, 0.0), 0.9999994, wiggle, "Failed!");
        TumorPowerCalculator.test(TumorPowerCalculator.testCalculatePower(50, Q30_EPS, LOD, 0.05, 0.0), 0.3893047, wiggle, "Failed!");
        TumorPowerCalculator.test(TumorPowerCalculator.testCalculatePower(50, Q30_EPS, 4.3, 0.05, 0.0), 0.6068266, wiggle, "Failed!");
        TumorPowerCalculator.test(TumorPowerCalculator.testCalculatePower(50, Q30_EPS, 4.3, 0.05, 0.02), 0.0039135, wiggle, "Failed!");
        TumorPowerCalculator pc = new TumorPowerCalculator(Q30_EPS, LOD, 0.0);
        TumorPowerCalculator.test(pc.cachingPowerCalculation(50, 0.15), 0.975342, wiggle, "Failed!");
        TumorPowerCalculator.test(pc.cachingPowerCalculation(50, 0.15), 0.975342, wiggle, "Failed!");
        TumorPowerCalculator.test(pc.cachingPowerCalculation(50, 0.15), 0.975342, wiggle, "Failed!");
    }

    private static double testCalculatePower(int n, double eps, double fdr, double delta, double contam) throws MathException {
        double power = TumorPowerCalculator.calculatePower(n, eps, fdr, delta, contam);
        System.out.println("Depth: " + n + " EPS: " + eps + " FDR: " + fdr + " Delta: " + delta + " --> Power: " + power);
        return power;
    }

    public TumorPowerCalculator(double constantEps, double constantLodThreshold, double constantContamination) {
        this.constantEps = constantEps;
        this.constantLodThreshold = constantLodThreshold;
        this.constantContamination = constantContamination;
    }

    public double cachingPowerCalculation(int n, double delta) throws MathException {
        AbstractPowerCalculator.PowerCacheKey key = new AbstractPowerCalculator.PowerCacheKey(n, delta);
        Double power = (Double)this.cache.get(key);
        if (power == null) {
            power = TumorPowerCalculator.calculatePower(n, this.constantEps, this.constantLodThreshold, delta, this.constantContamination);
            this.cache.put(key, power);
        }
        return power;
    }

    private static double calculateTumorLod(int depth, int alts, double eps, double contam) {
        double f = (double)alts / (double)depth;
        return TumorPowerCalculator.calculateLogLikelihood(depth, alts, eps, f) - TumorPowerCalculator.calculateLogLikelihood(depth, alts, eps, Math.min(f, contam));
    }

    private static double calculatePower(int depth, double eps, double lodThreshold, double delta, double contam) throws MathException {
        if (depth == 0) {
            return 0.0;
        }
        int n = depth;
        double p_alt_given_e_delta = delta * (1.0 - eps) + (1.0 - delta) * eps;
        BinomialDistributionImpl binom = new BinomialDistributionImpl(n, p_alt_given_e_delta);
        double[] p = new double[depth + 1];
        for (int i = 0; i < p.length; ++i) {
            p[i] = binom.probability(i);
        }
        double[] lod = new double[depth + 1];
        for (int i = 0; i < lod.length; ++i) {
            lod[i] = TumorPowerCalculator.calculateTumorLod(n, i, eps, contam);
        }
        int k = -1;
        for (int i = 0; i < lod.length; ++i) {
            if (!(lod[i] >= lodThreshold)) continue;
            k = i;
            break;
        }
        if (k == -1) {
            return 0.0;
        }
        double power = 0.0;
        if (k > 0) {
            double x = 1.0 - (lodThreshold - lod[k - 1]) / (lod[k] - lod[k - 1]);
            power = x * p[k - 1];
        }
        for (int i = k; i < p.length; ++i) {
            power += p[i];
        }
        return power;
    }
}

