/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect;

public class FisherExact {
    private static final boolean DEBUG = false;
    private double[] f;
    int maxSize;

    public FisherExact(int maxSize) {
        this.maxSize = maxSize;
        this.f = new double[maxSize + 1];
        this.f[0] = 0.0;
        for (int i = 1; i <= this.maxSize; ++i) {
            this.f[i] = this.f[i - 1] + Math.log(i);
        }
    }

    public final double getP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = this.f[a + b] + this.f[c + d] + this.f[a + c] + this.f[b + d] - (this.f[a] + this.f[b] + this.f[c] + this.f[d] + this.f[n]);
        return Math.exp(p);
    }

    public final double getRightTailedP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        int min = c < b ? c : b;
        for (int i = 0; i < min; ++i) {
            p += this.getP(++a, --b, --c, ++d);
        }
        return p;
    }

    public final double getCumlativeP(int a, int b, int c, int d) {
        int i;
        int min;
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        if (a * d >= b * c) {
            min = c < b ? c : b;
            for (i = 0; i < min; ++i) {
                p += this.getP(++a, --b, --c, ++d);
            }
            System.out.println("");
        }
        if (a * d < b * c) {
            min = a < d ? a : d;
            for (i = 0; i < min; ++i) {
                double pTemp = this.getP(--a, ++b, ++c, --d);
                p += pTemp;
            }
        }
        return p;
    }

    public final double getLeftTailedP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        int min = a < d ? a : d;
        for (int i = 0; i < min; ++i) {
            double pTemp = this.getP(--a, ++b, ++c, --d);
            p += pTemp;
        }
        return p;
    }

    public final double getTwoTailedP(int a, int b, int c, int d) {
        int i;
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        double baseP = this.getP(a, b, c, d);
        int initialA = a;
        int initialB = b;
        int initialC = c;
        int initialD = d;
        p += baseP;
        int min = c < b ? c : b;
        for (i = 0; i < min; ++i) {
            double tempP;
            if (!((tempP = this.getP(++a, --b, --c, ++d)) <= baseP)) continue;
            p += tempP;
        }
        a = initialA;
        b = initialB;
        c = initialC;
        d = initialD;
        min = a < d ? a : d;
        for (i = 0; i < min; ++i) {
            double pTemp;
            if (!((pTemp = this.getP(--a, ++b, ++c, --d)) <= baseP)) continue;
            p += pTemp;
        }
        return p;
    }
}

