/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect;

import java.util.HashMap;

public class AbstractPowerCalculator {
    protected HashMap<PowerCacheKey, Double> cache = new HashMap();
    protected double constantEps;
    protected double constantLodThreshold;

    protected static double calculateLogLikelihood(int depth, int alts, double eps, double f) {
        double a = (double)(depth - alts) * Math.log10(f * eps + (1.0 - f) * (1.0 - eps));
        double b = (double)alts * Math.log10(f * (1.0 - eps) + (1.0 - f) * eps);
        return a + b;
    }

    protected static void test(double actual, double expected, double tolerance, String msg) {
        if (Math.abs(actual - expected) > tolerance) {
            throw new RuntimeException("FAILED: calculated " + actual + " but expected " + expected + " -> " + msg);
        }
    }

    protected static class PowerCacheKey {
        private int n;
        private double delta;

        public PowerCacheKey(int n, double delta) {
            this.n = n;
            this.delta = delta;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PowerCacheKey that = (PowerCacheKey)o;
            if (Double.compare(that.delta, this.delta) != 0) {
                return false;
            }
            return this.n == that.n;
        }

        public int hashCode() {
            int result = this.n;
            long temp = this.delta != 0.0 ? Double.doubleToLongBits(this.delta) : 0L;
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

