/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration;

import org.broadinstitute.sting.utils.collections.NestedIntegerArray;
import org.broadinstitute.sting.utils.recalibration.EventType;
import org.broadinstitute.sting.utils.recalibration.RecalDatum;
import org.broadinstitute.sting.utils.recalibration.covariates.Covariate;

public class RecalibrationTables {
    private final NestedIntegerArray[] tables;

    public RecalibrationTables(Covariate[] covariates) {
        this(covariates, covariates[TableType.READ_GROUP_TABLE.index].maximumKeyValue() + 1);
    }

    public RecalibrationTables(Covariate[] covariates, int numReadGroups) {
        this.tables = new NestedIntegerArray[covariates.length];
        int qualDimension = covariates[TableType.QUALITY_SCORE_TABLE.index].maximumKeyValue() + 1;
        int eventDimension = EventType.values().length;
        this.tables[TableType.READ_GROUP_TABLE.index] = new NestedIntegerArray(numReadGroups, eventDimension);
        this.tables[TableType.QUALITY_SCORE_TABLE.index] = new NestedIntegerArray(numReadGroups, qualDimension, eventDimension);
        for (int i = TableType.OPTIONAL_COVARIATE_TABLES_START.index; i < covariates.length; ++i) {
            this.tables[i] = new NestedIntegerArray(numReadGroups, qualDimension, covariates[i].maximumKeyValue() + 1, eventDimension);
        }
    }

    public NestedIntegerArray<RecalDatum> getTable(TableType type) {
        return this.tables[type.index];
    }

    public NestedIntegerArray<RecalDatum> getTable(int index) {
        return this.tables[index];
    }

    public int numTables() {
        return this.tables.length;
    }

    public static enum TableType {
        READ_GROUP_TABLE(0),
        QUALITY_SCORE_TABLE(1),
        OPTIONAL_COVARIATE_TABLES_START(2);

        public final int index;

        private TableType(int index) {
            this.index = index;
        }
    }
}

