/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.activeregion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.activeregion.ActiveRegion;
import org.broadinstitute.sting.utils.activeregion.ActivityProfileResult;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ActivityProfile {
    final GenomeLocParser parser;
    final boolean presetRegions;
    GenomeLoc regionStartLoc = null;
    final List<ActivityProfileResult> isActiveList;
    private static final int FILTER_SIZE = 80;
    private static final double[] GaussianKernel = new double[161];

    public ActivityProfile(GenomeLocParser parser, boolean presetRegions) {
        this(parser, presetRegions, new ArrayList<ActivityProfileResult>(), null);
    }

    protected ActivityProfile(GenomeLocParser parser, boolean presetRegions, List<ActivityProfileResult> isActiveList, GenomeLoc regionStartLoc) {
        this.parser = parser;
        this.presetRegions = presetRegions;
        this.isActiveList = isActiveList;
        this.regionStartLoc = regionStartLoc;
    }

    public void add(GenomeLoc loc, ActivityProfileResult result) {
        if (loc.size() != 1) {
            throw new ReviewedStingException("Bad add call to ActivityProfile: loc " + loc + " size != 1");
        }
        this.isActiveList.add(result);
        if (this.regionStartLoc == null) {
            this.regionStartLoc = loc;
        }
    }

    public int size() {
        return this.isActiveList.size();
    }

    public ActivityProfile bandPassFilter() {
        double[] activeProbArray = new double[this.isActiveList.size()];
        int iii = 0;
        for (ActivityProfileResult result : this.isActiveList) {
            activeProbArray[iii++] = result.isActiveProb;
        }
        iii = 0;
        for (ActivityProfileResult result : this.isActiveList) {
            if (result.resultState.equals((Object)ActivityProfileResult.ActivityProfileResultState.HIGH_QUALITY_SOFT_CLIPS)) {
                int numHQClips = result.resultValue.intValue();
                for (int jjj = Math.max(0, iii - numHQClips); jjj < Math.min(activeProbArray.length, iii + numHQClips); ++jjj) {
                    activeProbArray[jjj] = Math.max(activeProbArray[jjj], activeProbArray[iii]);
                }
            }
            ++iii;
        }
        double[] filteredProbArray = new double[activeProbArray.length];
        if (!this.presetRegions) {
            for (iii = 0; iii < activeProbArray.length; ++iii) {
                double[] kernel = ArrayUtils.subarray(GaussianKernel, Math.max(80 - iii, 0), Math.min(GaussianKernel.length, 80 + activeProbArray.length - iii));
                double[] activeProbSubArray = ArrayUtils.subarray(activeProbArray, Math.max(0, iii - 80), Math.min(activeProbArray.length, iii + 80 + 1));
                filteredProbArray[iii] = MathUtils.dotProduct(activeProbSubArray, kernel);
            }
        }
        iii = 0;
        for (double prob : filteredProbArray) {
            ActivityProfileResult result = this.isActiveList.get(iii++);
            result.isActiveProb = prob;
            result.resultState = ActivityProfileResult.ActivityProfileResultState.NONE;
            result.resultValue = null;
        }
        return new ActivityProfile(this.parser, this.presetRegions, this.isActiveList, this.regionStartLoc);
    }

    public List<ActiveRegion> createActiveRegions(int activeRegionExtension, int maxRegionSize) {
        double ACTIVE_PROB_THRESHOLD = 0.002;
        ArrayList<ActiveRegion> returnList = new ArrayList<ActiveRegion>();
        if (this.isActiveList.size() == 0) {
            return Collections.emptyList();
        }
        if (this.isActiveList.size() == 1) {
            boolean isActive = this.isActiveList.get((int)0).isActiveProb > 0.002;
            returnList.addAll(this.createActiveRegion(isActive, 0, 0, activeRegionExtension, maxRegionSize));
        } else {
            boolean isActive = this.isActiveList.get((int)0).isActiveProb > 0.002;
            int curStart = 0;
            for (int iii = 1; iii < this.isActiveList.size(); ++iii) {
                boolean thisStatus;
                boolean bl = thisStatus = this.isActiveList.get((int)iii).isActiveProb > 0.002;
                if (isActive == thisStatus) continue;
                returnList.addAll(this.createActiveRegion(isActive, curStart, iii - 1, activeRegionExtension, maxRegionSize));
                isActive = thisStatus;
                curStart = iii;
            }
            returnList.addAll(this.createActiveRegion(isActive, curStart, this.isActiveList.size() - 1, activeRegionExtension, maxRegionSize));
        }
        return returnList;
    }

    private final List<ActiveRegion> createActiveRegion(boolean isActive, int curStart, int curEnd, int activeRegionExtension, int maxRegionSize) {
        return this.createActiveRegion(isActive, curStart, curEnd, activeRegionExtension, maxRegionSize, new ArrayList<ActiveRegion>());
    }

    private final List<ActiveRegion> createActiveRegion(boolean isActive, int curStart, int curEnd, int activeRegionExtension, int maxRegionSize, List<ActiveRegion> returnList) {
        if (!isActive || curEnd - curStart < maxRegionSize) {
            GenomeLoc loc = this.parser.createGenomeLoc(this.regionStartLoc.getContig(), this.regionStartLoc.getStart() + curStart, this.regionStartLoc.getStart() + curEnd);
            returnList.add(new ActiveRegion(loc, isActive, this.parser, activeRegionExtension));
            return returnList;
        }
        Double minProb = Double.MAX_VALUE;
        int cutPoint = -1;
        int size = curEnd - curStart + 1;
        for (int iii = curStart + (int)((double)size * 0.15); iii < curEnd - (int)((double)size * 0.15); ++iii) {
            if (!(this.isActiveList.get((int)iii).isActiveProb < minProb)) continue;
            minProb = this.isActiveList.get((int)iii).isActiveProb;
            cutPoint = iii;
        }
        List<ActiveRegion> leftList = this.createActiveRegion(isActive, curStart, cutPoint, activeRegionExtension, maxRegionSize, new ArrayList<ActiveRegion>());
        List<ActiveRegion> rightList = this.createActiveRegion(isActive, cutPoint + 1, curEnd, activeRegionExtension, maxRegionSize, new ArrayList<ActiveRegion>());
        returnList.addAll(leftList);
        returnList.addAll(rightList);
        return returnList;
    }

    static {
        for (int iii = 0; iii < 161; ++iii) {
            ActivityProfile.GaussianKernel[iii] = MathUtils.NormalDistribution(80.0, 55.0, iii);
        }
    }
}

