/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io.stubs;

import java.io.File;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import net.sf.samtools.SAMFileWriter;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.ArgumentException;
import org.broadinstitute.sting.commandline.ArgumentIOType;
import org.broadinstitute.sting.commandline.ArgumentMatches;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.MissingArgumentValueException;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.io.StingSAMFileWriter;
import org.broadinstitute.sting.gatk.io.stubs.SAMFileWriterStub;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class SAMFileWriterArgumentTypeDescriptor
extends ArgumentTypeDescriptor {
    public static final String DEFAULT_ARGUMENT_FULLNAME = "outputBAM";
    public static final String DEFAULT_ARGUMENT_SHORTNAME = "ob";
    public static final String COMPRESSION_FULLNAME = "bam_compression";
    public static final String COMPRESSION_SHORTNAME = "compress";
    public static final String SIMPLIFY_BAM_FULLNAME = "simplifyBAM";
    public static final String SIMPLIFY_BAM_SHORTNAME = "simplifyBAM";
    public static final String DISABLE_INDEXING_FULLNAME = "disable_bam_indexing";
    public static final String ENABLE_MD5_FULLNAME = "generate_md5";
    private final GenomeAnalysisEngine engine;
    private final OutputStream defaultOutputStream;

    public SAMFileWriterArgumentTypeDescriptor(GenomeAnalysisEngine engine, OutputStream defaultOutputStream) {
        this.engine = engine;
        this.defaultOutputStream = defaultOutputStream;
    }

    @Override
    public boolean supports(Class type) {
        return SAMFileWriter.class.equals((Object)type) || StingSAMFileWriter.class.equals((Object)type);
    }

    @Override
    public List<ArgumentDefinition> createArgumentDefinitions(ArgumentSource source) {
        return Arrays.asList(this.createBAMArgumentDefinition(source), this.createBAMCompressionArgumentDefinition(source), this.disableWriteIndexArgumentDefinition(source), this.enableMD5GenerationArgumentDefinition(source), this.createSimplifyBAMArgumentDefinition(source));
    }

    @Override
    public boolean createsTypeDefault(ArgumentSource source) {
        return source.isRequired();
    }

    @Override
    public String typeDefaultDocString(ArgumentSource source) {
        return "stdout";
    }

    @Override
    public Object createTypeDefault(ParsingEngine parsingEngine, ArgumentSource source, Type type) {
        if (!source.isRequired()) {
            throw new ReviewedStingException("BUG: tried to create type default for argument type descriptor that can't support a type default.");
        }
        SAMFileWriterStub stub = new SAMFileWriterStub(this.engine, this.defaultOutputStream);
        this.engine.addOutput(stub);
        return stub;
    }

    @Override
    public Object parse(ParsingEngine parsingEngine, ArgumentSource source, Type type, ArgumentMatches matches) {
        ArgumentDefinition bamArgumentDefinition = this.createBAMArgumentDefinition(source);
        String writerFileName = this.getArgumentValue(bamArgumentDefinition, matches);
        String compressionLevelText = this.getArgumentValue(this.createBAMCompressionArgumentDefinition(source), matches);
        Integer compressionLevel = compressionLevelText != null ? Integer.valueOf(compressionLevelText) : null;
        boolean indexOnTheFly = !this.argumentIsPresent(this.disableWriteIndexArgumentDefinition(source), matches);
        boolean generateMD5 = this.argumentIsPresent(this.enableMD5GenerationArgumentDefinition(source), matches);
        boolean simplifyBAM = this.argumentIsPresent(this.createSimplifyBAMArgumentDefinition(source), matches);
        if (writerFileName == null) {
            if (!source.isRequired()) {
                throw new MissingArgumentValueException(bamArgumentDefinition);
            }
            if (generateMD5) {
                throw new ArgumentException("MD5 generation specified, but no output file specified.  If md5 generation is desired, please specify a BAM output file and an md5 file will be written alongside.");
            }
        }
        SAMFileWriterStub stub = writerFileName != null ? new SAMFileWriterStub(this.engine, new File(writerFileName)) : new SAMFileWriterStub(this.engine, this.defaultOutputStream);
        if (compressionLevel != null) {
            stub.setCompressionLevel(compressionLevel);
        }
        if (indexOnTheFly) {
            stub.setIndexOnTheFly(indexOnTheFly);
        }
        if (generateMD5) {
            stub.setGenerateMD5(generateMD5);
        }
        if (simplifyBAM) {
            stub.setSimplifyBAM(simplifyBAM);
        }
        parsingEngine.addTags(stub, this.getArgumentTags(matches));
        this.engine.addOutput(stub);
        return stub;
    }

    private ArgumentDefinition createBAMArgumentDefinition(ArgumentSource source) {
        Annotation annotation = SAMFileWriterArgumentTypeDescriptor.getArgumentAnnotation(source);
        return new ArgumentDefinition(annotation, ArgumentIOType.getIOType(annotation), source.field.getType(), DEFAULT_ARGUMENT_FULLNAME, DEFAULT_ARGUMENT_SHORTNAME, ArgumentDefinition.getDoc(annotation), false, false, source.isMultiValued(), source.isHidden(), null, null, null, null);
    }

    private ArgumentDefinition createBAMCompressionArgumentDefinition(ArgumentSource source) {
        return new ArgumentDefinition(ArgumentIOType.ARGUMENT, Integer.TYPE, COMPRESSION_FULLNAME, COMPRESSION_SHORTNAME, "Compression level to use for writing BAM files", false, false, false, source.isHidden(), null, null, null, null);
    }

    private ArgumentDefinition disableWriteIndexArgumentDefinition(ArgumentSource source) {
        return new ArgumentDefinition(ArgumentIOType.ARGUMENT, Boolean.TYPE, DISABLE_INDEXING_FULLNAME, null, "Turn off on-the-fly creation of indices for output BAM files.", false, true, false, source.isHidden(), null, null, null, null);
    }

    private ArgumentDefinition enableMD5GenerationArgumentDefinition(ArgumentSource source) {
        return new ArgumentDefinition(ArgumentIOType.ARGUMENT, Boolean.TYPE, ENABLE_MD5_FULLNAME, null, "Enable on-the-fly creation of md5s for output BAM files.", false, true, false, source.isHidden(), null, null, null, null);
    }

    private ArgumentDefinition createSimplifyBAMArgumentDefinition(ArgumentSource source) {
        return new ArgumentDefinition(ArgumentIOType.ARGUMENT, Boolean.TYPE, "simplifyBAM", "simplifyBAM", "If provided, output BAM files will be simplified to include just key reads for downstream variation discovery analyses (removing duplicates, PF-, non-primary reads), as well stripping all extended tags from the kept reads except the read group identifier", false, true, false, source.isHidden(), null, null, null, null);
    }
}

