/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.filters;

import java.util.Collection;
import java.util.List;
import org.broadinstitute.sting.gatk.filters.ReadFilter;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.help.GATKDocUtils;

public class FilterManager
extends PluginManager<ReadFilter> {
    public FilterManager() {
        super(ReadFilter.class, "filter", "Filter");
    }

    public ReadFilter createFilterByType(Class<? extends ReadFilter> filterType) {
        return (ReadFilter)this.createByName(this.getName(filterType));
    }

    public Collection<Class<? extends ReadFilter>> getValues() {
        return this.getPlugins();
    }

    @Override
    protected String formatErrorMessage(String pluginCategory, String pluginName) {
        List<Class<? extends ReadFilter>> availableFilters = this.getPluginsImplementing(ReadFilter.class);
        return String.format("Read filter %s not found. Available read filters:%n%n%s%n%n%s", pluginName, this.userFriendlyListofReadFilters(availableFilters), "Please consult the GATK Documentation (http://www.broadinstitute.org/gatk/gatkdocs/) for more information.");
    }

    private String userFriendlyListofReadFilters(List<Class<? extends ReadFilter>> filters) {
        String headName = "FilterName";
        String headDoc = "Documentation";
        int longestNameLength = -1;
        for (Class<? extends ReadFilter> filter : filters) {
            longestNameLength = Math.max(longestNameLength, this.getName(filter).length());
        }
        String format = "   %" + longestNameLength + "s        %s%n";
        StringBuilder listBuilder = new StringBuilder();
        listBuilder.append(String.format(format, "FilterName", "Documentation"));
        for (Class<? extends ReadFilter> filter : filters) {
            String helpLink = GATKDocUtils.helpLinksToGATKDocs(filter);
            String filterName = this.getName(filter);
            listBuilder.append(String.format(format, filterName, helpLink));
        }
        return listBuilder.toString();
    }
}

