/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect;

import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidGenotype;
import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidSNPGenotypeLikelihoods;
import org.broadinstitute.sting.utils.BaseUtils;

public class VariableAllelicRatioGenotypeLikelihoods
extends DiploidSNPGenotypeLikelihoods {
    protected double logF;
    protected double logOneMinusF;
    protected double logHalf;
    protected char ref;

    public VariableAllelicRatioGenotypeLikelihoods(char ref, double f) {
        super(0.0);
        this.ref = ref;
        this.logF = Math.log10(1.0 / f);
        this.logOneMinusF = Math.log10(1.0 / (1.0 - f));
        this.logHalf = Math.log10(2.0);
    }

    public double getLikelihood(DiploidGenotype g) {
        return this.getLikelihoods()[g.ordinal()];
    }

    @Override
    protected DiploidSNPGenotypeLikelihoods calculateGenotypeLikelihoods(byte observedBase1, byte qualityScore1, byte observedBase2, byte qualityScore2) {
        double[] log10FourBaseLikelihoods = this.computeLog10Likelihoods(observedBase1, qualityScore1, observedBase2, qualityScore2);
        try {
            VariableAllelicRatioGenotypeLikelihoods gl = (VariableAllelicRatioGenotypeLikelihoods)this.clone();
            gl.setToZero();
            for (DiploidGenotype g : DiploidGenotype.values()) {
                double fBase2;
                double fBase1;
                if (g.base1 == this.ref || g.base2 == this.ref) {
                    if (g.base1 == g.base2) {
                        fBase1 = this.logHalf;
                        fBase2 = this.logHalf;
                    } else {
                        fBase1 = g.base1 == this.ref ? this.logOneMinusF : this.logF;
                        fBase2 = g.base2 == this.ref ? this.logOneMinusF : this.logF;
                    }
                } else {
                    fBase1 = this.logHalf;
                    fBase2 = this.logHalf;
                }
                double p_base = 0.0;
                p_base += Math.pow(10.0, log10FourBaseLikelihoods[BaseUtils.simpleBaseToBaseIndex(g.base1)] - fBase1);
                double likelihood = Math.log10(p_base += Math.pow(10.0, log10FourBaseLikelihoods[BaseUtils.simpleBaseToBaseIndex(g.base2)] - fBase2));
                int n = g.ordinal();
                gl.log10Likelihoods[n] = gl.log10Likelihoods[n] + likelihood;
            }
            if (this.VERBOSE) {
                for (DiploidGenotype g : DiploidGenotype.values()) {
                    System.out.printf("%s\t", new Object[]{g});
                }
                System.out.println();
                for (DiploidGenotype g : DiploidGenotype.values()) {
                    System.out.printf("%.2f\t", gl.log10Likelihoods[g.ordinal()]);
                }
                System.out.println();
            }
            return gl;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int add(byte observedBase1, byte qualityScore1) {
        byte observedBase2 = 0;
        byte qualityScore2 = 0;
        DiploidSNPGenotypeLikelihoods gl = !this.inCache(observedBase1, qualityScore1, observedBase2, qualityScore2, 2) ? this.calculateCachedGenotypeLikelihoods(observedBase1, qualityScore1, observedBase2, qualityScore2, 2) : this.getCachedGenotypeLikelihoods(observedBase1, qualityScore1, observedBase2, qualityScore2, 2);
        double[] likelihoods = gl.getLikelihoods();
        for (DiploidGenotype g : DiploidGenotype.values()) {
            double likelihood = likelihoods[g.ordinal()];
            int n = g.ordinal();
            this.log10Likelihoods[n] = this.log10Likelihoods[n] + likelihood;
        }
        return 1;
    }

    @Override
    protected boolean inCache(byte observedBase1, byte qualityScore1, byte observedBase2, byte qualityScore2, int ploidy) {
        return false;
    }

    @Override
    protected void setCache(DiploidSNPGenotypeLikelihoods[][][][][] cache, byte observedBase1, byte qualityScore1, byte observedBase2, byte qualityScore2, int ploidy, DiploidSNPGenotypeLikelihoods val) {
    }
}

