/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect;

import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.BinomialDistributionImpl;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.AbstractPowerCalculator;

public class NormalPowerCalculator
extends AbstractPowerCalculator {
    private static double Q30_EPS = Math.pow(10.0, -3.0) / 3.0;
    private static double LOD = 2.3;

    public static void main(String[] argv) throws MathException {
        double wiggle = 1.0E-6;
        NormalPowerCalculator.test(NormalPowerCalculator.testCalculatePower(50, Q30_EPS, LOD), 1.0, wiggle, "Failed!");
        NormalPowerCalculator.test(NormalPowerCalculator.testCalculatePower(10, Q30_EPS, LOD), 0.9973492, wiggle, "Failed!");
        NormalPowerCalculator.test(NormalPowerCalculator.testCalculatePower(8, Q30_EPS, LOD), 0.9974184, wiggle, "Failed!");
        NormalPowerCalculator.test(NormalPowerCalculator.testCalculatePower(5, Q30_EPS, LOD), 0.0, wiggle, "Failed!");
        NormalPowerCalculator.test(NormalPowerCalculator.testCalculatePower(10, Math.pow(10.0, -2.0) / 3.0, LOD), 0.9762534, wiggle, "Failed!");
        NormalPowerCalculator pc = new NormalPowerCalculator(Q30_EPS, LOD);
        NormalPowerCalculator.test(pc.cachingPowerCalculation(10), 0.9973492, wiggle, "Failed!");
        NormalPowerCalculator.test(pc.cachingPowerCalculation(10), 0.9973492, wiggle, "Failed!");
        NormalPowerCalculator.test(pc.cachingPowerCalculation(10), 0.9973492, wiggle, "Failed!");
    }

    private static double testCalculatePower(int n, double eps, double threshold) throws MathException {
        double power = NormalPowerCalculator.calculatePower(n, eps, threshold);
        System.out.println("Depth: " + n + " EPS: " + eps + " Threshols: " + threshold + " --> Power: " + power);
        return power;
    }

    public NormalPowerCalculator(double constantEps, double constantLodThreshold) {
        this.constantEps = constantEps;
        this.constantLodThreshold = constantLodThreshold;
    }

    public double cachingPowerCalculation(int n) throws MathException {
        AbstractPowerCalculator.PowerCacheKey key = new AbstractPowerCalculator.PowerCacheKey(n, 0.5);
        Double power = (Double)this.cache.get(key);
        if (power == null) {
            power = NormalPowerCalculator.calculatePower(n, this.constantEps, this.constantLodThreshold);
            this.cache.put(key, power);
        }
        return power;
    }

    private static double calculateNormalLod(int depth, int alts, double eps) {
        return NormalPowerCalculator.calculateLogLikelihood(depth, alts, eps, 0.0) - NormalPowerCalculator.calculateLogLikelihood(depth, alts, eps, 0.5);
    }

    private static double calculatePower(int depth, double eps, double lodThreshold) throws MathException {
        if (depth == 0) {
            return 0.0;
        }
        BinomialDistributionImpl binom = new BinomialDistributionImpl(depth, eps);
        double[] p = new double[depth + 1];
        for (int i = 0; i < p.length; ++i) {
            p[i] = binom.probability(depth - i);
        }
        double[] lod = new double[depth + 1];
        for (int i = 0; i < lod.length; ++i) {
            lod[i] = NormalPowerCalculator.calculateNormalLod(depth, depth - i, eps);
        }
        int k = -1;
        for (int i = 0; i < lod.length; ++i) {
            if (!(lod[i] >= lodThreshold)) continue;
            k = i;
            break;
        }
        if (k == -1) {
            return 0.0;
        }
        double power = 0.0;
        if (k > 0) {
            double x = 1.0 - (lodThreshold - lod[k - 1]) / (lod[k] - lod[k - 1]);
            power = x * p[k - 1];
        }
        for (int i = k; i < p.length; ++i) {
            power += p[i];
        }
        return power;
    }
}

