/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.picard.util.FormatUtil;
import net.sf.samtools.util.StringUtil;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.CandidateMutation;
import org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect.RankSumTest;

public class CallStatsGenerator {
    private static final String TAB = "\t";
    private final FormatUtil fmt = new FormatUtil();
    private int[] minimalHeaderIndicies;
    private static final String[] COMPLETE_CALL_STATS_HEADER = new String[]{"contig", "position", "context", "ref_allele", "alt_allele", "tumor_name", "normal_name", "score", "dbsnp_site", "covered", "power", "tumor_power", "normal_power", "normal_power_nsp", "normal_power_wsp", "total_pairs", "improper_pairs", "map_Q0_reads", "init_t_lod", "t_lod_fstar", "t_lod_lqs", "t_lod_fstar_forward", "t_lod_fstar_reverse", "tumor_f", "tumor_f_lb", "contaminant_fraction", "contaminant_lod", "minimum_tumor_f", "t_q20_count", "t_ref_count", "t_alt_count", "t_ref_sum", "t_alt_sum", "t_ref_max_mapq", "t_alt_max_mapq", "t_ins_count", "t_del_count", "normal_best_gt", "init_n_lod", "n_lod_fstar", "normal_f", "normal_f_quals", "normal_artifact_lod_tf", "normal_artifact_lod_low_tf", "normal_artifact_lod_nf", "normal_artifact_lod_nfq", "n_q20_count", "n_ref_count", "n_alt_count", "n_ref_sum", "n_alt_sum", "at_risk_positive_direction_artifact", "at_risk_negative_direction_artifact", "powered_positive_direction_artifact", "power_to_detect_positive_strand_artifact", "powered_negative_direction_artifact", "power_to_detect_negative_strand_artifact", "perfect_strand_bias", "strand_bias_counts", "strand_bias", "classic_max_skew_lod", "classic_max_skew_lod_offset", "fisher_min_skew_pvalue", "fisher_min_skew_pvalue_offset", "tumor_qsrst_ms", "tumor_qsrst_pval", "tumor_rprst_ms", "tumor_rprst_pval", "tumor_alt_fpir_median", "tumor_alt_fpir_mad", "tumor_alt_rpir_median", "tumor_alt_rpir_mad", "alt_fpir", "alt_rpir", "powered_filters", "normal_artifact_power_tf", "normal_artifact_power_low_tf", "normal_artifact_power_nf", "normal_global_qll", "normal_local_qll", "normal_qmodel_lod", "observed_in_normals_count", "failure_reasons", "judgement"};
    private static final String[] MINIMAL_CALL_STATS_HEADER = new String[]{"contig", "position", "context", "ref_allele", "alt_allele", "tumor_name", "normal_name", "score", "dbsnp_site", "covered", "power", "tumor_power", "normal_power", "total_pairs", "improper_pairs", "map_Q0_reads", "t_lod_fstar", "tumor_f", "contaminant_fraction", "contaminant_lod", "t_ref_count", "t_alt_count", "t_ref_sum", "t_alt_sum", "t_ref_max_mapq", "t_alt_max_mapq", "t_ins_count", "t_del_count", "normal_best_gt", "init_n_lod", "n_ref_count", "n_alt_count", "n_ref_sum", "n_alt_sum", "judgement"};
    private boolean enableExtendedOutput;

    public CallStatsGenerator(boolean enableExtendedOutput) {
        this.enableExtendedOutput = enableExtendedOutput;
    }

    public String generateHeader() {
        String header;
        if (this.enableExtendedOutput) {
            header = StringUtil.join(TAB, COMPLETE_CALL_STATS_HEADER);
        } else {
            header = StringUtil.join(TAB, MINIMAL_CALL_STATS_HEADER);
            this.minimalHeaderIndicies = new int[MINIMAL_CALL_STATS_HEADER.length];
            for (int i = 0; i < MINIMAL_CALL_STATS_HEADER.length; ++i) {
                String column = MINIMAL_CALL_STATS_HEADER[i];
                for (int j = 0; j < COMPLETE_CALL_STATS_HEADER.length; ++j) {
                    if (!COMPLETE_CALL_STATS_HEADER[j].equals(column)) continue;
                    this.minimalHeaderIndicies[i] = j;
                }
            }
        }
        return header;
    }

    public String generateCallStats(CandidateMutation candidate) {
        RankSumTest.Result qrst = candidate.getTumorQualityRankSumTest();
        RankSumTest.Result prst = candidate.getTumorReadPositionRankSumTest();
        Double classicSkewScore = null;
        Integer classicSkewOffset = null;
        Map<Integer, Double> classicSkewInfo = candidate.getClassicSkewScoresAndOffsets();
        if (classicSkewInfo != null && classicSkewInfo.size() > 0) {
            classicSkewOffset = this.getKeyForLargestValue(classicSkewInfo);
            classicSkewScore = classicSkewInfo.get(classicSkewOffset);
            if (classicSkewScore == Double.POSITIVE_INFINITY) {
                classicSkewScore = 999999.0;
            } else if (classicSkewScore == Double.NEGATIVE_INFINITY) {
                classicSkewScore = -999999.0;
            }
        }
        Double fisherSkewScore = null;
        Integer fisherSkewOffset = null;
        Map<Integer, Double> fisherSkewInfo = candidate.getFisherSkewScoresAndOffsets();
        if (fisherSkewInfo != null && fisherSkewInfo.size() > 0) {
            fisherSkewOffset = this.getKeyForSmallestValue(fisherSkewInfo);
            fisherSkewScore = fisherSkewInfo.get(fisherSkewOffset);
        }
        String keepString = "REJECT";
        if (!candidate.isRejected()) {
            keepString = "KEEP";
        }
        String siteInfo = "NOVEL";
        if (candidate.isDbsnpSite()) {
            siteInfo = "DBSNP";
        }
        if (candidate.isCosmicSite()) {
            siteInfo = "COSMIC";
        }
        if (candidate.isDbsnpSite() && candidate.isCosmicSite()) {
            siteInfo = "DBSNP+COSMIC";
        }
        String[] msg = new String[]{candidate.getLocation().getContig(), this.format(candidate.getLocation().getStart()), candidate.getSequenceContext(), "" + candidate.getRefAllele(), "" + candidate.getAltAllele(), candidate.getTumorSampleName(), candidate.getNormalSampleName(), this.format(candidate.getScore()), siteInfo, candidate.isCovered() ? "COVERED" : "UNCOVERED", this.format(candidate.getPower()), this.format(candidate.getTumorPower()), this.format(candidate.getNormalPower()), this.format(candidate.getNormalPowerNoSNPPrior()), this.format(candidate.getNormalPowerWithSNPPrior()), this.format(candidate.getTotalPairs()), this.format(candidate.getImproperPairs()), this.format(candidate.getMapQ0Reads()), this.format(candidate.getInitialTumorLod()), this.format(candidate.getTumorLodFStar()), this.format(candidate.getTumorLodLQS()), this.format(candidate.getTumorLodFStarForward()), this.format(candidate.getTumorLodFStarReverse()), this.format(candidate.getTumorF()), this.format(candidate.getTumorFLowerBound()), this.format(candidate.getContaminationFraction()), this.format(candidate.getContaminantLod()), this.format("n/a"), this.format(candidate.getTumorQ20Count()), this.format(candidate.getInitialTumorRefCounts()), this.format(candidate.getInitialTumorAltCounts()), this.format(candidate.getInitialTumorRefQualitySum()), this.format(candidate.getInitialTumorAltQualitySum()), this.format(candidate.getTumorRefMaxMapQ()), this.format(candidate.getTumorAltMaxMapQ()), this.format(candidate.getTumorInsertionCount()), this.format(candidate.getTumorDeletionCount()), this.format(candidate.getInitialNormalBestGenotype().toString()), this.format(candidate.getInitialNormalLod()), this.format(candidate.getNormalLodFStar()), this.format(candidate.getNormalF()), this.format(candidate.getNormalFQuals()), this.format(candidate.getNormalArtifactLodTF()), this.format(candidate.getNormalArtifactLodLowTF()), this.format(candidate.getNormalArtifactLodNF()), this.format(candidate.getNormalArtifactLodNFQ()), this.format(candidate.getNormalQ20Count()), this.format(candidate.getInitialNormalRefCounts()), this.format(candidate.getInitialNormalAltCounts()), this.format(candidate.getInitialNormalRefQualitySum()), this.format(candidate.getInitialNormalAltQualitySum()), this.format(candidate.isPositiveDirectionAtRisk() ? 1 : 0), this.format(candidate.isNegativeDirectionAtRisk() ? 1 : 0), this.format(candidate.isPositiveDirectionPowered() ? 1 : 0), this.format(candidate.getPowerToDetectPositiveStrandArtifact()), this.format(candidate.isNegativeDirectionPowered() ? 1 : 0), this.format(candidate.getPowerToDetectNegativeStrandArtifact()), this.format(candidate.getPerfectStrandBias().getP()), this.format(candidate.getStrandBias().dataToString()), this.format(candidate.getStrandBias().getP()), this.format(classicSkewScore), this.format(classicSkewOffset), this.format(fisherSkewScore), this.format(fisherSkewOffset), qrst == null ? "n/a" : this.format(candidate.getTumorQualityRankSumTest().getMedianShift()), qrst == null ? "n/a" : this.format(candidate.getTumorQualityRankSumTest().getP()), prst == null ? "n/a" : this.format(candidate.getTumorReadPositionRankSumTest().getMedianShift()), prst == null ? "n/a" : this.format(candidate.getTumorReadPositionRankSumTest().getP()), candidate.getTumorForwardOffsetsInReadMedian() == null ? "n/a" : this.format(candidate.getTumorForwardOffsetsInReadMedian()), candidate.getTumorForwardOffsetsInReadMad() == null ? "n/a" : this.format(candidate.getTumorForwardOffsetsInReadMad()), candidate.getTumorReverseOffsetsInReadMedian() == null ? "n/a" : this.format(candidate.getTumorReverseOffsetsInReadMedian()), candidate.getTumorReverseOffsetsInReadMad() == null ? "n/a" : this.format(candidate.getTumorReverseOffsetsInReadMad()), candidate.getTumorAltForwardOffsetsInRead().size() > 500 ? "too_many" : StringUtil.join(",", this.listToString(candidate.getTumorAltForwardOffsetsInRead())), candidate.getTumorAltReverseOffsetsInRead().size() > 500 ? "too_many" : StringUtil.join(",", this.listToString(candidate.getTumorAltReverseOffsetsInRead())), StringUtil.join(",", candidate.getPoweredFilters().toArray(new String[0])), this.format(candidate.getNormalArtifactPowerTF()), this.format(candidate.getNormalArtifactPowerLowTF()), this.format(candidate.getNormalArtifactPowerNF()), this.format(candidate.getNormalGlobalQualityReferenceLL()), this.format(candidate.getNormalLocalQualityReferenceLL()), this.format(candidate.getNormalQualityModelLod()), this.format(candidate.getCountOfNormalsObservedIn()), StringUtil.join(",", candidate.getRejectionReasons().toArray(new String[0])), keepString};
        if (this.enableExtendedOutput) {
            for (int i = 0; i < msg.length; ++i) {
                if (msg[i] != null) continue;
                System.out.println("ERROR: found null in output at position " + i);
            }
            return StringUtil.join(TAB, msg);
        }
        ArrayList<String> output = new ArrayList<String>();
        for (int index : this.minimalHeaderIndicies) {
            output.add(msg[index]);
        }
        return StringUtil.join(TAB, output);
    }

    private String format(String s) {
        return s;
    }

    private String format(Integer i) {
        return this.fmt.format(i);
    }

    private String format(Float f) {
        return this.format(Double.valueOf(f.floatValue()));
    }

    private String format(Double d) {
        if (d == null) {
            return "n/a";
        }
        String s = this.fmt.format(d);
        return "-0".equals(s) ? "0" : s;
    }

    private String[] listToString(List<Integer> ints) {
        String[] out = new String[ints.size()];
        for (int i = 0; i < ints.size(); ++i) {
            out[i] = ints.get(i).toString();
        }
        return out;
    }

    private Integer getKeyForSmallestValue(Map<Integer, Double> map) {
        Integer key = null;
        Double smallest = null;
        for (Map.Entry<Integer, Double> e : map.entrySet()) {
            if (smallest != null && !(e.getValue() < smallest)) continue;
            key = e.getKey();
            smallest = e.getValue();
        }
        return key;
    }

    private Integer getKeyForLargestValue(Map<Integer, Double> map) {
        Integer key = null;
        Double largest = null;
        for (Map.Entry<Integer, Double> e : map.entrySet()) {
            if (largest != null && !(e.getValue() > largest)) continue;
            key = e.getKey();
            largest = e.getValue();
        }
        return key;
    }
}

